/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.parser;

import java.util.ArrayList;
import java.util.List;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.LogLevel;

public class SgfParserLogger {
    private final List<Message> messages_;

    public SgfParserLogger() {
        this.messages_ = new ArrayList<Message>();
    }

    public SgfParserLogger(SgfParserLogger sgfParserLogger) {
        ArgumentChecker.throwIfNull((Object)sgfParserLogger);
        this.messages_ = new ArrayList<Message>(sgfParserLogger.messages_);
    }

    public void addMessage(Message message) {
        ArgumentChecker.throwIfNull((Object)message);
        this.messages_.add(message);
    }

    public void log(LogLevel logLevel, int n, String string, String string2) {
        this.addMessage(new Message(logLevel, n, string, string2));
    }

    public void error(int n, String string, String string2) {
        this.addMessage(new Message(LogLevel.ERROR, n, string, string2));
    }

    public void warn(int n, String string, String string2) {
        this.addMessage(new Message(LogLevel.WARN, n, string, string2));
    }

    public void info(int n, String string, String string2) {
        this.addMessage(new Message(LogLevel.INFO, n, string, string2));
    }

    public Message[] getMessages(LogLevel logLevel) {
        ArgumentChecker.throwIfNull((Object)logLevel);
        ArrayList<Message> arrayList = new ArrayList<Message>(this.messages_.size());
        for (int i = 0; i < this.messages_.size(); ++i) {
            Message message = this.messages_.get(i);
            if (logLevel.getRank() < message.level_.getRank()) continue;
            arrayList.add(message);
        }
        return arrayList.toArray(new Message[arrayList.size()]);
    }

    public Message[] getAllMessages() {
        return this.messages_.toArray(new Message[this.messages_.size()]);
    }

    public static class Message {
        private final LogLevel level_;
        private final int line_;
        private final String message_;
        private final String fragment_;

        public Message(LogLevel logLevel, int n, String string, String string2) {
            ArgumentChecker.throwIfNull((Object)logLevel, (Object)string, (Object)string2);
            this.level_ = logLevel;
            this.line_ = n;
            this.message_ = string;
            this.fragment_ = string2;
        }

        public LogLevel getLevel() {
            return this.level_;
        }

        public int getLine() {
            return this.line_;
        }

        public String getMessage() {
            return this.message_;
        }

        public String getFragment() {
            return this.fragment_;
        }
    }
}

