/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.type;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.ValueType;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.sgf.type.TypedString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SgfDouble implements TypedString<SgfDouble>
{
    NORMAL("1"),
    EMPHASIZED("2");

    private static final Log log_s_;
    private static final Pattern condition_s_;
    private static final int POS = 0;
    private final String value_;

    public static SgfDouble parse(String string) throws TypeParseException {
        ArgumentChecker.throwIfNull((Object)string);
        Matcher matcher = condition_s_.matcher(string);
        if (!matcher.matches()) {
            throw new TypeParseException("Bad argument value = " + string);
        }
        String string2 = matcher.group(0);
        return string2.equals(SgfDouble.NORMAL.value_) ? NORMAL : EMPHASIZED;
    }

    public static SgfDouble parseQuietly(String string) {
        try {
            return SgfDouble.parse(string);
        }
        catch (TypeParseException typeParseException) {
            log_s_.debug("Bad value for parse: " + string, typeParseException);
            return null;
        }
    }

    public static boolean isValid(String string) {
        Matcher matcher = condition_s_.matcher(string);
        return matcher.matches();
    }

    private SgfDouble(String string2) {
        this.value_ = string2;
    }

    @Override
    public boolean acceptable(SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sgfId);
        return ValueType.DOUBLE.equals((Object)sgfId.valueType());
    }

    @Override
    public String getString() {
        return this.value_;
    }

    static {
        log_s_ = LogFactory.getLog(SgfDouble.class);
        condition_s_ = Pattern.compile("1|2");
    }
}

