/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.Fingerprint;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.sgf.util.filter.MirrorXFilter;
import org.unitarou.sgf.util.filter.ReflectionFilter;
import org.unitarou.sgf.util.filter.Rotate180Filter;
import org.unitarou.sgf.util.filter.Rotate270Filter;
import org.unitarou.sgf.util.filter.Rotate90Filter;
import org.unitarou.util.Filter;
import org.unitarou.util.NullFilter;
import org.unitarou.yukinoshita.model.board.IgoBoard;
import org.unitarou.yukinoshita.model.board.PrintingIgoBoard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Fingerprints {
    public static Fingerprint calcFingerprint(RootGameTree rootGameTree) {
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        PrintingIgoBoard printingIgoBoard = new PrintingIgoBoard(rootGameTree);
        Map<SgfColor, Set<SgfPoint>> map = printingIgoBoard.getAllStones();
        StoneSet stoneSet = Fingerprints.select(rootGameTree.getSize(), map.get(SgfColor.WHITE), map.get(SgfColor.BLACK));
        Fingerprint fingerprint = new Fingerprint(rootGameTree.getSize());
        fingerprint.setFilter(stoneSet.filter_);
        fingerprint.setStoneNoFilter(stoneSet.whiteStones_, (byte)2);
        fingerprint.setStoneNoFilter(stoneSet.blackStones_, (byte)1);
        return fingerprint;
    }

    public static byte[] calcFingerprintArray(RootGameTree rootGameTree) {
        Fingerprint fingerprint = Fingerprints.calcFingerprint(rootGameTree);
        return fingerprint.getBytes();
    }

    @Deprecated
    public static byte[] calcFingerprint(IgoBoard igoBoard) {
        SgfSize sgfSize = igoBoard.size();
        byte[] byArray = new byte[Fingerprints.getArrayLength(sgfSize)];
        StoneSet stoneSet = Fingerprints.select(sgfSize, igoBoard.position(SgfColor.WHITE), igoBoard.position(SgfColor.BLACK));
        Fingerprints.setStone(byArray, stoneSet.whiteStones_, sgfSize, (byte)2);
        Fingerprints.setStone(byArray, stoneSet.blackStones_, sgfSize, (byte)1);
        return byArray;
    }

    private static void setStone(byte[] byArray, Set<SgfPoint> set, SgfSize sgfSize, byte by) {
        for (SgfPoint sgfPoint : set) {
            int n = (sgfPoint.y() - 1) * sgfSize.width() + (sgfPoint.x() - 1);
            int n2 = n / 4;
            int n3 = (3 - n % 4) * 2;
            byte by2 = by;
            by2 = (byte)(by2 << n3);
            int n4 = n2;
            byArray[n4] = (byte)(byArray[n4] & ~(3 << n3));
            int n5 = n2;
            byArray[n5] = (byte)(byArray[n5] | by2);
        }
    }

    public static int getArrayLength(SgfSize sgfSize) {
        return (int)Math.ceil((double)sgfSize.width() * (double)sgfSize.height() / 4.0);
    }

    public static List<Filter<SgfPoint>> getFilterList(SgfSize sgfSize) {
        boolean bl = sgfSize.width() == sgfSize.height();
        ArrayList<Filter<SgfPoint>> arrayList = new ArrayList<Filter<SgfPoint>>(8);
        arrayList.add(new NullFilter());
        if (bl) {
            arrayList.add(new Rotate90Filter());
            arrayList.add(new Rotate270Filter());
            arrayList.add(new ReflectionFilter());
            arrayList.add(new Rotate180Filter(new ReflectionFilter()));
        }
        arrayList.add(new Rotate180Filter());
        arrayList.add(new MirrorXFilter());
        arrayList.add(new Rotate180Filter(new MirrorXFilter()));
        return arrayList;
    }

    public static byte[][] calcAllFingerprint(RootGameTree rootGameTree) {
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        SgfSize sgfSize = rootGameTree.getSize();
        List<Filter<SgfPoint>> list = Fingerprints.getFilterList(sgfSize);
        ArrayList<StoneSet> arrayList = new ArrayList<StoneSet>(list.size());
        PrintingIgoBoard printingIgoBoard = new PrintingIgoBoard(rootGameTree);
        Map<SgfColor, Set<SgfPoint>> map = printingIgoBoard.getAllStones();
        Set<SgfPoint> set = map.get(SgfColor.WHITE);
        Set<SgfPoint> set2 = map.get(SgfColor.BLACK);
        for (Filter<SgfPoint> filter : list) {
            arrayList.add(Fingerprints.filter(filter, set, set2));
        }
        Object object = new byte[list.size()][Fingerprints.getArrayLength(sgfSize)];
        for (int i = 0; i < ((Object)object).length; ++i) {
            Fingerprints.setStone((byte[])object[i], ((StoneSet)arrayList.get(i)).whiteStones_, sgfSize, (byte)2);
            Fingerprints.setStone((byte[])object[i], ((StoneSet)arrayList.get(i)).blackStones_, sgfSize, (byte)1);
        }
        return object;
    }

    public static byte[][] calcAllFingerprint(SgfSize sgfSize, Set<SgfPoint> set, byte by, byte by2) {
        ArgumentChecker.throwIfNull((Object)sgfSize, set);
        if (by < 0 || 3 < by) {
            throw new IllegalArgumentException();
        }
        List<Filter<SgfPoint>> list = Fingerprints.getFilterList(sgfSize);
        HashSet<SgfPoint> hashSet = new HashSet<SgfPoint>(set.size());
        byte[][] byArray = new byte[list.size()][Fingerprints.getArrayLength(sgfSize)];
        for (int i = 0; i < byArray.length; ++i) {
            hashSet.clear();
            Filter<SgfPoint> filter = list.get(i);
            for (SgfPoint sgfPoint : set) {
                if (!SgfPointType.IN.equals((Object)sgfPoint.condition())) continue;
                hashSet.add(filter.filter(sgfPoint));
            }
            Fingerprints.setStone(byArray[i], sgfSize.all(), sgfSize, by2);
            Fingerprints.setStone(byArray[i], hashSet, sgfSize, by);
        }
        return byArray;
    }

    private static StoneSet select(SgfSize sgfSize, Set<SgfPoint> set, Set<SgfPoint> set2) {
        List<Filter<SgfPoint>> list = Fingerprints.getFilterList(sgfSize);
        ArrayList<StoneSet> arrayList = new ArrayList<StoneSet>(8);
        for (Filter<SgfPoint> filter : list) {
            arrayList.add(Fingerprints.filter(filter, set, set2));
        }
        int n = Integer.MIN_VALUE;
        for (int i = 1; i <= sgfSize.height(); ++i) {
            for (int j = 1; j <= sgfSize.width(); ++j) {
                StoneSet stoneSet;
                SgfPoint sgfPoint = SgfPoint.create(sgfSize, j, i);
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    stoneSet.point_ += (stoneSet = (StoneSet)iterator.next()).whiteStones_.contains(sgfPoint) ? 2 : (stoneSet.blackStones_.contains(sgfPoint) ? 1 : 0);
                    n = Math.max(n, stoneSet.point_);
                }
                iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    stoneSet = (StoneSet)iterator.next();
                    if (stoneSet.point_ >= n) continue;
                    iterator.remove();
                }
                if (arrayList.size() == 1) break;
            }
            if (arrayList.size() == 1) break;
        }
        return (StoneSet)arrayList.get(0);
    }

    private static StoneSet filter(Filter<SgfPoint> filter, Set<SgfPoint> set, Set<SgfPoint> set2) {
        StoneSet stoneSet = new StoneSet();
        stoneSet.filter_ = filter;
        stoneSet.point_ = 0;
        stoneSet.whiteStones_ = new HashSet(set.size());
        stoneSet.blackStones_ = new HashSet(set2.size());
        for (SgfPoint sgfPoint : set) {
            stoneSet.whiteStones_.add(filter.filter(sgfPoint));
        }
        for (SgfPoint sgfPoint : set2) {
            stoneSet.blackStones_.add(filter.filter(sgfPoint));
        }
        return stoneSet;
    }

    public static SgfColor getColor(byte[] byArray, SgfSize sgfSize, int n, int n2) {
        switch (Fingerprints.getValue(byArray, sgfSize, n, n2)) {
            case 0: {
                return null;
            }
            case 1: {
                return SgfColor.BLACK;
            }
            case 2: {
                return SgfColor.WHITE;
            }
        }
        return null;
    }

    public static byte getValue(byte[] byArray, SgfSize sgfSize, int n, int n2) {
        int n3 = (n2 - 1) * sgfSize.width() + (n - 1);
        int n4 = n3 / 4;
        byte by = byArray[n4];
        int n5 = (3 - n3 % 4) * 2;
        by = (byte)(by >> n5);
        by = (byte)(by & 3);
        return by;
    }

    private Fingerprints() {
    }

    private static class StoneSet {
        private Filter<SgfPoint> filter_;
        private int point_;
        private Set<SgfPoint> whiteStones_;
        private Set<SgfPoint> blackStones_;

        private StoneSet() {
        }
    }
}

