/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.events;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.type.GameType;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.StateHandler;

class HandlerSelector {
    private static final Log log_s_ = LogFactory.getLog(HandlerSelector.class);
    private final Map<String, StateHandler> handlerMap_ = new HashMap<String, StateHandler>();
    private StateHandler stateHandler_ = null;

    public void put(GameType gameType, boolean bl, StateHandler stateHandler) {
        ArgumentChecker.throwIfNull((Object)gameType, (Object)stateHandler);
        this.handlerMap_.put(this.makeKey(gameType, bl), stateHandler);
    }

    public void connect(GameType gameType, boolean bl) {
        this.disconnect();
        String string = this.makeKey(gameType, bl);
        this.stateHandler_ = this.handlerMap_.get(string);
        if (this.stateHandler_ == null) {
            log_s_.warn("Can't find StateHandler. key=" + string);
            return;
        }
        this.stateHandler_.connect();
    }

    public void disconnect() {
        if (this.stateHandler_ != null) {
            this.stateHandler_.disconnect();
            this.stateHandler_ = null;
        }
    }

    private String makeKey(GameType gameType, boolean bl) {
        return gameType.getString() + bl;
    }

    public void setEventBroker(EventBroker eventBroker) {
        ArgumentChecker.throwIfNull((Object)eventBroker);
        for (StateHandler stateHandler : this.handlerMap_.values()) {
            stateHandler.setEventBroker(eventBroker);
        }
    }

    public void clear() {
        this.handlerMap_.clear();
        this.stateHandler_ = null;
    }

    public StateHandler getCurrent() {
        return this.stateHandler_;
    }
}

