/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.CollectionEvent;
import org.unitarou.sgf.CollectionListener;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.type.GameType;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.model.GameMediator;

public class CollectionEditor {
    private static final Log logger_s_ = LogFactory.getLog(CollectionEditor.class);
    private final Collection collection_;
    private final CollectionListener listener_;
    private final List<GameMediator> games_;
    private int activeGameIndex_;
    private boolean isRgtEdited_;

    public CollectionEditor(Collection collection, boolean bl) {
        int n;
        ArgumentChecker.throwIfNull((Object)collection);
        this.collection_ = collection;
        this.listener_ = new CollectionListenerImpl();
        this.collection_.addListener(this.listener_);
        this.games_ = new ArrayList<GameMediator>(this.collection_.size());
        for (n = 0; n < this.collection_.size(); ++n) {
            this.games_.add(null);
        }
        this.activeGameIndex_ = 0;
        if (bl) {
            for (n = 0; n < this.collection_.size(); ++n) {
                this.initializeGame(n, true);
            }
        }
        this.isRgtEdited_ = false;
    }

    public void dispose() {
        this.games_.clear();
        this.collection_.removeListener(this.listener_);
        for (RootGameTree rootGameTree : this.collection_) {
            Yukinoshita.context(rootGameTree).clearCurrent();
        }
        Yukinoshita.context(this.collection_).clearCurrent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (!this.games_.isEmpty()) {
                logger_s_.warn(this + " is not disposed.");
                this.dispose();
            }
        }
        finally {
            super.finalize();
        }
    }

    public void setActiveGame(int n) {
        if (n < 0 || this.collection_.size() <= n) {
            throw new IllegalArgumentException("Parameter gameIndex is out of bounds. Game size is " + this.collection_.size() + ". Parameter gameIndex is " + n);
        }
        this.activeGameIndex_ = n;
    }

    public Collection getCollection() {
        return this.collection_;
    }

    public int getActiveGameIndex() {
        return this.activeGameIndex_;
    }

    public GameMediator getActiveGame() {
        return this.get(this.activeGameIndex_);
    }

    private GameMediator initializeGame(int n, boolean bl) {
        RootGameTree rootGameTree = this.collection_.get(n);
        GameMediator gameMediator = new GameMediator(rootGameTree, bl);
        this.games_.set(n, gameMediator);
        return gameMediator;
    }

    public boolean isRgtEdited() {
        return this.isRgtEdited_;
    }

    public boolean[] getChangedFlags() {
        boolean[] blArray = new boolean[this.collection_.size()];
        for (int i = 0; i < blArray.length; ++i) {
            GameMediator gameMediator = this.games_.get(i);
            blArray[i] = gameMediator != null && gameMediator.isChanged();
        }
        return blArray;
    }

    public void clearChangedFlags() {
        for (GameMediator gameMediator : this.games_) {
            if (gameMediator == null) continue;
            gameMediator.clearChanged();
        }
        this.isRgtEdited_ = false;
    }

    public int size() {
        return this.collection_.size();
    }

    public GameMediator createGame(RootGameTree rootGameTree) {
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        this.collection_.addLast(rootGameTree);
        GameMediator gameMediator = this.initializeGame(this.collection_.size() - 1, true);
        return gameMediator;
    }

    public boolean isDrill() {
        return this.get(0).getGameType().equals(GameType.DRILL);
    }

    private GameMediator get(int n) {
        if (n < 0 || this.collection_.size() <= n) {
            throw new IllegalArgumentException("Bad index:" + n);
        }
        GameMediator gameMediator = this.games_.get(n);
        if (gameMediator == null) {
            gameMediator = this.initializeGame(n, false);
        }
        return gameMediator;
    }

    public void remove(int n) {
        if (n < 0 || this.collection_.size() <= n) {
            throw new IllegalArgumentException("Bad index:" + n);
        }
        this.collection_.remove(n);
        this.isRgtEdited_ = true;
    }

    public void swap(int n, int n2) {
        if (n < 0 || this.collection_.size() <= n || n2 < 0 || this.collection_.size() <= n2) {
            throw new IllegalArgumentException("Parameter is out of range. index1:" + n + ", index2:" + n2);
        }
        if (n == n2) {
            return;
        }
        this.collection_.swap(n, n2);
        GameMediator gameMediator = this.games_.get(n);
        this.games_.set(n, this.games_.get(n2));
        this.games_.set(n2, gameMediator);
        if (this.activeGameIndex_ == n) {
            this.activeGameIndex_ = n2;
        } else if (this.activeGameIndex_ == n2) {
            this.activeGameIndex_ = n;
        }
        this.isRgtEdited_ = true;
    }

    private class CollectionListenerImpl
    implements CollectionListener {
        private CollectionListenerImpl() {
        }

        public void rootGameTreeAppended(CollectionEvent collectionEvent) {
            CollectionEditor.this.games_.add(null);
        }

        public void rootGameTreeRemoved(CollectionEvent collectionEvent) {
            RootGameTree rootGameTree = collectionEvent.getRootGameTree();
            for (int i = 0; i < CollectionEditor.this.games_.size(); ++i) {
                GameMediator gameMediator = (GameMediator)CollectionEditor.this.games_.get(i);
                if (gameMediator == null || gameMediator.getRootGameTree() != rootGameTree) continue;
                CollectionEditor.this.games_.remove(i);
                break;
            }
            if (CollectionEditor.this.activeGameIndex_ == CollectionEditor.this.collection_.size()) {
                CollectionEditor.this.activeGameIndex_ = CollectionEditor.this.collection_.size() - 1;
            }
        }
    }
}

