/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.board;

import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.unitarou.lang.NullArgumentException;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.yukinoshita.model.board.IgoBoardView;

public class TextViewer {
    private final CharMap charMap_ = new CharMap(CharMap.DEFAULT_CHARMAP);

    public void setCharacter(SgfPointType sgfPointType, char c) {
        if (sgfPointType == null) {
            throw new NullArgumentException();
        }
        this.charMap_.put(sgfPointType, c);
    }

    public String[] write(IgoBoardView igoBoardView) {
        SgfSize sgfSize = igoBoardView.size();
        String[] stringArray = new String[sgfSize.height()];
        Set<SgfPoint> set = igoBoardView.position(SgfColor.BLACK);
        Set<SgfPoint> set2 = igoBoardView.position(SgfColor.WHITE);
        for (int i = 1; i <= sgfSize.height(); ++i) {
            stringArray[i - 1] = this.writeOneLine(sgfSize, i, set, set2);
        }
        return stringArray;
    }

    private String writeOneLine(SgfSize sgfSize, int n, Set set, Set set2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 1; i <= sgfSize.width(); ++i) {
            SgfPoint sgfPoint = SgfPoint.create(sgfSize, i, n);
            if (set.contains(sgfPoint)) {
                stringBuilder.append(this.charMap_.getChar(SgfPointType.BLACK));
                continue;
            }
            if (set2.contains(sgfPoint)) {
                stringBuilder.append(this.charMap_.getChar(SgfPointType.WHITE));
                continue;
            }
            if (sgfSize.isStarPoint(sgfPoint)) {
                stringBuilder.append(this.charMap_.getChar(SgfPointType.STAR));
                continue;
            }
            stringBuilder.append(this.charMap_.getChar(SgfPointType.classify(sgfPoint)));
        }
        return stringBuilder.toString();
    }

    public char getCharacter(SgfPointType sgfPointType) {
        return this.charMap_.getChar(sgfPointType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CharMap {
        public static final CharMap DEFAULT_CHARMAP;
        public static final CharMap NO_BOLD_CHARMAP;
        private final SortedMap<SgfPointType, Character> charMap_;

        private CharMap(SortedMap<SgfPointType, Character> sortedMap) {
            this.charMap_ = new TreeMap<SgfPointType, Character>(sortedMap);
        }

        public CharMap(CharMap charMap) {
            this.charMap_ = new TreeMap<SgfPointType, Character>(charMap.charMap_);
        }

        public char getChar(SgfPointType sgfPointType) {
            return ((Character)this.charMap_.get((Object)sgfPointType)).charValue();
        }

        public void put(SgfPointType sgfPointType, char c) {
            if (sgfPointType == null) {
                throw new NullArgumentException();
            }
            this.charMap_.put(sgfPointType, Character.valueOf(c));
        }

        static {
            TreeMap<SgfPointType, Character> treeMap = new TreeMap<SgfPointType, Character>();
            treeMap.put(SgfPointType.BLACK, Character.valueOf('\u25cf'));
            treeMap.put(SgfPointType.WHITE, Character.valueOf('\u25cb'));
            treeMap.put(SgfPointType.EMPTY, Character.valueOf('\u253c'));
            treeMap.put(SgfPointType.TOP_LEFT, Character.valueOf('\u250f'));
            treeMap.put(SgfPointType.TOP, Character.valueOf('\u252f'));
            treeMap.put(SgfPointType.TOP_RIGHT, Character.valueOf('\u2513'));
            treeMap.put(SgfPointType.LEFT, Character.valueOf('\u2520'));
            treeMap.put(SgfPointType.RIGHT, Character.valueOf('\u2528'));
            treeMap.put(SgfPointType.BOTTOM_LEFT, Character.valueOf('\u2517'));
            treeMap.put(SgfPointType.BOTTOM, Character.valueOf('\u2537'));
            treeMap.put(SgfPointType.BOTTOM_RIGHT, Character.valueOf('\u251b'));
            treeMap.put(SgfPointType.STAR, Character.valueOf('\u254b'));
            DEFAULT_CHARMAP = new CharMap(treeMap);
            treeMap.put(SgfPointType.TOP_LEFT, Character.valueOf('\u250c'));
            treeMap.put(SgfPointType.TOP, Character.valueOf('\u252c'));
            treeMap.put(SgfPointType.TOP_RIGHT, Character.valueOf('\u2510'));
            treeMap.put(SgfPointType.LEFT, Character.valueOf('\u251c'));
            treeMap.put(SgfPointType.RIGHT, Character.valueOf('\u2524'));
            treeMap.put(SgfPointType.BOTTOM_LEFT, Character.valueOf('\u2514'));
            treeMap.put(SgfPointType.BOTTOM, Character.valueOf('\u2534'));
            treeMap.put(SgfPointType.BOTTOM_RIGHT, Character.valueOf('\u2518'));
            treeMap.put(SgfPointType.STAR, Character.valueOf('\u253c'));
            NO_BOLD_CHARMAP = new CharMap(treeMap);
        }
    }
}

