/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.db.hsql;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sql.UQueryRunner;
import org.unitarou.yukinoshita.model.db.GameTerm;
import org.unitarou.yukinoshita.model.db.SearchFileCondition;
import org.unitarou.yukinoshita.model.db.SearchedFile;
import org.unitarou.yukinoshita.model.db.Term;
import org.unitarou.yukinoshita.model.db.TermOperatorTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileSearchedView {
    private static final String BASE_ALL_SQL = "SELECT f.file_id, f.path, g.file_order, g.master_id, g.game_type, g.move, g.date FROM game_index g INNER JOIN file_index f ON g.file_id = f.file_id AND {0} LIMIT ?";
    private static final String BASE_FP_SQL = "SELECT f.file_id, f.path, g.file_order, g.master_id, g.game_type, g.move, g.date, m.similarity FROM game_index g INNER JOIN (  SELECT master_id, \"org.unitarou.yukinoshita.model.db.hsql.StoredFunctions.similarity2\"(?, ?, fingerprint) similarity   FROM master WHERE width = ? AND height = ? AND similarity <= ? AND {0} ) m ON g.master_id = m.master_id INNER JOIN file_index f ON g.file_id = f.file_id ORDER BY similarity ASC LIMIT ?";
    private static final String BASE_MV_SQL = "SELECT f.file_id, f.path, g.file_order, g.master_id, g.game_type, g.move, g.date, \"org.unitarou.yukinoshita.model.db.hsql.StoredFunctions.indexOf\"(g.procedure, ?) as P FROM game_index g INNER JOIN file_index f ON g.file_id = f.file_id AND {0} INNER JOIN master m on g.master_id = m.master_id AND width = ? AND height = ? WHERE P <> -1 ORDER BY P ASC LIMIT ?";
    private static final String BASE_TERM_SQL = "SELECT f.file_id, f.path, g.file_order, g.master_id, g.game_type, g.move, g.date FROM ({0}) p INNER JOIN game_index g ON g.file_id = p.file_id AND g.file_order = p.file_order AND {1} INNER JOIN file_index f ON g.file_id  = f.file_id ";
    private static final String BASE_FP_TERM_SQL = "SELECT f.file_id, f.path, g.file_order, g.master_id, g.game_type, g.move, g.date, \"org.unitarou.yukinoshita.model.db.hsql.StoredFunctions.similarity2\"(?, ?, FINGERPRINT) similarity FROM ({0}) p INNER JOIN game_index g ON g.file_id = p.file_id AND g.file_order = p.file_order AND {1} INNER JOIN file_index f ON g.file_id  = f.file_id INNER JOIN master m ON g.master_id = m.master_id AND m.width = ? AND m.height = ? WHERE similarity <= ? ORDER BY similarity ASC";
    private static final String BASE_MV_TERM_SQL = "SELECT f.file_id, f.path, g.file_order, g.master_id, g.game_type, g.move, g.date, \"org.unitarou.yukinoshita.model.db.hsql.StoredFunctions.indexOf\"(g.procedure, ?) as PP FROM ({0}) p INNER JOIN game_index g ON g.file_id = p.file_id AND g.file_order = p.file_order AND {1} INNER JOIN file_index f ON g.file_id = f.file_id INNER JOIN master m on g.master_id = m.master_id AND width = ? AND height = ? WHERE PP <> -1 ORDER BY PP ASC";
    private static final String INNER_TERM_SQL = "SELECT file_id, file_order FROM game_term_map WHERE term_id = ? ";
    private static final String SQL_GAME_TERM = "SELECT m.file_id, m.file_order, m.term_id, t.term FROM term t INNER JOIN game_term_map m ON t.term_id = m.term_id WHERE t.SGF_ID = ? AND t.game_type = ? ";
    private static final FileSearchedView instance_s_ = new FileSearchedView();

    static FileSearchedView instance() {
        return instance_s_;
    }

    private FileSearchedView() {
    }

    List<SearchedFile> select(Connection connection, SearchFileCondition searchFileCondition) throws SQLException {
        String string;
        Object object;
        ArgumentChecker.throwIfNull((Object)connection, (Object)searchFileCondition);
        if (searchFileCondition.getTarget().isEmpty()) {
            return Collections.emptyList();
        }
        boolean bl = searchFileCondition.getTermOperatorTree().isValid();
        boolean bl2 = searchFileCondition.isFingerprintEnabled();
        boolean bl3 = searchFileCondition.isMoveEnabled();
        UQueryRunner uQueryRunner = new UQueryRunner();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (bl && bl3) {
            arrayList.add(searchFileCondition.getMovePatterns());
            object = new StringBuilder();
            this.buildTermTree((StringBuilder)object, arrayList, searchFileCondition.getTermOperatorTree(), true);
            string = MessageFormat.format(BASE_MV_TERM_SQL, object, this.buildGameTypeQuery(searchFileCondition.getTarget(), arrayList));
            arrayList.add(searchFileCondition.getSgfSize().width());
            arrayList.add(searchFileCondition.getSgfSize().height());
        } else if (bl3) {
            arrayList.add(searchFileCondition.getMovePatterns());
            string = MessageFormat.format(BASE_MV_SQL, this.buildGameTypeQuery(searchFileCondition.getTarget(), arrayList));
            arrayList.add(searchFileCondition.getSgfSize().width());
            arrayList.add(searchFileCondition.getSgfSize().height());
            arrayList.add(searchFileCondition.getLimit());
        } else if (bl2 && bl) {
            object = new StringBuilder();
            this.buildTermTree((StringBuilder)object, arrayList, searchFileCondition.getTermOperatorTree(), true);
            arrayList.add(0, searchFileCondition.getNtArea());
            arrayList.add(1, searchFileCondition.getFingerprint());
            string = MessageFormat.format(BASE_FP_TERM_SQL, object, this.buildGameTypeQuery(searchFileCondition.getTarget(), arrayList));
            arrayList.add(searchFileCondition.getSgfSize().width());
            arrayList.add(searchFileCondition.getSgfSize().height());
            arrayList.add(searchFileCondition.getSimilarity());
        } else if (bl2) {
            arrayList.add(searchFileCondition.getNtArea());
            arrayList.add(searchFileCondition.getFingerprint());
            arrayList.add(searchFileCondition.getSgfSize().width());
            arrayList.add(searchFileCondition.getSgfSize().height());
            arrayList.add(searchFileCondition.getSimilarity());
            string = MessageFormat.format(BASE_FP_SQL, this.buildGameTypeQuery(searchFileCondition.getTarget(), arrayList));
            arrayList.add(searchFileCondition.getLimit());
        } else if (bl) {
            object = new StringBuilder();
            this.buildTermTree((StringBuilder)object, arrayList, searchFileCondition.getTermOperatorTree(), true);
            string = MessageFormat.format(BASE_TERM_SQL, object, this.buildGameTypeQuery(searchFileCondition.getTarget(), arrayList));
        } else {
            string = MessageFormat.format(BASE_ALL_SQL, this.buildGameTypeQuery(searchFileCondition.getTarget(), arrayList));
            arrayList.add(searchFileCondition.getLimit());
        }
        object = uQueryRunner.query(connection, string, SearchedFile.class, arrayList.toArray());
        return object;
    }

    private void buildTermTree(StringBuilder stringBuilder, List<Object> list, TermOperatorTree termOperatorTree, boolean bl) {
        Object object;
        if (!bl) {
            switch (termOperatorTree.getOperator()) {
                case INTERSECT: {
                    object = " INTERSECT ";
                    break;
                }
                case UNION: {
                    object = " UNION ";
                    break;
                }
                case EXCEPT: {
                    object = " EXCEPT ";
                    break;
                }
                default: {
                    assert (false) : "Unknown opeartor: " + (Object)((Object)termOperatorTree.getOperator());
                    object = termOperatorTree.getOperator().toString();
                }
            }
            stringBuilder.append((String)object);
        }
        if ((object = termOperatorTree.getTerm()) == null) {
            int n;
            List<TermOperatorTree> list2 = termOperatorTree.getChildren();
            for (n = 0; n < list2.size(); n += 1) {
            }
            n = 1;
            for (TermOperatorTree termOperatorTree2 : list2) {
                this.buildTermTree(stringBuilder, list, termOperatorTree2, n != 0);
                n = 0;
            }
            return;
        }
        stringBuilder.append(INNER_TERM_SQL);
        list.add(((Term)object).getTermId());
    }

    private CharSequence buildGameTypeQuery(EnumSet<GameType> enumSet, List<Object> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (GameType gameType : enumSet) {
            stringBuilder.append(" game_type = ? OR");
            list.add(gameType.getIntValue());
        }
        stringBuilder.setLength(stringBuilder.length() - 3);
        stringBuilder.append(')');
        return stringBuilder;
    }

    List<GameTerm> selectGameTerm(Connection connection, GameType gameType, SgfId sgfId) throws SQLException {
        UQueryRunner uQueryRunner = new UQueryRunner();
        return uQueryRunner.query(connection, SQL_GAME_TERM, GameTerm.class, sgfId.id(), gameType.getIntValue());
    }
}

