/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.util.Adaptable;
import org.unitarou.yukinoshita.events.WindowControllerListener;
import org.unitarou.yukinoshita.model.CollectionEditor;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.cmd.FilterRgtCommand;
import org.unitarou.yukinoshita.view.jface.act.AbstractAction;
import org.unitarou.yukinoshita.view.monitor.CollectionMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClearRgtFilter
extends AbstractAction
implements Adaptable {
    private static final Log log_s_ = LogFactory.getLog(ClearRgtFilter.class);
    private final Adapter adapter_;
    private Reference<GameFrameController> refGfc_ = new WeakReference<Object>(null);

    public ClearRgtFilter(WindowController windowController) {
        super(windowController);
        this.adapter_ = new Adapter();
        windowController.addListener(new WindowControllerListener(){

            public void changeActive(GameFrameController gameFrameController) {
                ClearRgtFilter.this.changeController(gameFrameController);
            }
        });
        this.setEnabled(false);
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    private void changeController(GameFrameController gameFrameController) {
        GameFrameController gameFrameController2 = this.refGfc_.get();
        if (gameFrameController2 != null) {
            gameFrameController2.getEventBroker().removeView(this);
        }
        if (gameFrameController == null) {
            this.setEnabled(false);
        } else {
            gameFrameController.getEventBroker().addView(this);
            this.refGfc_ = new WeakReference<GameFrameController>(gameFrameController);
            this.setEnabled(this.isRgtFiltered(gameFrameController));
        }
    }

    private boolean isRgtFiltered(GameFrameController gameFrameController) {
        return gameFrameController != null && gameFrameController.getCollectionEditor().size() != gameFrameController.getIndexFilter().size();
    }

    @Override
    public void run() {
        GameFrameController gameFrameController = this.controller_.getActive();
        if (gameFrameController == null) {
            log_s_.warn("[BUG] Can't find Controller.");
            return;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(gameFrameController.getCollectionEditor().size());
        for (int i = 0; i < gameFrameController.getCollectionEditor().size(); ++i) {
            arrayList.add(i);
        }
        gameFrameController.getEventBroker().executeCommand(new FilterRgtCommand(arrayList));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Adapter
    implements CollectionMonitor {
        private Adapter() {
        }

        @Override
        public void update(CollectionEditor collectionEditor) {
            GameFrameController gameFrameController = (GameFrameController)ClearRgtFilter.this.refGfc_.get();
            ClearRgtFilter.this.setEnabled(ClearRgtFilter.this.isRgtFiltered(gameFrameController));
        }

        @Override
        public void changeIndexFilter(List<Integer> list) {
            GameFrameController gameFrameController = (GameFrameController)ClearRgtFilter.this.refGfc_.get();
            ClearRgtFilter.this.setEnabled(ClearRgtFilter.this.isRgtFiltered(gameFrameController));
        }
    }
}

