/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.ml.Message;
import org.unitarou.util.Adaptable;
import org.unitarou.yukinoshita.events.WindowControllerListener;
import org.unitarou.yukinoshita.model.NodeList;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.RemoveCurrentNode;
import org.unitarou.yukinoshita.model.cmd.RemoveLastNode;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;
import org.unitarou.yukinoshita.view.provider.nlp.NodeViewLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveNodeAction
extends Action
implements Adaptable {
    private static final Log log_s_ = LogFactory.getLog(RemoveNodeAction.class);
    private static final Message CLB_NAME = new Message(RemoveNodeAction.class, "clbName");
    private final Adapter adapter_ = new Adapter();
    private WindowController controller_ = null;

    public RemoveNodeAction() {
        this.setCommandName("");
        this.setEnabled(false);
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    private void setCommandName(String string) {
        String string2 = string.trim();
        if (string2.length() != 0) {
            string2 = '(' + string2 + ')';
        }
        this.setText(CLB_NAME.get((Object)string2));
    }

    public RemoveNodeAction setController(WindowController windowController) {
        ArgumentChecker.throwIfNull((Object)windowController);
        if (this.controller_ != null) {
            this.controller_.removListener(this.adapter_);
        }
        this.controller_ = windowController;
        this.controller_.addListener(this.adapter_);
        return this;
    }

    @Override
    public void run() {
        GameFrameController gameFrameController = this.controller_.getActive();
        NodeList nodeList = gameFrameController.getCollectionEditor().getActiveGame().getNodeList();
        if (nodeList.getLastNodeView() == nodeList.getCurrentNodeView()) {
            gameFrameController.getEventBroker().executeCommand(new RemoveLastNode());
        } else {
            gameFrameController.getEventBroker().executeCommand(new RemoveCurrentNode());
        }
    }

    private class Adapter
    implements ControllerStatusMonitor,
    NodeMonitor,
    WindowControllerListener {
        private Reference<GameFrameController> refGfc_ = new WeakReference<Object>(null);

        private Adapter() {
        }

        public void currentChanged(NodeView nodeView) {
            GameFrameController gameFrameController = this.refGfc_.get();
            if (gameFrameController == null) {
                log_s_.warn("Lost GameFrameController (BUG)");
                return;
            }
            ArgumentChecker.throwIfNull((Object)nodeView);
            RemoveNodeAction.this.setCommandName(NodeViewLabelProvider.CONTEXT.defaultValue().getLabel(nodeView));
            RemoveNodeAction.this.setEnabled(this.isValidState(gameFrameController));
        }

        public void changeActive(GameFrameController gameFrameController) {
            GameFrameController gameFrameController2 = this.refGfc_.get();
            if (gameFrameController2 != null) {
                gameFrameController2.getEventBroker().removeView(RemoveNodeAction.this);
            }
            this.refGfc_ = new WeakReference<GameFrameController>(gameFrameController);
            GameFrameController gameFrameController3 = this.refGfc_.get();
            if (gameFrameController3 != null) {
                gameFrameController.getEventBroker().addView(RemoveNodeAction.this);
            }
            if (!this.isValidState(gameFrameController3)) {
                RemoveNodeAction.this.setEnabled(false);
                RemoveNodeAction.this.setCommandName("");
                return;
            }
            RemoveNodeAction.this.setEnabled(true);
        }

        private boolean isValidState(GameFrameController gameFrameController) {
            if (gameFrameController == null) {
                return false;
            }
            NodeList nodeList = gameFrameController.getCollectionEditor().getActiveGame().getNodeList();
            if (nodeList.size() <= 1) {
                return false;
            }
            if (nodeList.getCurrentNodeView() == nodeList.getNodeView(0)) {
                return false;
            }
            return gameFrameController.isEditMode();
        }

        public void setEditMode(boolean bl) {
            RemoveNodeAction.this.setEnabled(bl);
        }

        public void changeHandlerPhase(HandlerPhase handlerPhase) {
        }
    }
}

