/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board;

import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.SgfRectangle;
import org.unitarou.sgf.util.Stone;
import org.unitarou.swt.Swts;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.yukinoshita.model.board.PrintingIgoBoard;
import org.unitarou.yukinoshita.view.jface.board.DigestIgoBoardLayout;
import org.unitarou.yukinoshita.view.jface.board.RuledLinePainter;
import org.unitarou.yukinoshita.view.jface.board.SimpleRuledLinePainter;
import org.unitarou.yukinoshita.view.jface.board.bp.BoardPainter;
import org.unitarou.yukinoshita.view.jface.board.bp.SimpleBoardPainter;
import org.unitarou.yukinoshita.view.jface.board.sp.StonePainter;
import org.unitarou.yukinoshita.view.jface.board.sp.StonePainterParameter;

public class DigestIgoBoardPanel
implements WidgetContainer {
    private BoardPainter boardPainter_ = new SimpleBoardPainter();
    private RuledLinePainter ruledLinePainter_ = new SimpleRuledLinePainter();
    private StonePainter stonePainter_ = StonePainter.CONTEXT.defaultValue();
    private final boolean printMove_;
    private final boolean showPiled_;
    private Canvas canvas_;
    private Image boardImage_;
    private RootGameTree rgt_;

    public DigestIgoBoardPanel(boolean bl, boolean bl2) {
        this.printMove_ = bl;
        this.showPiled_ = bl2;
        this.canvas_ = null;
        this.boardImage_ = null;
        this.rgt_ = new RootGameTree();
    }

    public Control createContents(Composite composite) {
        ArgumentChecker.throwIfNull((Object)composite);
        this.canvas_ = new Canvas(composite, 262144);
        this.boardImage_ = new Image((Device)this.canvas_.getDisplay(), this.getBoardSize());
        this.canvas_.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                if (DigestIgoBoardPanel.this.boardImage_ == null) {
                    DigestIgoBoardPanel.this.drawImage();
                }
                paintEvent.gc.drawImage(DigestIgoBoardPanel.this.boardImage_, paintEvent.x, paintEvent.y, paintEvent.width, paintEvent.height, paintEvent.x, paintEvent.y, paintEvent.width, paintEvent.height);
            }
        });
        this.canvas_.addControlListener(new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                Swts.disposeQuietly(DigestIgoBoardPanel.this.boardImage_);
                DigestIgoBoardPanel.this.boardImage_ = null;
            }
        });
        return this.canvas_;
    }

    public Control getControl() {
        return this.canvas_;
    }

    public void close() {
        Swts.disposeQuietly(this.boardImage_);
    }

    public void updateImage(RootGameTree rootGameTree) {
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        this.rgt_ = rootGameTree;
        if (this.canvas_ == null) {
            return;
        }
        Swts.disposeQuietly(this.boardImage_);
        this.boardImage_ = null;
        this.canvas_.redraw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawImage() {
        GC gC = null;
        try {
            this.boardImage_ = new Image((Device)this.canvas_.getDisplay(), this.getBoardSize());
            gC = new GC(this.boardImage_);
            this.drawImageImpl(gC, this.rgt_);
        }
        catch (Throwable throwable) {
            Swts.disposeQuietly(gC);
            throw throwable;
        }
        Swts.disposeQuietly(gC);
    }

    private Rectangle getBoardSize() {
        if (this.canvas_ == null) {
            return new Rectangle(0, 0, 100, 100);
        }
        Rectangle rectangle = this.canvas_.getBounds();
        if (rectangle.width == 0 || rectangle.height == 0) {
            return new Rectangle(0, 0, 100, 100);
        }
        return rectangle;
    }

    private void drawImageImpl(GC gC, RootGameTree rootGameTree) {
        Object object;
        SerializableCompatibility serializableCompatibility;
        int n;
        SgfSize sgfSize = rootGameTree.getSize();
        PrintingIgoBoard printingIgoBoard = new PrintingIgoBoard(rootGameTree);
        SgfRectangle sgfRectangle = printingIgoBoard.getViewArea();
        Rectangle rectangle = this.boardImage_.getBounds();
        DigestIgoBoardLayout digestIgoBoardLayout = new DigestIgoBoardLayout(rectangle, printingIgoBoard, this.showPiled_);
        gC.setBackground(this.canvas_.getDisplay().getSystemColor(22));
        gC.fillRectangle(rectangle);
        if (digestIgoBoardLayout.getBlockSize() < 3) {
            return;
        }
        SgfPoint sgfPoint = sgfRectangle.getStart();
        StonePainterParameter stonePainterParameter = new StonePainterParameter();
        for (int i = sgfPoint.y(); i <= sgfRectangle.getEnd().y(); ++i) {
            for (n = sgfPoint.x(); n <= sgfRectangle.getEnd().x(); ++n) {
                SgfPoint sgfPoint2 = SgfPoint.create(sgfSize, n, i);
                serializableCompatibility = digestIgoBoardLayout.getBlockArea(n, i);
                this.boardPainter_.paint(gC, sgfPoint2, (Rectangle)serializableCompatibility);
                this.ruledLinePainter_.paint(gC, sgfPoint2, (Rectangle)serializableCompatibility);
                object = printingIgoBoard.getStone(sgfPoint2);
                if (object == null) continue;
                this.setParameters(stonePainterParameter, (Stone)object);
                this.stonePainter_.paintStone(gC, (Rectangle)serializableCompatibility, stonePainterParameter);
            }
        }
        if (!this.showPiled_) {
            return;
        }
        PrintingIgoBoard.PiledStone[] piledStoneArray = printingIgoBoard.getPiledStones();
        n = digestIgoBoardLayout.getPiledBlockSize();
        for (int i = 0; i < piledStoneArray.length; ++i) {
            serializableCompatibility = digestIgoBoardLayout.getPiledStoneStart(i);
            object = new Rectangle(((Point)serializableCompatibility).x, ((Point)serializableCompatibility).y, n, n);
            this.setParameters(stonePainterParameter, piledStoneArray[i].getPiled());
            this.stonePainter_.paintStone(gC, (Rectangle)object, stonePainterParameter);
            if (digestIgoBoardLayout.isLandscapeStyle()) {
                ((Rectangle)object).x += n;
                ((Rectangle)object).y += (int)((double)n * 0.1);
            } else {
                ((Rectangle)object).x += (int)((double)n * 0.1);
                ((Rectangle)object).y += n;
            }
            ((Rectangle)object).width = (int)((double)n * 0.8);
            ((Rectangle)object).height = (int)((double)n * 0.8);
            this.setParameters(stonePainterParameter, piledStoneArray[i].getBase());
            this.stonePainter_.paintStone(gC, (Rectangle)object, stonePainterParameter);
        }
    }

    private void setParameters(StonePainterParameter stonePainterParameter, Stone stone) {
        stonePainterParameter.setSgfColor(stone.getColor());
        if (this.printMove_) {
            Integer n = stone.getNumber();
            stonePainterParameter.setLabel(n == null ? null : n.toString());
        }
        stonePainterParameter.setLastMove(false);
        stonePainterParameter.setTransient(false);
    }
}

