/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board;

import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.unitarou.jface.ColorResource;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Classes;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.SgfRectangle;
import org.unitarou.sgf.util.provider.crdlp.CoordinatesLabelProvider;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.view.jface.board.CoordinatesPainter;

public class SimpleCoordinatesPainter
implements CoordinatesPainter {
    private static final FontRegistry fontRegistry_s_ = JFaceResources.getFontRegistry();
    private static final ColorResource FONT_COLOR = new ColorResource(0, 0, 0);
    private final String FKEY_LABEL = Classes.uniqueKey(this, "FKEY_LABEL");
    private Point labelSize_ = null;
    private CoordinatesLabelProvider provider_ = Yukinoshita.context(null).getProvider(CoordinatesLabelProvider.class);

    public void setLabelProvider(CoordinatesLabelProvider coordinatesLabelProvider) {
        ArgumentChecker.throwIfNull((Object)coordinatesLabelProvider);
        this.provider_ = coordinatesLabelProvider;
        this.labelSize_ = null;
    }

    public void paint(GC gC, Rectangle rectangle, SgfRectangle sgfRectangle, boolean[] blArray) {
        Point point;
        String string;
        int n;
        int n2 = rectangle.width / sgfRectangle.width();
        int n3 = rectangle.height / sgfRectangle.height();
        SgfSize sgfSize = sgfRectangle.getStart().size();
        gC.setFont(this.getLabelFont());
        gC.setForeground(FONT_COLOR.get());
        if (blArray[0]) {
            for (n = sgfRectangle.getStart().y(); n <= sgfRectangle.getEnd().y(); ++n) {
                string = this.getYaxisLabel(sgfSize, n);
                point = gC.stringExtent(string);
                point.x = rectangle.x - point.x;
                point.y = n3 * (n - sgfRectangle.getStart().y()) + (n3 - point.y) / 2 + rectangle.y;
                gC.drawString(string, point.x, point.y, true);
            }
        }
        if (blArray[1]) {
            for (n = sgfRectangle.getStart().x(); n <= sgfRectangle.getEnd().x(); ++n) {
                string = this.getXaxisLabel(sgfSize, n);
                point = gC.stringExtent(string);
                point.x = n2 * (n - sgfRectangle.getStart().x()) + (n2 - point.x) / 2 + rectangle.x;
                point.y = rectangle.y - point.y;
                gC.drawString(string, point.x, point.y, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point calcLabelSize(SgfRectangle sgfRectangle) {
        ArgumentChecker.throwIfNull((Object)sgfRectangle);
        if (this.labelSize_ != null) {
            return new Point(this.labelSize_.x, this.labelSize_.y);
        }
        GC gC = new GC(Display.getCurrent());
        try {
            Point point;
            String string;
            int n;
            SgfSize sgfSize = sgfRectangle.getStart().size();
            this.labelSize_ = new Point(0, 0);
            gC.setFont(this.getLabelFont());
            for (n = sgfRectangle.getStart().x(); n <= sgfRectangle.getEnd().x(); ++n) {
                string = this.getXaxisLabel(sgfSize, n);
                if (string.length() == 0) continue;
                point = gC.stringExtent(string);
                this.labelSize_.x = Math.max(this.labelSize_.x, point.x);
                this.labelSize_.y = Math.max(this.labelSize_.y, point.y);
            }
            for (n = sgfRectangle.getStart().y(); n <= sgfRectangle.getEnd().y(); ++n) {
                string = this.getYaxisLabel(sgfSize, n);
                if (string.length() == 0) continue;
                point = gC.stringExtent(string);
                this.labelSize_.x = Math.max(this.labelSize_.x, point.x);
                this.labelSize_.y = Math.max(this.labelSize_.y, point.y);
            }
            Point point2 = new Point(this.labelSize_.x, this.labelSize_.y);
            return point2;
        }
        finally {
            gC.dispose();
        }
    }

    private Font getLabelFont() {
        if (fontRegistry_s_.get(this.FKEY_LABEL) == null) {
            fontRegistry_s_.put(this.FKEY_LABEL, Display.getCurrent().getSystemFont().getFontData());
        }
        return fontRegistry_s_.get(this.FKEY_LABEL);
    }

    private String getXaxisLabel(SgfSize sgfSize, int n) {
        return this.provider_.getXLabel(SgfPoint.create(sgfSize, n, 1));
    }

    private String getYaxisLabel(SgfSize sgfSize, int n) {
        return this.provider_.getYLabel(SgfPoint.create(sgfSize, 1, n));
    }

    public void setFontData(FontData fontData) {
        ArgumentChecker.throwIfNull((Object)fontData);
        fontRegistry_s_.put(this.FKEY_LABEL, new FontData[]{fontData});
        this.labelSize_ = null;
    }
}

