/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board.eh;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.swt.Swts;
import org.unitarou.util.Adaptable;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.StateHandler;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.ViewerUtils;
import org.unitarou.yukinoshita.view.jface.board.BlockStatus;
import org.unitarou.yukinoshita.view.jface.board.IgoBoardPanel;
import org.unitarou.yukinoshita.view.jface.board.eh.BlockSituation;
import org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator;
import org.unitarou.yukinoshita.view.monitor.MouseWheelMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CanvasHookedStateHandler
implements Adaptable,
StateHandler {
    private static final Log log_s_ = LogFactory.getLog(CanvasHookedStateHandler.class);
    private final Adapter adapter_;
    private final IgoBoardPanel igoBoardPanel_;
    private EventBroker eventBroker_;
    private final ListenerForCanvas listenerForCanvas_;
    private final Map<HandlerPhase, EventDelegator> eventDelegatorMap_;
    private EventDelegator eventDelegator_;
    private BlockStatus blockStatus_;

    protected CanvasHookedStateHandler(IgoBoardPanel igoBoardPanel) {
        ArgumentChecker.throwIfNull((Object)igoBoardPanel);
        this.adapter_ = new Adapter();
        this.igoBoardPanel_ = igoBoardPanel;
        this.eventBroker_ = EventBroker.NULL_BROKER;
        this.listenerForCanvas_ = new ListenerForCanvas();
        this.eventDelegatorMap_ = new LinkedHashMap<HandlerPhase, EventDelegator>();
        this.eventDelegator_ = null;
        this.blockStatus_ = new BlockStatus();
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    protected final IgoBoardPanel getIgoBoardPanel() {
        return this.igoBoardPanel_;
    }

    protected final EventBroker getEventBroker() {
        return this.eventBroker_;
    }

    protected final void registerDelegator(HandlerPhase handlerPhase, EventDelegator eventDelegator) {
        ArgumentChecker.throwIfNull((Object)handlerPhase, (Object)eventDelegator);
        this.eventDelegatorMap_.put(handlerPhase, eventDelegator);
    }

    protected final EventDelegator findDelegator(HandlerPhase handlerPhase) {
        ArgumentChecker.throwIfNull((Object)handlerPhase);
        EventDelegator eventDelegator = this.eventDelegatorMap_.get(handlerPhase);
        if (eventDelegator == null) {
            log_s_.warn("Undefined delegator: " + handlerPhase);
        }
        return eventDelegator;
    }

    protected final EventDelegator getEventDelegator() {
        return this.eventDelegator_;
    }

    @Override
    public final HandlerPhase getHandlerPhase() {
        for (Map.Entry<HandlerPhase, EventDelegator> entry : this.eventDelegatorMap_.entrySet()) {
            if (entry.getValue() != this.eventDelegator_) continue;
            return entry.getKey();
        }
        return null;
    }

    protected final void setHandlerPhase(HandlerPhase handlerPhase) {
        ArgumentChecker.throwIfNull((Object)handlerPhase);
        this.eventDelegator_ = this.findDelegator(handlerPhase);
    }

    protected final BlockStatus getBlockStatus() {
        return this.blockStatus_;
    }

    protected final MouseEvent getMouseEvent() {
        return this.listenerForCanvas_.lastMouseEvent_;
    }

    @Override
    public HandlerPhase[] getHandlerPhases() {
        return this.eventDelegatorMap_.keySet().toArray(new HandlerPhase[this.eventDelegatorMap_.size()]);
    }

    @Override
    public final void setEventBroker(EventBroker eventBroker) {
        ArgumentChecker.throwIfNull((Object)eventBroker);
        this.eventBroker_ = eventBroker;
    }

    @Override
    public final void connect() {
        Canvas canvas = this.igoBoardPanel_.getCanvas();
        if (canvas == null) {
            throw new IllegalStateException("IgoBoardPanel#createContents() didn't executed.");
        }
        canvas.getDisplay().addFilter(1, this.listenerForCanvas_);
        canvas.getDisplay().addFilter(2, this.listenerForCanvas_);
        canvas.addMouseListener(this.listenerForCanvas_);
        canvas.addMouseMoveListener(this.listenerForCanvas_);
        canvas.addMouseTrackListener(this.listenerForCanvas_);
        canvas.addFocusListener(this.listenerForCanvas_);
        this.eventBroker_.addView(this);
    }

    @Override
    public final void disconnect() {
        Canvas canvas = this.igoBoardPanel_.getCanvas();
        if (canvas == null) {
            throw new IllegalStateException("IgoBoardPanel#createContents() didn't executed.");
        }
        canvas.getDisplay().removeFilter(1, this.listenerForCanvas_);
        canvas.getDisplay().removeFilter(2, this.listenerForCanvas_);
        canvas.removeMouseListener(this.listenerForCanvas_);
        canvas.removeMouseMoveListener(this.listenerForCanvas_);
        canvas.removeMouseTrackListener(this.listenerForCanvas_);
        canvas.removeFocusListener(this.listenerForCanvas_);
        this.eventBroker_.removeView(this);
    }

    private void updateBlockStatus(MouseEvent mouseEvent) {
        ArgumentChecker.throwIfNull((Object)mouseEvent);
        this.blockStatus_ = this.igoBoardPanel_.getBlockStatus(new Point(mouseEvent.x, mouseEvent.y));
        this.updateBlockSituation(mouseEvent);
    }

    protected final void updateBlockSituation(MouseEvent mouseEvent) {
        if (this.eventDelegator_ == null) {
            throw new IllegalStateException("eventDelegator is null. You need call registerDelegator before.");
        }
        BlockSituation blockSituation = this.eventDelegator_.getBlockSituation(this.igoBoardPanel_.getNodeView(), this.blockStatus_, mouseEvent);
        this.igoBoardPanel_.getCanvas().setCursor(blockSituation.getCursor());
        this.igoBoardPanel_.paintInTransient(blockSituation.getTransientProperty());
    }

    protected final void mouseButtonUp(MouseEvent mouseEvent) {
        ArgumentChecker.throwIfNull((Object)mouseEvent);
        if (this.eventDelegator_ == null) {
            throw new IllegalStateException("eventDelegator is null. You need call registerDelegator before.");
        }
        if (this.eventDelegator_.executeEvent(this.igoBoardPanel_.getNodeView(), this.blockStatus_, mouseEvent, this.eventBroker_)) {
            this.updateBlockStatus(mouseEvent);
        }
    }

    protected final boolean changeVariation(int n) {
        return ViewerUtils.toVariationIndex(n, this.igoBoardPanel_.getNodeView(), this.eventBroker_);
    }

    protected void keyPressed(KeyEvent keyEvent) {
        if (this.eventDelegator_ == null) {
            throw new IllegalStateException("eventDelegator is null. You need call registerDelegator before.");
        }
        this.eventDelegator_.keyPressed(this.igoBoardPanel_.getNodeView(), this.eventBroker_, keyEvent);
    }

    protected void keyReleased(KeyEvent keyEvent) {
        this.eventDelegator_.keyReleased(this.igoBoardPanel_.getNodeView(), this.eventBroker_, keyEvent);
    }

    protected void mouseWheel(int n) {
    }

    private class ListenerForCanvas
    implements MouseListener,
    MouseMoveListener,
    MouseTrackListener,
    FocusListener,
    Listener {
        private MouseEvent lastMouseEvent_ = null;

        private ListenerForCanvas() {
        }

        public void handleEvent(Event event) {
            Canvas canvas = CanvasHookedStateHandler.this.igoBoardPanel_.getCanvas();
            if (canvas.isDisposed() || !Swts.isMouseOn(canvas)) {
                return;
            }
            KeyEvent keyEvent = new KeyEvent(event);
            switch (event.type) {
                case 1: {
                    CanvasHookedStateHandler.this.keyPressed(keyEvent);
                    break;
                }
                case 2: {
                    CanvasHookedStateHandler.this.keyReleased(keyEvent);
                }
            }
        }

        public void mouseUp(MouseEvent mouseEvent) {
            this.lastMouseEvent_ = mouseEvent;
            CanvasHookedStateHandler.this.mouseButtonUp(mouseEvent);
        }

        public void mouseDoubleClick(MouseEvent mouseEvent) {
            this.lastMouseEvent_ = mouseEvent;
        }

        public void mouseDown(MouseEvent mouseEvent) {
            this.lastMouseEvent_ = mouseEvent;
        }

        public void mouseMove(MouseEvent mouseEvent) {
            this.lastMouseEvent_ = mouseEvent;
            CanvasHookedStateHandler.this.updateBlockStatus(mouseEvent);
        }

        public void mouseEnter(MouseEvent mouseEvent) {
            this.lastMouseEvent_ = mouseEvent;
        }

        public void mouseExit(MouseEvent mouseEvent) {
            this.lastMouseEvent_ = mouseEvent;
        }

        public void mouseHover(MouseEvent mouseEvent) {
            this.lastMouseEvent_ = mouseEvent;
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            BlockSituation blockSituation = new BlockSituation();
            CanvasHookedStateHandler.this.igoBoardPanel_.getCanvas().setCursor(blockSituation.getCursor());
            CanvasHookedStateHandler.this.igoBoardPanel_.paintInTransient(blockSituation.getTransientProperty());
        }
    }

    private class Adapter
    implements MouseWheelMonitor {
        private Adapter() {
        }

        public boolean mouseWheelRolled(Point point, int n) {
            if (!Swts.isMouseOn(CanvasHookedStateHandler.this.igoBoardPanel_.getCanvas())) {
                return false;
            }
            CanvasHookedStateHandler.this.mouseWheel(n);
            return true;
        }
    }
}

