/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board.mp;

import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.unitarou.jface.ColorResource;
import org.unitarou.swt.Rectangles;
import org.unitarou.swt.Swts;
import org.unitarou.yukinoshita.view.jface.board.mp.AbstractPainter;

class TerritoryWhitePainter
extends AbstractPainter {
    private static final ColorResource BODY = new ColorResource(255, 255, 255);
    private static final ColorResource BORDER = new ColorResource(153, 153, 153);
    private static final ColorResource TRANSPARENT = new ColorResource(0, 255, 0);
    private static double sizeRatio_s_ = 0.45;

    public static void setSizeRatio(double d) {
        sizeRatio_s_ = d;
    }

    public static double getSizeRatio() {
        return sizeRatio_s_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ImageData createImageData() {
        ImageData imageData;
        Image image = null;
        GC gC = null;
        try {
            Point point = this.getSize();
            image = new Image(null, point.x, point.y);
            gC = new GC(image);
            Rectangle rectangle = Geometry.createRectangle(new Point(0, 0), point);
            rectangle = Rectangles.createScaled(rectangle, sizeRatio_s_);
            gC.setBackground(TRANSPARENT.get());
            gC.fillRectangle(image.getBounds());
            gC.setBackground(BODY.get());
            gC.fillRectangle(rectangle);
            gC.setLineWidth(1);
            gC.setLineStyle(1);
            gC.setForeground(BORDER.get());
            gC.drawRectangle(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
            ImageData imageData2 = image.getImageData();
            imageData2.transparentPixel = imageData2.getPixel(0, 0);
            imageData = imageData2;
        }
        catch (Throwable throwable) {
            Swts.disposeQuietly(gC);
            Swts.disposeQuietly(image);
            throw throwable;
        }
        Swts.disposeQuietly(gC);
        Swts.disposeQuietly(image);
        return imageData;
    }
}

