/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.db;

import java.util.List;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.filter.RemoveSgfIdFilter;
import org.unitarou.yukinoshita.Application;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.view.jface.db.AbstractFilterPanel;
import org.unitarou.yukinoshita.view.jface.db.FilterPanel;
import org.unitarou.yukinoshita.view.jface.db.FingerprintFilterIgoBoard;
import org.unitarou.yukinoshita.view.jface.db.FingerprintQuery;
import org.unitarou.yukinoshita.view.jface.db.MoveQuery;
import org.unitarou.yukinoshita.view.jface.dlg.fe.QueryBoardEditorDialog;
import org.unitarou.yukinoshita.view.jface.util.SwtFactory;

public class BoardFilterPanel
extends AbstractFilterPanel {
    private static final Message LB_COND_UNUSED = new Message(BoardFilterPanel.class, "lbCondUnused");
    private static final Message LB_COND_POSITION = new Message(BoardFilterPanel.class, "lbCondPosition");
    private static final Message LB_COND_MOVES = new Message(BoardFilterPanel.class, "lbCondMoves");
    private Composite frame_;
    private Label lbQuery_;
    private final FingerprintFilterIgoBoard board_;
    private FingerprintQuery fpQuery_;
    private MoveQuery moveQuery_;
    private Collection userMaked_;
    private int idxMaked_;

    public BoardFilterPanel(GameType gameType) {
        this.board_ = new FingerprintFilterIgoBoard(gameType);
        this.fpQuery_ = new FingerprintQuery();
        this.moveQuery_ = new MoveQuery();
        this.userMaked_ = new Collection();
        RootGameTree rootGameTree = this.board_.getGame();
        this.userMaked_.addLast(rootGameTree);
        RootGameTree rootGameTree2 = new RootGameTree(rootGameTree);
        RemoveSgfIdFilter removeSgfIdFilter = new RemoveSgfIdFilter(SgfId.DIM_POINTS);
        rootGameTree2 = removeSgfIdFilter.filter(rootGameTree2);
        this.userMaked_.addLast(rootGameTree2);
        this.idxMaked_ = GameType.GAME.equals(gameType) ? 1 : 0;
    }

    public void close() {
    }

    public Composite createContents(Composite composite) {
        this.frame_ = new Composite(composite, 0);
        this.frame_.setLayout(SwtFactory.createThinInnerGrid(1, true));
        this.lbQuery_ = new Label(this.frame_, 131072);
        this.lbQuery_.setText(LB_COND_UNUSED.get());
        this.lbQuery_.setLayoutData(new GridData(16384, 0x1000000, true, false));
        CanvasListener canvasListener = new CanvasListener();
        this.board_.createContents(this.frame_);
        this.board_.getControl().setLayoutData(new GridData(4, 4, true, true));
        this.board_.getControl().addMouseTrackListener(canvasListener);
        this.board_.getControl().addMouseListener(canvasListener);
        return this.frame_;
    }

    public Composite getControl() {
        return this.frame_;
    }

    private void notifyListerner() {
        for (FilterPanel.Listener listener : this.getListeners()) {
            listener.filterChanged();
        }
    }

    public FingerprintQuery getFingerprintQuery() {
        return this.fpQuery_;
    }

    public MoveQuery getMoveQuery() {
        return this.moveQuery_;
    }

    private void updateQueryLabel() {
        if (this.fpQuery_.isEnabled()) {
            this.lbQuery_.setText(LB_COND_POSITION.get((Object)this.fpQuery_.getSimilarity()));
        } else if (this.moveQuery_.isEnabled()) {
            this.lbQuery_.setText(LB_COND_MOVES.get(this.moveQuery_.getLength(), this.moveQuery_.getOffset()));
        } else {
            this.lbQuery_.setText(LB_COND_UNUSED.get());
        }
        this.lbQuery_.getParent().layout();
    }

    private class CanvasListener
    extends MouseAdapter
    implements MouseTrackListener {
        private CanvasListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseUp(MouseEvent mouseEvent) {
            int n = BoardFilterPanel.this.idxMaked_ == 0 ? BoardFilterPanel.this.fpQuery_.getSimilarity() : BoardFilterPanel.this.moveQuery_.getOffset();
            QueryBoardEditorDialog queryBoardEditorDialog = new QueryBoardEditorDialog(BoardFilterPanel.this.userMaked_, BoardFilterPanel.this.idxMaked_, n, BoardFilterPanel.this.frame_.getShell());
            try {
                Yukinoshita.application().setCursorType(Application.CursorType.WAIT);
                queryBoardEditorDialog.create();
            }
            finally {
                Yukinoshita.application().setCursorType(Application.CursorType.NONE);
            }
            if (0 != queryBoardEditorDialog.open()) {
                return;
            }
            BoardFilterPanel.this.userMaked_ = queryBoardEditorDialog.getCollection();
            BoardFilterPanel.this.idxMaked_ = queryBoardEditorDialog.getIdxRootGameTree();
            BoardFilterPanel.this.board_.setGame(BoardFilterPanel.this.userMaked_.get(BoardFilterPanel.this.idxMaked_));
            List<SgfPoint> list = queryBoardEditorDialog.getFilter();
            BoardFilterPanel.this.board_.setFilter(list);
            BoardFilterPanel.this.fpQuery_ = queryBoardEditorDialog.makeFingerprintQuery();
            BoardFilterPanel.this.moveQuery_ = queryBoardEditorDialog.makeMoveQuery();
            BoardFilterPanel.this.updateQueryLabel();
            BoardFilterPanel.this.board_.getControl().getShell().update();
            BoardFilterPanel.this.notifyListerner();
        }

        public void mouseEnter(MouseEvent mouseEvent) {
            Display display = BoardFilterPanel.this.frame_.getDisplay();
            Shell shell = BoardFilterPanel.this.frame_.getShell();
            shell.setCursor(display.getSystemCursor(21));
        }

        public void mouseExit(MouseEvent mouseEvent) {
            Shell shell = BoardFilterPanel.this.frame_.getShell();
            shell.setCursor(null);
        }

        public void mouseHover(MouseEvent mouseEvent) {
        }
    }
}

