/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.db;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.Fingerprints;
import org.unitarou.sgf.util.SgfRectangle;
import org.unitarou.sgf.util.Stone;
import org.unitarou.yukinoshita.model.db.SearchFileCondition;
import org.unitarou.yukinoshita.model.db.SearchedFile;
import org.unitarou.yukinoshita.model.db.hsql.StoredFunctions;
import org.unitarou.yukinoshita.view.jface.board.RuledLinePainter;
import org.unitarou.yukinoshita.view.jface.board.SimpleRuledLinePainter;
import org.unitarou.yukinoshita.view.jface.board.bp.BoardPainter;
import org.unitarou.yukinoshita.view.jface.board.bp.SimpleBoardPainter;
import org.unitarou.yukinoshita.view.jface.board.sp.StonePainter;
import org.unitarou.yukinoshita.view.jface.board.sp.StonePainterParameter;
import org.unitarou.yukinoshita.view.jface.db.HitMissPainter;

public class FingerprintPainter {
    private final BoardPainter boardPainter_ = new SimpleBoardPainter();
    private final RuledLinePainter ruledLinePainter_ = new SimpleRuledLinePainter();
    private final StonePainter stonePainter_ = StonePainter.CONTEXT.defaultValue();
    private final HitMissPainter hitPainter_ = new HitMissPainter(new RGB(0, 0, 255));
    private final HitMissPainter missPainter_ = new HitMissPainter(new RGB(255, 0, 0));

    public void paint(GC gC, Rectangle rectangle, SearchedFile searchedFile, SearchFileCondition searchFileCondition) {
        byte[] byArray;
        byte[] byArray2;
        SgfSize sgfSize = SgfSize.create(searchedFile.getWidth(), searchedFile.getHeight());
        byte[] byArray3 = searchedFile.getFingerprint();
        int n = searchedFile.getGameType();
        SgfRectangle sgfRectangle = this.calcViewArea(sgfSize, n, byArray3);
        if (sgfSize.equals(searchFileCondition.getSgfSize())) {
            byte[][] byArray4 = this.getMatchFingerprint(byArray3, searchFileCondition);
            byArray2 = this.calcHitPoints(byArray3, byArray4);
            byArray = this.calcMissPoints(byArray3, byArray4);
        } else {
            byArray = byArray2 = new byte[byArray3.length];
        }
        this.drawImageImpl(gC, rectangle, sgfSize, sgfRectangle, byArray3, byArray2, byArray);
    }

    private SgfRectangle calcViewArea(SgfSize sgfSize, int n, byte[] byArray) {
        int n2;
        int n3;
        int n4;
        SgfRectangle sgfRectangle = new SgfRectangle();
        sgfRectangle.set(SgfPoint.create(sgfSize, 1, 1), SgfPoint.create(sgfSize, sgfSize.width(), sgfSize.height()));
        if (n != GameType.PROBLEM.getIntValue()) {
            return sgfRectangle;
        }
        int n5 = n4 = sgfSize.width();
        while (n5 >= 2) {
            n3 = 0;
            for (n2 = 1; n2 <= sgfSize.height(); ++n2) {
                if (null == Fingerprints.getColor(byArray, sgfSize, n5, n2)) continue;
                n3 = 1;
                break;
            }
            if (n3 != 0) break;
            n4 = n5--;
        }
        n3 = n5 = sgfSize.height();
        while (n3 >= 2) {
            n2 = 0;
            for (int i = 1; i <= sgfSize.width(); ++i) {
                if (null == Fingerprints.getColor(byArray, sgfSize, i, n3)) continue;
                n2 = 1;
                break;
            }
            if (n2 != 0) break;
            n5 = n3--;
        }
        sgfRectangle.set(SgfPoint.create(sgfSize, 1, 1), SgfPoint.create(sgfSize, n4, n5));
        return sgfRectangle;
    }

    private byte[][] getMatchFingerprint(byte[] byArray, SearchFileCondition searchFileCondition) {
        int n = 0;
        int n2 = Integer.MAX_VALUE;
        byte[][] byArray2 = searchFileCondition.getFingerprint();
        byte[][] byArray3 = searchFileCondition.getNtArea();
        for (int i = 0; i < byArray2.length; ++i) {
            int n3 = StoredFunctions.similarity(byArray3[i], byArray2[i], byArray);
            if (n3 >= n2) continue;
            n2 = n3;
            n = i;
        }
        byte[][] byArray4 = new byte[2][byArray.length];
        System.arraycopy(byArray2[n], 0, byArray4[0], 0, byArray4[0].length);
        System.arraycopy(byArray3[n], 0, byArray4[1], 0, byArray4[1].length);
        return byArray4;
    }

    private byte[] calcHitPoints(byte[] byArray, byte[][] byArray2) {
        byte[] byArray3 = new byte[byArray.length];
        for (int i = 0; i < byArray3.length; ++i) {
            byArray3[i] = (byte)(byArray2[1][i] & ~(byArray[i] ^ byArray2[0][i]));
        }
        return byArray3;
    }

    private byte[] calcMissPoints(byte[] byArray, byte[][] byArray2) {
        byte[] byArray3 = new byte[byArray.length];
        for (int i = 0; i < byArray3.length; ++i) {
            byArray3[i] = (byte)(byArray2[1][i] & (byArray[i] ^ byArray2[0][i]));
        }
        return byArray3;
    }

    private void drawImageImpl(GC gC, Rectangle rectangle, SgfSize sgfSize, SgfRectangle sgfRectangle, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n = Math.min(rectangle.width / sgfRectangle.width(), rectangle.height / sgfRectangle.height());
        gC.setBackground(gC.getDevice().getSystemColor(22));
        gC.fillRectangle(rectangle);
        if (n < 3) {
            return;
        }
        Point point = new Point(rectangle.x + (rectangle.width - n * sgfRectangle.width()) / 2, rectangle.y + (rectangle.height - n * sgfRectangle.height()) / 2);
        SgfPoint sgfPoint = sgfRectangle.getStart();
        StonePainterParameter stonePainterParameter = new StonePainterParameter();
        for (int i = sgfPoint.y(); i <= sgfRectangle.getEnd().y(); ++i) {
            for (int j = sgfPoint.x(); j <= sgfRectangle.getEnd().x(); ++j) {
                SgfPoint sgfPoint2 = SgfPoint.create(sgfSize, j, i);
                Rectangle rectangle2 = new Rectangle((j - 1) * n + point.x, (i - 1) * n + point.y, n, n);
                this.boardPainter_.paint(gC, sgfPoint2, rectangle2);
                this.ruledLinePainter_.paint(gC, sgfPoint2, rectangle2);
                SgfColor sgfColor = Fingerprints.getColor(byArray, sgfSize, j, i);
                if (sgfColor != null) {
                    Stone stone = new Stone(sgfColor, sgfPoint2, null);
                    this.setParameters(stonePainterParameter, stone);
                    this.stonePainter_.paintStone(gC, rectangle2, stonePainterParameter);
                }
                if (3 == Fingerprints.getValue(byArray2, sgfSize, j, i)) {
                    this.hitPainter_.paint(gC, rectangle2, false);
                }
                if (0 == Fingerprints.getValue(byArray3, sgfSize, j, i)) continue;
                this.missPainter_.paint(gC, rectangle2, false);
            }
        }
    }

    private void setParameters(StonePainterParameter stonePainterParameter, Stone stone) {
        stonePainterParameter.setSgfColor(stone.getColor());
        stonePainterParameter.setLastMove(false);
        stonePainterParameter.setTransient(false);
    }
}

