/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.db;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.SetOperator;
import org.unitarou.ml.Message;
import org.unitarou.sgf.type.GameType;
import org.unitarou.swt.UStackLayout;
import org.unitarou.yukinoshita.Application;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.model.db.Term;
import org.unitarou.yukinoshita.view.jface.db.AbstractFilterPanel;
import org.unitarou.yukinoshita.view.jface.db.ColumnType;
import org.unitarou.yukinoshita.view.jface.db.FilterPanel;
import org.unitarou.yukinoshita.view.jface.db.TermSheet;
import org.unitarou.yukinoshita.view.jface.util.SwtFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TermFilterPanel
extends AbstractFilterPanel {
    private static final Message LB_TYPE = new Message(TermFilterPanel.class, "lbType");
    private Composite frame_;
    private Combo cbOperator_;
    private Combo cbColumnType_;
    private final List<ColumnType> targetTypes_;
    private Composite sheetFrame_;
    private UStackLayout<TermSheet> stackLayout_;
    private final Map<ColumnType, TermSheet> termSheetMap_;
    private final GameType gameType_;
    private final EnumSet<SetOperator> setOperators_;

    public TermFilterPanel(GameType gameType, List<ColumnType> list, EnumSet<SetOperator> enumSet) {
        ArgumentChecker.throwIfNull((Object)gameType, list, enumSet);
        this.gameType_ = gameType;
        this.targetTypes_ = new ArrayList<ColumnType>(list);
        this.setOperators_ = EnumSet.copyOf(enumSet);
        this.termSheetMap_ = new HashMap<ColumnType, TermSheet>();
    }

    @Override
    public void close() {
    }

    @Override
    public Composite createContents(Composite composite) {
        this.frame_ = new Composite(composite, 0);
        this.frame_.setLayout(SwtFactory.createThinGrid(1, true));
        ChangeListener changeListener = new ChangeListener();
        if (!this.setOperators_.isEmpty()) {
            this.cbOperator_ = new Combo(this.frame_, 12);
            for (SetOperator setOperator : this.setOperators_) {
                this.cbOperator_.add(setOperator.toString());
            }
            this.cbOperator_.select(0);
            this.cbOperator_.addSelectionListener(changeListener);
            this.cbOperator_.setLayoutData(new GridData(4, 128, true, false));
        }
        Control control = this.createColumnTypeSelectorPart(this.frame_);
        control.setLayoutData(new GridData(4, 128, true, false));
        this.sheetFrame_ = new Composite(this.frame_, 0);
        this.sheetFrame_.setLayoutData(new GridData(4, 4, true, true));
        this.stackLayout_ = new UStackLayout();
        this.sheetFrame_.setLayout(this.stackLayout_);
        this.createTermSheet(this.sheetFrame_);
        return this.frame_;
    }

    private void createTermSheet(Composite composite) {
        TermSheet.createUnique(this.targetTypes_, this.termSheetMap_);
        FilterPanel.Listener listener = new FilterPanel.Listener(){

            public void filterChanged() {
                TermFilterPanel.this.notifyListerner();
            }
        };
        for (TermSheet termSheet : this.termSheetMap_.values()) {
            termSheet.addListener(listener);
            termSheet.createContents(composite);
        }
    }

    public List<Term> getSelected() {
        TermSheet termSheet = this.stackLayout_.getWidgetContainer();
        if (termSheet == null) {
            return Collections.emptyList();
        }
        return termSheet.getSelected();
    }

    public SetOperator getOperator() {
        if (this.cbOperator_ == null) {
            return null;
        }
        int n = this.cbOperator_.getSelectionIndex();
        for (SetOperator setOperator : this.setOperators_) {
            if (n == 0) {
                return setOperator;
            }
            --n;
        }
        return null;
    }

    private void notifyListerner() {
        for (FilterPanel.Listener listener : this.getListeners()) {
            listener.filterChanged();
        }
    }

    private Control createColumnTypeSelectorPart(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout(SwtFactory.createThinInnerGrid(2, false));
        Label label = new Label(composite2, 16384);
        label.setText(LB_TYPE.get());
        label.setLayoutData(new GridData(16384, 0x1000000, false, false));
        this.cbColumnType_ = new Combo(composite2, 12);
        this.cbColumnType_.setLayoutData(new GridData(4, 0x1000000, true, false));
        for (ColumnType columnType : this.targetTypes_) {
            this.cbColumnType_.add(columnType.toString());
        }
        this.cbColumnType_.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TermFilterPanel.this.changeColumnType(TermFilterPanel.this.cbColumnType_.getSelectionIndex());
            }
        });
        return composite2;
    }

    @Override
    public Composite getControl() {
        return this.frame_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeColumnType(int n) {
        try {
            Yukinoshita.application().setCursorType(Application.CursorType.WAIT);
            ColumnType columnType = this.targetTypes_.get(n);
            TermSheet termSheet = this.termSheetMap_.get((Object)columnType);
            if (termSheet == null) {
                assert (false) : "Unknown INDEX is selected: " + n;
                return;
            }
            this.stackLayout_.setWidgetContainer(termSheet);
            termSheet.updateContents(this.gameType_, columnType);
            termSheet.getControl().getParent().layout();
        }
        finally {
            Yukinoshita.application().setCursorType(Application.CursorType.NONE);
        }
    }

    private class ChangeListener
    extends SelectionAdapter {
        private ChangeListener() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            TermFilterPanel.this.notifyListerner();
        }
    }
}

