/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.dlg;

import java.io.File;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.GameType;
import org.unitarou.yukinoshita.FileManager;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.provider.rgtlp.RootGameTreeLabelProvider;

public class AskSaveDialog
extends TitleAreaDialog {
    public static final int SAVE_ID = 1024;
    public static final int SAVEAS_ID = 1025;
    public static final int NOSAVE_ID = 1026;
    public static final int CANCEL_ID = 1;
    private static final Message LB_CONFIRM_SAVE_FILE = new Message(AskSaveDialog.class, "lbConfirmSaveFile");
    private static final Message LB_ASK_SAVE_FILE = new Message(AskSaveDialog.class, "lbAskSaveFile");
    private static final Message LB_SAVE_FILE_PATH = new Message(AskSaveDialog.class, "lbSaveFilePath");
    private static final Message LB_NEW_FILE = new Message(AskSaveDialog.class, "lbNewFile");
    private static final Message CLB_SAVE = new Message(AskSaveDialog.class, "clbSave");
    private static final Message CLB_SAVEAS = new Message(AskSaveDialog.class, "clbSaveAs");
    private static final Message CLB_NOSAVE = new Message(AskSaveDialog.class, "clbNoSave");
    private static final Message CLB_CANCEL = new Message(AskSaveDialog.class, "clbCancel");
    private static final Message LB_CHANGE_MARK = new Message(AskSaveDialog.class, "lbChangeMark");
    private static final Message LB_NO_NAME = new Message(AskSaveDialog.class, "lbNoName");
    private static final Message LB_NUMBER = new Message(AskSaveDialog.class, "lbNumber");
    private static final Message LB_CHANGE = new Message(AskSaveDialog.class, "lbChange");
    private static final Message LB_GAME = new Message(AskSaveDialog.class, "lbGame");
    private static final int COLS_BUTTON = 2;
    private final GameFrameController gfc_;

    public AskSaveDialog(Shell shell, GameFrameController gameFrameController) {
        super(shell);
        this.setShellStyle(65584);
        ArgumentChecker.throwIfNull((Object)shell, (Object)gameFrameController);
        this.gfc_ = gameFrameController;
        if (!FileManager.instance().checkOverwritable(this.gfc_.getCollection())) {
            this.gfc_.getCollection().setFile(null);
        }
    }

    protected Control createContents(Composite composite) {
        File file = this.gfc_.getCollection().getFile();
        String string = file != null ? file.getPath() : LB_NEW_FILE.get();
        Control control = super.createContents(composite);
        this.setTitle(LB_ASK_SAVE_FILE.get());
        this.setMessage(LB_SAVE_FILE_PATH.get((Object)string));
        Shell shell = this.getShell();
        shell.setText(LB_CONFIRM_SAVE_FILE.get());
        int n = Math.min(this.gfc_.getCollection().size() * 10 + 200, 320);
        shell.setSize(480, n);
        return control;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        TableViewer tableViewer = new TableViewer(composite2, 65536);
        tableViewer.setContentProvider(new CollectionContentsProvider());
        tableViewer.setLabelProvider(new CollectionLabelProvier());
        Table table = tableViewer.getTable();
        table.setLayoutData(new GridData(1808));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        new TableColumn(table, 16384).setText(LB_CHANGE.get());
        new TableColumn(table, 0x1000000).setText(LB_NUMBER.get());
        new TableColumn(table, 0x1000000).setText(SgfId.GAME_TYPE.displayName());
        new TableColumn(table, 16384).setText(LB_GAME.get());
        tableViewer.setInput(this.gfc_);
        TableColumn[] tableColumnArray = table.getColumns();
        for (int i = 0; i < tableColumnArray.length; ++i) {
            tableColumnArray[i].pack();
        }
        return composite2;
    }

    protected Button createButton(Composite composite, int n, String string, boolean bl) {
        Button button = super.createButton(composite, n, string, bl);
        ((GridLayout)composite.getLayout()).numColumns = 2;
        return button;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        Button button = this.createButton(composite, 1024, CLB_SAVE.get(), false);
        button.setEnabled(this.gfc_.getCollection().getFile() != null);
        this.createButton(composite, 1025, CLB_SAVEAS.get(), true);
        this.createButton(composite, 1026, CLB_NOSAVE.get(), false);
        this.createButton(composite, 1, CLB_CANCEL.get(), false);
    }

    protected void buttonPressed(int n) {
        this.setReturnCode(n);
        this.close();
    }

    private class CollectionLabelProvier
    implements ITableLabelProvider {
        private CollectionLabelProvier() {
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            int n2 = ((Number)object).intValue();
            Collection collection = AskSaveDialog.this.gfc_.getCollection();
            RootGameTreeLabelProvider rootGameTreeLabelProvider = Yukinoshita.context(collection).getProvider(RootGameTreeLabelProvider.class);
            RootGameTree rootGameTree = collection.get(n2);
            switch (n) {
                case 0: {
                    boolean[] blArray = AskSaveDialog.this.gfc_.getCollectionEditor().getChangedFlags();
                    return blArray[n2] ? LB_CHANGE_MARK.get() : "";
                }
                case 1: {
                    return String.valueOf(n2 + 1);
                }
                case 2: {
                    return rootGameTree.getGameType().displayName();
                }
                case 3: {
                    String string = rootGameTreeLabelProvider.getLabel(rootGameTree);
                    return "".equals(string) ? LB_NO_NAME.get() : string;
                }
            }
            return "";
        }

        public void addListener(ILabelProviderListener iLabelProviderListener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object object, String string) {
            return false;
        }

        public void removeListener(ILabelProviderListener iLabelProviderListener) {
        }
    }

    private static class CollectionContentsProvider
    implements IStructuredContentProvider {
        private CollectionContentsProvider() {
        }

        public Object[] getElements(Object object) {
            GameFrameController gameFrameController = (GameFrameController)object;
            if (GameType.DRILL.equals(gameFrameController.getCollectionEditor().getCollection().get(0).getGameType())) {
                return new Integer[]{0};
            }
            Object[] objectArray = new Integer[gameFrameController.getCollection().size()];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = i;
            }
            return objectArray;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }
}

