/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.gi;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.util.BasicFinder;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.EventBrokerMonitor;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.view.jface.YukinoshitaPanel;
import org.unitarou.yukinoshita.view.jface.gi.GameInfoSheet;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameInfoPanel
implements YukinoshitaPanel {
    private Composite frame_ = null;
    private GameInfoSheet currentSheet_ = null;
    private final StackLayout stackLayout_ = new StackLayout();
    private final Adapter adapter_;
    private final Map<GameType, GameInfoSheet> panelsMap_ = new HashMap<GameType, GameInfoSheet>();

    public GameInfoPanel() {
        this.adapter_ = new Adapter();
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public Control createContents(Composite composite) {
        this.frame_ = new Composite(composite, 0);
        this.frame_.setLayout(this.stackLayout_);
        this.stackLayout_.topControl = null;
        return this.frame_;
    }

    @Override
    public void close() {
    }

    @Override
    public Control getControl() {
        return this.frame_;
    }

    public boolean add(GameInfoSheet gameInfoSheet) {
        ArgumentChecker.throwIfNull((Object)gameInfoSheet);
        GameInfoSheet gameInfoSheet2 = this.panelsMap_.get(gameInfoSheet.getGameType());
        if (gameInfoSheet2 != null) {
            return false;
        }
        this.panelsMap_.put(gameInfoSheet.getGameType(), gameInfoSheet);
        return true;
    }

    private GameInfoSheet getSheet(GameType gameType) {
        GameInfoSheet gameInfoSheet = this.panelsMap_.get(gameType);
        if (gameInfoSheet == null) {
            gameInfoSheet = new GameInfoSheet();
        }
        return gameInfoSheet;
    }

    public void update(RootGameTree rootGameTree) {
        this.updateSheet(rootGameTree.getGameType());
        Node node = BasicFinder.findNode(rootGameTree.getSequence(), PropertyType.GAME_INFO);
        if (node == null) {
            node = new Node();
        }
        this.currentSheet_.update(node);
    }

    private void updateSheet(GameType gameType) {
        this.currentSheet_ = this.getSheet(gameType);
        Control control = this.currentSheet_.getControl();
        if (control == null) {
            control = this.currentSheet_.createContents(this.frame_);
        }
        this.stackLayout_.topControl = control;
        this.frame_.layout();
    }

    private class Adapter
    implements EventBrokerMonitor,
    GameMonitor {
        private EventBroker eventBroker_ = EventBroker.NULL_BROKER;

        private Adapter() {
        }

        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull((Object)eventBroker);
            this.eventBroker_.removeView(GameInfoPanel.this);
            this.eventBroker_ = eventBroker;
            this.eventBroker_.addView(GameInfoPanel.this);
            for (GameInfoSheet gameInfoSheet : GameInfoPanel.this.panelsMap_.values()) {
                gameInfoSheet.setEventBroker(eventBroker);
            }
        }

        public void update(GameMediator gameMediator) {
            ArgumentChecker.throwIfNull((Object)gameMediator);
            if (GameInfoPanel.this.frame_ == null) {
                return;
            }
            GameInfoPanel.this.updateSheet(gameMediator.getGameType());
        }
    }
}

