/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.gm;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ToolBar;
import org.unitarou.jface.UActionContributionItem;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.util.Situation;
import org.unitarou.yukinoshita.DatabaseManager;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.EventBrokerMonitor;
import org.unitarou.yukinoshita.model.CollectionEditor;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.ProblemStatus;
import org.unitarou.yukinoshita.model.db.Score;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.jface.YukinoshitaPanel;
import org.unitarou.yukinoshita.view.jface.gm.HandlerStatusActions;
import org.unitarou.yukinoshita.view.jface.resource.NodeImage;
import org.unitarou.yukinoshita.view.monitor.CollectionMonitor;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.GameInfoNodeMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeStatusPanel
implements YukinoshitaPanel {
    private static final Message LB_SITUATION_DRAW = new Message(NodeStatusPanel.class, "lbSituationDraw");
    private static final Message LB_SITUATION_WHITE = new Message(NodeStatusPanel.class, "lbSituationWhite");
    private static final Message LB_SITUATION_BLACK = new Message(NodeStatusPanel.class, "lbSituationBlack");
    private static final Message LB_PROBLEM_COUNTER = new Message(NodeStatusPanel.class, "lbProblemCounter");
    private static final Message LB_TOTAL_SCORE = new Message(NodeStatusPanel.class, "lbTotalScore");
    private Composite composite_ = null;
    private final ToolBarManager toolBarManager_ = new ToolBarManager(0x800000);
    private Label statusLabel_ = null;
    private Label whiteCaptured_ = null;
    private Label blackCaptured_ = null;
    private final HandlerStatusActions handlerStatusActions_ = new HandlerStatusActions();
    private final Adapter adapter_ = new Adapter();

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public Control createContents(Composite composite) {
        this.composite_ = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        this.composite_.setLayout(gridLayout);
        ToolBar toolBar = this.toolBarManager_.createControl(this.composite_);
        GridData gridData = new GridData(16384, 0x1000000, false, false);
        toolBar.setLayoutData(gridData);
        this.createStatusArea(this.composite_);
        this.createCapturedArea(this.composite_);
        return this.composite_;
    }

    private void createStatusArea(Composite composite) {
        this.statusLabel_ = new Label(composite, 131072);
        GridData gridData = new GridData(131072, 0x1000000, true, false);
        this.statusLabel_.setLayoutData(gridData);
    }

    private void createCapturedArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridData gridData = new GridData(131072, 0x1000000, false, false);
        composite2.setLayoutData(gridData);
        composite2.setLayout(new RowLayout());
        Label label = new Label(composite2, 16384);
        label.setImage(NodeImage.WHITE.get());
        this.whiteCaptured_ = new Label(composite2, 16384);
        label = new Label(composite2, 16384);
        label.setImage(NodeImage.BLACK.get());
        this.blackCaptured_ = new Label(composite2, 16384);
    }

    @Override
    public Control getControl() {
        return this.composite_;
    }

    @Override
    public void close() {
    }

    private void updateToolBar() {
        Action[] actionArray;
        this.toolBarManager_.removeAll();
        for (Action action : actionArray = this.handlerStatusActions_.getActions()) {
            action.setEnabled(true);
            this.toolBarManager_.add(new UActionContributionItem(action));
        }
        this.toolBarManager_.update(false);
        this.toolBarManager_.getControl().getParent().layout();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Adapter
    implements CollectionMonitor,
    GameMonitor,
    GameInfoNodeMonitor,
    NodeMonitor,
    ControllerStatusMonitor,
    EventBrokerMonitor {
        private EventBroker eventBroker_ = EventBroker.NULL_BROKER;
        private Reference<CollectionEditor> refCe = new WeakReference<Object>(null);
        private Reference<NodeView> refNodeView = new WeakReference<Object>(null);
        private String problemCounter_ = "";
        private String score_ = "";

        private Adapter() {
        }

        @Override
        public void update(CollectionEditor collectionEditor) {
            NodeStatusPanel.this.updateToolBar();
            this.refCe = new WeakReference<CollectionEditor>(collectionEditor);
        }

        @Override
        public void changeIndexFilter(List<Integer> list) {
        }

        @Override
        public void update(GameMediator gameMediator) {
            CollectionEditor collectionEditor = this.refCe.get();
            if (collectionEditor == null || !collectionEditor.getActiveGame().getGameType().equals(GameType.PROBLEM)) {
                this.problemCounter_ = "";
                this.score_ = "";
                return;
            }
            Collection collection = collectionEditor.getCollection();
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < collection.size(); ++i) {
                if (!collection.get(i).getGameType().equals(GameType.PROBLEM)) continue;
                ++n;
                if (i > collectionEditor.getActiveGameIndex()) continue;
                ++n2;
            }
            this.problemCounter_ = LB_PROBLEM_COUNTER.get(n2, n);
            RootGameTree rootGameTree = collectionEditor.getActiveGame().getRootGameTree();
            Score[] scoreArray = DatabaseManager.instance().selectScore(rootGameTree);
            int n3 = 0;
            for (Score score : scoreArray) {
                if (score.getResult() != ProblemStatus.CORRECT.getId()) continue;
                ++n3;
            }
            double d = 0.0;
            if (scoreArray.length != 0) {
                d = 100 * n3 / scoreArray.length;
            }
            this.score_ = LB_TOTAL_SCORE.get(scoreArray.length, n3, new Double(d));
        }

        @Override
        public void currentChanged(NodeView nodeView) {
            String string;
            ArgumentChecker.throwIfNull((Object)nodeView);
            this.refNodeView = new WeakReference<NodeView>(nodeView);
            boolean bl = false;
            String string2 = String.valueOf(nodeView.getCaptured(SgfColor.WHITE).size());
            if (!string2.equals(NodeStatusPanel.this.whiteCaptured_.getText())) {
                NodeStatusPanel.this.whiteCaptured_.setText(string2);
                bl = true;
            }
            if (!(string = String.valueOf(nodeView.getCaptured(SgfColor.BLACK).size())).equals(NodeStatusPanel.this.blackCaptured_.getText())) {
                NodeStatusPanel.this.blackCaptured_.setText(string);
                bl = true;
            }
            if (bl |= this.updateStatusLabel(nodeView)) {
                NodeStatusPanel.this.composite_.layout();
            }
        }

        @Override
        public void gameInfoChanged(NodeView nodeView) {
            if (nodeView.getProperty(SgfId.KOMI) == null) {
                return;
            }
            NodeView nodeView2 = this.refNodeView.get();
            if (nodeView2 == null) {
                return;
            }
            if (this.updateStatusLabel(nodeView2)) {
                NodeStatusPanel.this.composite_.layout();
            }
        }

        private boolean updateStatusLabel(NodeView nodeView) {
            StringBuilder stringBuilder = new StringBuilder();
            this.updateSituation(nodeView, stringBuilder);
            stringBuilder.append(this.score_).append(' ').append(this.problemCounter_);
            String string = stringBuilder.toString();
            String string2 = NodeStatusPanel.this.statusLabel_.getText();
            if (!string2.equals(string)) {
                NodeStatusPanel.this.statusLabel_.setText(string);
                return true;
            }
            return false;
        }

        private void updateSituation(NodeView nodeView, StringBuilder stringBuilder) {
            Situation situation = nodeView.getSituation();
            if (situation.isEmpty()) {
                return;
            }
            Object[] objectArray = new Object[]{new Double(situation.score()), situation.getBlackTerritory() + situation.getBlackCaptured(), situation.getWhiteTerritory() + situation.getWhiteCaptured(), new Double(situation.getKomi())};
            SgfColor sgfColor = situation.winner();
            if (sgfColor == SgfColor.WHITE) {
                stringBuilder.append(LB_SITUATION_WHITE.get(objectArray));
            } else if (sgfColor == SgfColor.BLACK) {
                stringBuilder.append(LB_SITUATION_BLACK.get(objectArray));
            } else {
                stringBuilder.append(LB_SITUATION_DRAW.get(objectArray));
            }
        }

        @Override
        public void setEditMode(boolean bl) {
            NodeStatusPanel.this.updateToolBar();
        }

        @Override
        public void changeHandlerPhase(HandlerPhase handlerPhase) {
        }

        @Override
        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull((Object)eventBroker);
            this.eventBroker_.removeView(NodeStatusPanel.this);
            this.eventBroker_ = eventBroker;
            this.eventBroker_.addView(NodeStatusPanel.this);
            NodeStatusPanel.this.handlerStatusActions_.setEventBroker(this.eventBroker_);
            NodeStatusPanel.this.updateToolBar();
        }
    }
}

