/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.jface;

import java.io.File;
import java.io.FileFilter;
import java.text.CollationKey;
import java.text.Collator;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.unitarou.io.Ios;
import org.unitarou.jface.FileAnnotationLabelProvider;
import org.unitarou.jface.FileFolderListener;
import org.unitarou.jface.FileListContentProvider;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.ml.Message;
import org.unitarou.swt.Swts;
import org.unitarou.swt.WidgetContainer;

public class FilesTableViewer
implements WidgetContainer {
    private static final Log log_s_ = LogFactory.getLog(FilesTableViewer.class);
    private static final Message LB_FILENAME = new Message(FilesTableViewer.class, "lbFilename");
    private File folder_;
    private final int tvFlag_;
    private TableViewer tableViewer_;
    private FileFilter fileFilter_;
    private final Set<FileFolderListener> listeners_;

    public FilesTableViewer() {
        this(67588);
    }

    public FilesTableViewer(int n) {
        this.tvFlag_ = n;
        this.folder_ = Ios.getCurrentDirectory();
        this.tableViewer_ = null;
        this.fileFilter_ = TrueFileFilter.INSTANCE;
        this.listeners_ = new HashSet<FileFolderListener>();
    }

    public Control createContents(Composite composite) {
        ArgumentChecker.throwIfNull((Object)composite);
        this.tableViewer_ = new TableViewer(composite, this.tvFlag_);
        Table table = this.tableViewer_.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        Swts.defeatMouseWheel(table);
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setText(LB_FILENAME.get());
        tableColumn.setWidth(200);
        this.tableViewer_.setContentProvider(new FileListContentProvider());
        this.tableViewer_.setLabelProvider(new FileAnnotationLabelProvider());
        this.tableViewer_.addFilter(new ViewerFilterImpl());
        this.tableViewer_.setSorter(new ViewerSorterImpl(new CollatorImpl()));
        this.tableViewer_.setInput(this.folder_);
        TableViewersListener tableViewersListener = new TableViewersListener();
        this.tableViewer_.addPostSelectionChangedListener(tableViewersListener);
        this.tableViewer_.addDoubleClickListener(tableViewersListener);
        return this.tableViewer_.getControl();
    }

    public Control getControl() {
        return this.tableViewer_.getControl();
    }

    public void close() {
    }

    public File getFolder() {
        return this.folder_;
    }

    public void setFolder(File file) {
        ArgumentChecker.throwIfNull((Object)file);
        if (!Ios.isNormalDirectory(file)) {
            log_s_.info("Invalid directory is assigned(ignore this): " + file);
            return;
        }
        this.folder_ = file;
        if (this.tableViewer_ != null) {
            this.tableViewer_.setInput(this.folder_);
        }
    }

    public void setFileFilter(FileFilter fileFilter) {
        ArgumentChecker.throwIfNull((Object)fileFilter);
        this.fileFilter_ = fileFilter;
        this.tableViewer_.refresh();
    }

    public void addListener(FileFolderListener fileFolderListener) {
        if (fileFolderListener == null) {
            return;
        }
        this.listeners_.add(fileFolderListener);
    }

    public void removeListener(FileFolderListener fileFolderListener) {
        this.listeners_.remove(fileFolderListener);
    }

    private static class CollatorImpl
    extends Collator {
        private CollatorImpl() {
        }

        public int compare(String string, String string2) {
            return string.compareTo(string2);
        }

        public CollationKey getCollationKey(String string) {
            return null;
        }

        public int hashCode() {
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ViewerSorterImpl
    extends ViewerSorter {
        private final Comparator<String> comparator_ = new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return string.compareToIgnoreCase(string2);
            }
        };

        public ViewerSorterImpl(Collator collator) {
            super(collator);
        }

        @Override
        protected Comparator<?> getComparator() {
            return this.comparator_;
        }

        @Override
        public int category(Object object) {
            if (object instanceof File) {
                File file = (File)object;
                return file.isDirectory() ? 0 : 1;
            }
            return super.category(object);
        }
    }

    private class ViewerFilterImpl
    extends ViewerFilter {
        private ViewerFilterImpl() {
        }

        public boolean select(Viewer viewer, Object object, Object object2) {
            if (object2 instanceof File) {
                File file = (File)object2;
                return (file.isDirectory() || FilesTableViewer.this.fileFilter_.accept(file)) && !file.isHidden();
            }
            return false;
        }
    }

    private class TableViewersListener
    implements ISelectionChangedListener,
    IDoubleClickListener {
        private TableViewersListener() {
        }

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            Object[] objectArray = ((IStructuredSelection)selectionChangedEvent.getSelection()).toArray();
            if (objectArray == null) {
                objectArray = new Object[]{};
            }
            File[] fileArray = new File[objectArray.length];
            System.arraycopy(objectArray, 0, fileArray, 0, fileArray.length);
            for (FileFolderListener fileFolderListener : FilesTableViewer.this.listeners_) {
                fileFolderListener.filesFocused(fileArray);
            }
        }

        public void doubleClick(DoubleClickEvent doubleClickEvent) {
            File file = (File)((IStructuredSelection)doubleClickEvent.getSelection()).getFirstElement();
            if (file.isDirectory()) {
                for (FileFolderListener fileFolderListener : FilesTableViewer.this.listeners_) {
                    fileFolderListener.folderChanged(file);
                }
                FilesTableViewer.this.folder_ = file;
                return;
            }
            for (FileFolderListener fileFolderListener : FilesTableViewer.this.listeners_) {
                fileFolderListener.filesDoubleClicked(file);
            }
        }
    }
}

