/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.jface;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Classes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageResource {
    private static final ImageRegistry imageRegistry_s_ = JFaceResources.getImageRegistry();
    private static final Log log_s_ = LogFactory.getLog(ImageResource.class);
    private final String key_;
    private final Class<?> resourceClass_;

    public static void put(Class<?> clazz, String string, String string2) {
        ArgumentChecker.throwIfNull(clazz, (Object)string, (Object)string2);
        String string3 = Classes.uniqueKey(clazz, string);
        imageRegistry_s_.put(string3, ImageDescriptor.createFromFile(clazz, string2));
    }

    public static void put(Class<?> clazz, String string, ImageData imageData) {
        ArgumentChecker.throwIfNull(clazz, (Object)string, (Object)imageData);
        String string2 = Classes.uniqueKey(clazz, string);
        imageRegistry_s_.put(string2, ImageDescriptor.createFromImageData(imageData));
    }

    public static Image get(Class<?> clazz, String string) {
        ArgumentChecker.throwIfNull(clazz, (Object)string);
        return imageRegistry_s_.get(Classes.uniqueKey(clazz, string));
    }

    public ImageResource(Class<?> clazz, String string) {
        ArgumentChecker.throwIfNull(clazz, (Object)string);
        this.resourceClass_ = clazz;
        this.key_ = Classes.uniqueKey(this.resourceClass_, string);
        imageRegistry_s_.put(this.key_, ImageDescriptor.createFromFile(this.resourceClass_, string));
    }

    public Image get() {
        Image image = imageRegistry_s_.get(this.key_);
        if (image == null) {
            log_s_.warn("Image is not found: key_=" + this.key_);
            return ImageDescriptor.getMissingImageDescriptor().createImage();
        }
        return image;
    }

    public ImageData getImageData() {
        ImageDescriptor imageDescriptor = imageRegistry_s_.getDescriptor(this.key_);
        if (imageDescriptor == null) {
            log_s_.warn("Image is not found: key_=" + this.key_);
            return ImageDescriptor.getMissingImageDescriptor().getImageData();
        }
        ImageData imageData = imageDescriptor.getImageData();
        if (imageData == null) {
            log_s_.warn("Image has no data: key_=" + this.key_);
            return ImageDescriptor.getMissingImageDescriptor().getImageData();
        }
        return imageData;
    }

    protected String getKey() {
        return this.key_;
    }

    protected Class<?> getResourceClass() {
        return this.resourceClass_;
    }
}

