/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.jface;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.ExternalActionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class UActionContributionItem
extends ContributionItem {
    public static int MODE_FORCE_TEXT = 1;
    private static final int LOWER_GTK_ACCEL_BOUND = SWT.MOD1 | SWT.MOD2 | 0x41;
    private static final int UPPER_GTK_ACCEL_BOUND = SWT.MOD1 | SWT.MOD2 | 0x46;
    private static final String ellipsis = "...";
    private static boolean USE_COLOR_ICONS = true;
    private int mode = 0;
    private IAction action;
    private final IPropertyChangeListener actionTextListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            UActionContributionItem.this.update(propertyChangeEvent.getProperty());
        }
    };
    private LocalResourceManager imageManager;
    private Listener buttonListener;
    private Listener menuItemListener;
    private final IPropertyChangeListener propertyListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            UActionContributionItem.this.actionPropertyChange(propertyChangeEvent);
        }
    };
    private Listener toolItemListener;
    private Widget widget = null;

    public static boolean getUseColorIconsInToolbars() {
        return USE_COLOR_ICONS;
    }

    public static void setUseColorIconsInToolbars(boolean bl) {
        USE_COLOR_ICONS = bl;
    }

    public UActionContributionItem(IAction iAction) {
        super(iAction.getId());
        this.action = iAction;
    }

    private void actionPropertyChange(final PropertyChangeEvent propertyChangeEvent) {
        if (this.isVisible() && this.widget != null) {
            Display display = this.widget.getDisplay();
            if (display.getThread() == Thread.currentThread()) {
                this.update(propertyChangeEvent.getProperty());
            } else {
                display.asyncExec(new Runnable(){

                    public void run() {
                        UActionContributionItem.this.update(propertyChangeEvent.getProperty());
                    }
                });
            }
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof UActionContributionItem)) {
            return false;
        }
        return this.action.equals(((UActionContributionItem)object).action);
    }

    public void fill(Composite composite) {
        if (this.widget == null && composite != null) {
            int n = 8;
            if (this.action != null) {
                if (this.action.getStyle() == 2) {
                    n = 2;
                }
                if (this.action.getStyle() == 8) {
                    n = 16;
                }
            }
            Button button = new Button(composite, n);
            button.setData(this);
            button.addListener(12, this.getButtonListener());
            button.addListener(13, this.getButtonListener());
            if (this.action.getHelpListener() != null) {
                button.addHelpListener(this.action.getHelpListener());
            }
            this.widget = button;
            this.update(null);
            this.action.addPropertyChangeListener(this.propertyListener);
            if (this.action != null) {
                String string = this.action.getActionDefinitionId();
                ExternalActionManager.ICallback iCallback = ExternalActionManager.getInstance().getCallback();
                if (iCallback != null && string != null) {
                    iCallback.addPropertyChangeListener(string, this.actionTextListener);
                }
            }
        }
    }

    public void fill(Menu menu, int n) {
        if (this.widget == null && menu != null) {
            Object object;
            Menu menu2 = null;
            int n2 = 8;
            if (this.action != null) {
                int n3 = this.action.getStyle();
                if (n3 == 2) {
                    n2 = 32;
                } else if (n3 == 8) {
                    n2 = 16;
                } else if (n3 == 4 && (object = this.action.getMenuCreator()) != null) {
                    menu2 = object.getMenu(menu);
                    n2 = 64;
                }
            }
            MenuItem menuItem = null;
            menuItem = n >= 0 ? new MenuItem(menu, n2, n) : new MenuItem(menu, n2);
            this.widget = menuItem;
            menuItem.setData(this);
            menuItem.addListener(12, this.getMenuItemListener());
            menuItem.addListener(13, this.getMenuItemListener());
            if (this.action.getHelpListener() != null) {
                menuItem.addHelpListener(this.action.getHelpListener());
            }
            if (menu2 != null) {
                menuItem.setMenu(menu2);
            }
            this.update(null);
            this.action.addPropertyChangeListener(this.propertyListener);
            if (this.action != null) {
                object = this.action.getActionDefinitionId();
                ExternalActionManager.ICallback iCallback = ExternalActionManager.getInstance().getCallback();
                if (iCallback != null && object != null) {
                    iCallback.addPropertyChangeListener((String)object, this.actionTextListener);
                }
            }
        }
    }

    public void fill(ToolBar toolBar, int n) {
        if (this.widget == null && toolBar != null) {
            int n2 = 8;
            if (this.action != null) {
                int n3 = this.action.getStyle();
                if (n3 == 2) {
                    n2 = 32;
                } else if (n3 == 8) {
                    n2 = 16;
                } else if (n3 == 4) {
                    n2 = 4;
                }
            }
            ToolItem toolItem = null;
            toolItem = n >= 0 ? new ToolItem(toolBar, n2, n) : new ToolItem(toolBar, n2);
            toolItem.setData(this);
            toolItem.addListener(13, this.getToolItemListener());
            toolItem.addListener(12, this.getToolItemListener());
            this.widget = toolItem;
            this.update(null);
            this.action.addPropertyChangeListener(this.propertyListener);
            if (this.action != null) {
                String string = this.action.getActionDefinitionId();
                ExternalActionManager.ICallback iCallback = ExternalActionManager.getInstance().getCallback();
                if (iCallback != null && string != null) {
                    iCallback.addPropertyChangeListener(string, this.actionTextListener);
                }
            }
        }
    }

    public IAction getAction() {
        return this.action;
    }

    private Listener getButtonListener() {
        if (this.buttonListener == null) {
            this.buttonListener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 12: {
                            UActionContributionItem.this.handleWidgetDispose(event);
                            break;
                        }
                        case 13: {
                            Widget widget = event.widget;
                            if (widget == null) break;
                            UActionContributionItem.this.handleWidgetSelection(event, ((Button)widget).getSelection());
                        }
                    }
                }
            };
        }
        return this.buttonListener;
    }

    private Listener getMenuItemListener() {
        if (this.menuItemListener == null) {
            this.menuItemListener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 12: {
                            UActionContributionItem.this.handleWidgetDispose(event);
                            break;
                        }
                        case 13: {
                            Widget widget = event.widget;
                            if (widget == null) break;
                            UActionContributionItem.this.handleWidgetSelection(event, ((MenuItem)widget).getSelection());
                        }
                    }
                }
            };
        }
        return this.menuItemListener;
    }

    public int getMode() {
        return this.mode;
    }

    private Listener getToolItemListener() {
        if (this.toolItemListener == null) {
            this.toolItemListener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 12: {
                            UActionContributionItem.this.handleWidgetDispose(event);
                            break;
                        }
                        case 13: {
                            Widget widget = event.widget;
                            if (widget == null) break;
                            UActionContributionItem.this.handleWidgetSelection(event, ((ToolItem)widget).getSelection());
                            Control control = event.display.getCursorControl();
                            if (control == null) break;
                            control.forceFocus();
                        }
                    }
                }
            };
        }
        return this.toolItemListener;
    }

    private void handleWidgetDispose(Event event) {
        if (event.widget == this.widget) {
            Object object;
            if (this.action.getStyle() == 4 && (object = this.action.getMenuCreator()) != null) {
                object.dispose();
            }
            this.action.removePropertyChangeListener(this.propertyListener);
            if (this.action != null) {
                object = this.action.getActionDefinitionId();
                ExternalActionManager.ICallback iCallback = ExternalActionManager.getInstance().getCallback();
                if (iCallback != null && object != null) {
                    iCallback.removePropertyChangeListener((String)object, this.actionTextListener);
                }
            }
            this.widget = null;
            this.disposeOldImages();
        }
    }

    private void handleWidgetSelection(Event event, boolean bl) {
        Widget widget = event.widget;
        if (widget != null) {
            int n = widget.getStyle();
            if ((n & 0x22) != 0) {
                if (this.action.getStyle() == 2) {
                    this.action.setChecked(bl);
                }
            } else if ((n & 0x10) != 0) {
                if (this.action.getStyle() == 8) {
                    this.action.setChecked(bl);
                }
            } else if ((n & 4) != 0 && event.detail == 4 && this.action.getStyle() == 4) {
                Menu menu;
                IMenuCreator iMenuCreator = this.action.getMenuCreator();
                ToolItem toolItem = (ToolItem)widget;
                if (iMenuCreator != null && (menu = iMenuCreator.getMenu(toolItem.getParent())) != null) {
                    Rectangle rectangle = toolItem.getBounds();
                    Point point = toolItem.getParent().toDisplay(new Point(rectangle.x, rectangle.y + rectangle.height));
                    menu.setLocation(point.x, point.y);
                    menu.setVisible(true);
                    return;
                }
            }
            if (this.action.isEnabled()) {
                boolean bl2 = Policy.TRACE_ACTIONS;
                long l = System.currentTimeMillis();
                if (bl2) {
                    System.out.println("Running action: " + this.action.getText());
                }
                this.action.runWithEvent(event);
                if (bl2) {
                    System.out.println(System.currentTimeMillis() - l + " ms to run action: " + this.action.getText());
                }
            }
        }
    }

    public int hashCode() {
        return this.action.hashCode();
    }

    private boolean hasImages(IAction iAction) {
        return iAction.getImageDescriptor() != null || iAction.getHoverImageDescriptor() != null || iAction.getDisabledImageDescriptor() != null;
    }

    private boolean isCommandActive() {
        IAction iAction = this.getAction();
        if (iAction != null) {
            String string = iAction.getActionDefinitionId();
            ExternalActionManager.ICallback iCallback = ExternalActionManager.getInstance().getCallback();
            if (iCallback != null) {
                return iCallback.isActive(string);
            }
        }
        return true;
    }

    public boolean isDynamic() {
        if (this.widget instanceof MenuItem) {
            boolean bl = (this.widget.getStyle() & 0x20) != 0;
            boolean bl2 = this.getAction() != null && this.getAction().getStyle() == 2;
            boolean bl3 = (this.widget.getStyle() & 0x10) != 0;
            boolean bl4 = this.getAction() != null && this.getAction().getStyle() == 8;
            return bl != bl2 || bl3 != bl4;
        }
        return false;
    }

    public boolean isEnabled() {
        return this.action != null && this.action.isEnabled();
    }

    protected boolean isEnabledAllowed() {
        if (this.getParent() == null) {
            return true;
        }
        Boolean bl = this.getParent().getOverrides().getEnabled(this);
        return bl == null ? true : bl;
    }

    public boolean isVisible() {
        return super.isVisible() && this.isCommandActive();
    }

    public void setMode(int n) {
        this.mode = n;
        this.update();
    }

    public final void update() {
        this.update(null);
    }

    public void update(String string) {
        if (this.widget != null) {
            boolean bl;
            boolean bl2 = string == null || string.equals("text");
            boolean bl3 = string == null || string.equals("image");
            boolean bl4 = string == null || string.equals("toolTipText");
            boolean bl5 = string == null || string.equals("enabled") || string.equals("enabled");
            boolean bl6 = bl = !(this.action.getStyle() != 2 && this.action.getStyle() != 8 || string != null && !string.equals("checked"));
            if (this.widget instanceof ToolItem) {
                String string2;
                boolean bl7;
                ToolItem toolItem = (ToolItem)this.widget;
                String string3 = this.action.getText();
                boolean bl8 = bl7 = string3 != null && ((this.getMode() & MODE_FORCE_TEXT) != 0 || !this.hasImages(this.action));
                if (!bl7 || string3 != null) {
                    // empty if block
                }
                if (bl2) {
                    boolean bl9;
                    string2 = bl7 ? string3 : "";
                    boolean bl10 = bl9 = (toolItem.getParent().getStyle() & 0x20000) != 0;
                    if (bl9 || !toolItem.getText().equals(string2)) {
                        toolItem.setText(string2);
                    }
                }
                if (bl3) {
                    this.updateImages(!bl7);
                }
                if (bl4 || bl2) {
                    string2 = this.action.getToolTipText();
                    if (!bl7 || string2 != null && !string2.equals(string3)) {
                        toolItem.setToolTipText(string2);
                    } else {
                        toolItem.setToolTipText(null);
                    }
                }
                if (bl5) {
                    boolean bl11;
                    boolean bl12 = bl11 = this.action.isEnabled() && this.isEnabledAllowed();
                    if (toolItem.getEnabled() != bl11) {
                        toolItem.setEnabled(bl11);
                    }
                }
                if (bl) {
                    boolean bl13 = this.action.isChecked();
                    if (toolItem.getSelection() != bl13) {
                        toolItem.setSelection(bl13);
                    }
                }
                return;
            }
            if (this.widget instanceof MenuItem) {
                int n;
                MenuItem menuItem = (MenuItem)this.widget;
                if (bl2) {
                    int n2;
                    Object object;
                    n = 0;
                    String string4 = null;
                    IAction iAction = this.getAction();
                    String string5 = null;
                    n = iAction.getAccelerator();
                    ExternalActionManager.ICallback iCallback = ExternalActionManager.getInstance().getCallback();
                    if (n != 0 && iCallback != null && iCallback.isAcceleratorInUse(n)) {
                        n = 0;
                    }
                    String string6 = iAction.getActionDefinitionId();
                    if (SWT.getPlatform().equals("gtk") && iCallback != null && string6 != null && (object = iCallback.getAccelerator(string6)) != null && (n2 = iCallback.getAccelerator(string6).intValue()) >= LOWER_GTK_ACCEL_BOUND && n2 <= UPPER_GTK_ACCEL_BOUND) {
                        n = n2;
                        string4 = iCallback.getAcceleratorText(string6);
                    }
                    if (n == 0) {
                        if (iCallback != null && string6 != null) {
                            string4 = iCallback.getAcceleratorText(string6);
                        }
                    } else {
                        string4 = Action.convertAccelerator(n);
                    }
                    object = null;
                    if (this.getParent() != null) {
                        object = this.getParent().getOverrides();
                    }
                    if (object != null) {
                        string5 = this.getParent().getOverrides().getText(this);
                    }
                    menuItem.setAccelerator(n);
                    if (string5 == null) {
                        string5 = iAction.getText();
                    }
                    string5 = string5 == null ? "" : Action.removeAcceleratorText(string5);
                    if (string4 == null) {
                        menuItem.setText(string5);
                    } else {
                        menuItem.setText(string5 + '\t' + string4);
                    }
                }
                if (bl3) {
                    this.updateImages(false);
                }
                if (bl5) {
                    int n3 = n = this.action.isEnabled() && this.isEnabledAllowed() ? 1 : 0;
                    if (menuItem.getEnabled() != n) {
                        menuItem.setEnabled(n != 0);
                    }
                }
                if (bl) {
                    n = this.action.isChecked();
                    if (menuItem.getSelection() != n) {
                        menuItem.setSelection(n != 0);
                    }
                }
                return;
            }
            if (this.widget instanceof Button) {
                Button button = (Button)this.widget;
                if (bl3 && this.updateImages(false)) {
                    bl2 = false;
                }
                if (bl2) {
                    String string7 = this.action.getText();
                    string7 = string7 == null ? "" : Action.removeAcceleratorText(string7);
                    button.setText(string7);
                }
                if (bl4) {
                    button.setToolTipText(this.action.getToolTipText());
                }
                if (bl5) {
                    boolean bl14;
                    boolean bl15 = bl14 = this.action.isEnabled() && this.isEnabledAllowed();
                    if (button.getEnabled() != bl14) {
                        button.setEnabled(bl14);
                    }
                }
                if (bl) {
                    boolean bl16 = this.action.isChecked();
                    if (button.getSelection() != bl16) {
                        button.setSelection(bl16);
                    }
                }
                return;
            }
        }
    }

    private boolean updateImages(boolean bl) {
        ResourceManager resourceManager = JFaceResources.getResources();
        if (this.widget instanceof ToolItem) {
            if (USE_COLOR_ICONS) {
                ImageDescriptor imageDescriptor = this.action.getHoverImageDescriptor();
                if (imageDescriptor == null) {
                    imageDescriptor = this.action.getImageDescriptor();
                }
                ImageDescriptor imageDescriptor2 = this.action.getDisabledImageDescriptor();
                if (imageDescriptor == null && bl) {
                    imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
                }
                LocalResourceManager localResourceManager = new LocalResourceManager(resourceManager);
                ((ToolItem)this.widget).setDisabledImage(imageDescriptor2 == null ? null : localResourceManager.createImageWithDefault(imageDescriptor2));
                ((ToolItem)this.widget).setImage(imageDescriptor == null ? null : localResourceManager.createImageWithDefault(imageDescriptor));
                this.disposeOldImages();
                this.imageManager = localResourceManager;
                return imageDescriptor != null;
            }
            ImageDescriptor imageDescriptor = this.action.getImageDescriptor();
            ImageDescriptor imageDescriptor3 = this.action.getHoverImageDescriptor();
            ImageDescriptor imageDescriptor4 = this.action.getDisabledImageDescriptor();
            if (imageDescriptor == null && imageDescriptor3 != null) {
                imageDescriptor = ImageDescriptor.createWithFlags(this.action.getHoverImageDescriptor(), 2);
            } else if (imageDescriptor3 == null && imageDescriptor != null) {
                imageDescriptor3 = imageDescriptor;
                imageDescriptor = ImageDescriptor.createWithFlags(this.action.getImageDescriptor(), 2);
            }
            if (imageDescriptor3 == null && imageDescriptor == null && bl) {
                imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            LocalResourceManager localResourceManager = new LocalResourceManager(resourceManager);
            ((ToolItem)this.widget).setDisabledImage(imageDescriptor4 == null ? null : localResourceManager.createImageWithDefault(imageDescriptor4));
            ((ToolItem)this.widget).setHotImage(imageDescriptor3 == null ? null : localResourceManager.createImageWithDefault(imageDescriptor3));
            ((ToolItem)this.widget).setImage(imageDescriptor == null ? null : localResourceManager.createImageWithDefault(imageDescriptor));
            this.disposeOldImages();
            this.imageManager = localResourceManager;
            return imageDescriptor != null;
        }
        if (this.widget instanceof Item || this.widget instanceof Button) {
            ImageDescriptor imageDescriptor = this.action.getHoverImageDescriptor();
            if (imageDescriptor == null) {
                imageDescriptor = this.action.getImageDescriptor();
            }
            if (imageDescriptor == null && bl) {
                imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            LocalResourceManager localResourceManager = new LocalResourceManager(resourceManager);
            if (this.widget instanceof Item) {
                ((Item)this.widget).setImage(imageDescriptor == null ? null : localResourceManager.createImageWithDefault(imageDescriptor));
            } else if (this.widget instanceof Button) {
                ((Button)this.widget).setImage(imageDescriptor == null ? null : localResourceManager.createImageWithDefault(imageDescriptor));
            }
            this.disposeOldImages();
            this.imageManager = localResourceManager;
            return imageDescriptor != null;
        }
        return false;
    }

    private void disposeOldImages() {
        if (this.imageManager != null) {
            this.imageManager.dispose();
            this.imageManager = null;
        }
    }

    protected String shortenText(String string, ToolItem toolItem) {
        if (string == null) {
            return null;
        }
        GC gC = new GC(toolItem.getDisplay());
        int n = toolItem.getImage().getBounds().width * 4;
        if (gC.textExtent((String)string).x < n) {
            gC.dispose();
            return string;
        }
        for (int i = string.length(); i > 0; --i) {
            String string2 = string.substring(0, i);
            string2 = string2 + ellipsis;
            if (gC.textExtent((String)string2).x >= n) continue;
            gC.dispose();
            return string2;
        }
        gC.dispose();
        return string;
    }
}

