/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util;

import java.util.HashSet;
import java.util.Set;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.Fingerprints;
import org.unitarou.util.Filter;
import org.unitarou.util.NullFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Fingerprint {
    private final SgfSize size_;
    private final byte[] bytes_;
    private Filter<SgfPoint> filter_;

    public Fingerprint(SgfSize sgfSize) {
        ArgumentChecker.throwIfNull((Object)sgfSize);
        this.size_ = sgfSize;
        this.bytes_ = new byte[Fingerprints.getArrayLength(this.size_)];
        this.filter_ = new NullFilter<SgfPoint>();
    }

    public Filter<SgfPoint> getFilter() {
        return this.filter_;
    }

    public void setFilter(Filter<SgfPoint> filter) {
        ArgumentChecker.throwIfNull(filter);
        this.filter_ = filter;
    }

    public void setStone(Set<SgfPoint> set, byte by) {
        HashSet<SgfPoint> hashSet = new HashSet<SgfPoint>(set.size());
        for (SgfPoint sgfPoint : set) {
            hashSet.add(this.filter_.filter(sgfPoint));
        }
        this.setStoneNoFilter(hashSet, by);
    }

    void setStoneNoFilter(Set<SgfPoint> set, byte by) {
        for (SgfPoint sgfPoint : set) {
            int n = (sgfPoint.y() - 1) * this.size_.width() + (sgfPoint.x() - 1);
            int n2 = n / 4;
            int n3 = (3 - n % 4) * 2;
            byte by2 = by;
            by2 = (byte)(by2 << n3);
            int n4 = n2;
            this.bytes_[n4] = (byte)(this.bytes_[n4] & ~(3 << n3));
            int n5 = n2;
            this.bytes_[n5] = (byte)(this.bytes_[n5] | by2);
        }
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[this.bytes_.length];
        System.arraycopy(this.bytes_, 0, byArray, 0, byArray.length);
        return this.bytes_;
    }

    public SgfColor getColor(int n, int n2) {
        return Fingerprints.getColor(this.bytes_, this.size_, n, n2);
    }
}

