/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfReal;
import org.unitarou.sgf.type.TimeLapsed;
import org.unitarou.sgf.type.TypedString;
import org.unitarou.sgf.util.Stone;
import org.unitarou.yukinoshita.model.NodeList;
import org.unitarou.yukinoshita.model.NodeListEditor;
import org.unitarou.yukinoshita.model.NodeTree;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.board.IgoBoard;
import org.unitarou.yukinoshita.model.board.InheritableMarker;
import org.unitarou.yukinoshita.model.board.MarkupIgoBoard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NodeEntity {
    private static final Log log_s_ = LogFactory.getLog(NodeEntity.class);
    public static final int NO_VARIATION = -1;
    private static final String PRE_APPENDED = "appended";
    private static final String PRE_REMOVED = "removed";
    private static final String APPEND_SETUP_BLACK = "appended" + SgfId.ADD_BLACK.id();
    private static final String REMOVE_SETUP_BLACK = "removed" + SgfId.ADD_BLACK.id();
    private static final String APPEND_SETUP_WHITE = "appended" + SgfId.ADD_WHITE.id();
    private static final String REMOVE_SETUP_WHITE = "removed" + SgfId.ADD_WHITE.id();
    private static final Set<SgfId> idSet4Problem_s_ = Collections.unmodifiableSet(new HashSet<SgfId>(Arrays.asList(SgfId.BLACK, SgfId.KO, SgfId.SET_MOVE_NUMBER, SgfId.WHITE, SgfId.ADD_BLACK, SgfId.ADD_EMPTY, SgfId.ADD_WHITE, SgfId.PLAYER_TO_PLAY, SgfId.COMMENT, SgfId.GOOD_FOR_BLACK, SgfId.GOOD_FOR_WHITE, SgfId.BAD_MOVE, SgfId.ARROW, SgfId.CIRCLE, SgfId.DIM_POINTS, SgfId.LABEL, SgfId.LINE, SgfId.MARK_WITH_X, SgfId.SELECTED, SgfId.SQUARE, SgfId.TRIANGLE, SgfId.APPLICATION, SgfId.CHARSET, SgfId.FILE_FORMAT, SgfId.GAME_MODE, SgfId.GAME_TYPE, SgfId.STYLE, SgfId.SIZE, SgfId.BLACK_RANK, SgfId.COPYRIGHT, SgfId.DATE, SgfId.GAME_COMMENT, SgfId.GAME_NAME, SgfId.RESULT, SgfId.SOURCE, SgfId.TIMELIMIT, SgfId.USER, SgfId.VIEW)));
    private static final Set<SgfId> idSet4Drill_s_ = Collections.unmodifiableSet(new HashSet<SgfId>(Arrays.asList(SgfId.APPLICATION, SgfId.CHARSET, SgfId.FILE_FORMAT, SgfId.GAME_MODE, SgfId.GAME_TYPE, SgfId.STYLE, SgfId.BLACK_RANK, SgfId.GAME_COMMENT, SgfId.GAME_NAME, SgfId.INPUT_FILES, SgfId.PROBLEM_PROPERTIES)));
    private final NodeListEditor nodeList_;
    private final Map<String, SgfPoint[]> inheritPointMap_;
    private NodeEntity previous_;
    private final Node node_;
    private int selectedVariationIndex_;
    private final NodeTree nodeTree_;
    private final InheritableMarker inheritableDecoration_;
    private Stone move_;
    private final List<Stone> capturedStones_;
    private final Set<SgfPoint> invalidPoints_;
    private NodeView nodeView_;

    public NodeEntity(Node node, GameTree gameTree, NodeListEditor nodeListEditor, NodeEntity nodeEntity) {
        ArgumentChecker.throwIfNull((Object)node, (Object)gameTree, (Object)nodeListEditor);
        this.node_ = node;
        this.nodeTree_ = new NodeTree(this.node_, gameTree);
        this.nodeList_ = nodeListEditor;
        this.previous_ = nodeEntity;
        this.nodeView_ = null;
        this.inheritPointMap_ = new HashMap<String, SgfPoint[]>();
        this.inheritPointMap_.put(APPEND_SETUP_BLACK, SgfPoint.EMPTY_ARRAY);
        this.inheritPointMap_.put(REMOVE_SETUP_BLACK, SgfPoint.EMPTY_ARRAY);
        this.inheritPointMap_.put(APPEND_SETUP_WHITE, SgfPoint.EMPTY_ARRAY);
        this.inheritPointMap_.put(REMOVE_SETUP_WHITE, SgfPoint.EMPTY_ARRAY);
        for (SgfId sgfId : PropertyType.INHERIT.getSgfTypeSet()) {
            this.inheritPointMap_.put(PRE_APPENDED + sgfId.id(), SgfPoint.EMPTY_ARRAY);
            this.inheritPointMap_.put(PRE_REMOVED + sgfId.id(), SgfPoint.EMPTY_ARRAY);
        }
        this.selectedVariationIndex_ = this.nodeTree_.getVariationSize() == 0 ? -1 : 0;
        this.inheritableDecoration_ = new InheritableMarker();
        this.move_ = Stone.NULL_STONE;
        this.composeMove();
        this.capturedStones_ = new ArrayList<Stone>(0);
        this.invalidPoints_ = new HashSet<SgfPoint>(1);
    }

    public void setSelectedVariationIndex(int n) {
        int n2 = this.nodeTree_.getVariationSize();
        if (0 < n2 && (n < 0 || this.nodeTree_.getVariationSize() <= n)) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0 && n != -1) {
            throw new IndexOutOfBoundsException();
        }
        this.selectedVariationIndex_ = n;
    }

    void setPrevious(NodeEntity nodeEntity) {
        this.previous_ = nodeEntity;
    }

    void forwardUpdate(NodeEntity nodeEntity, MarkupIgoBoard markupIgoBoard) {
        this.previous_ = nodeEntity;
        this.updateVariationIndex();
        this.setStones(SgfColor.BLACK, markupIgoBoard);
        this.setStones(SgfColor.WHITE, markupIgoBoard);
        this.setEmpties(markupIgoBoard);
        this.moveStone(markupIgoBoard);
        this.invalidPoints_.clear();
        this.invalidPoints_.addAll(markupIgoBoard.validate());
        this.updateInheritedDecoration();
    }

    void backwardUpdate(MarkupIgoBoard markupIgoBoard) {
        this.updateVariationIndex();
        for (SgfPoint sgfPoint : this.inheritPointMap_.get(APPEND_SETUP_BLACK)) {
            markupIgoBoard.removeStone(sgfPoint);
        }
        for (SgfPoint sgfPoint : this.inheritPointMap_.get(APPEND_SETUP_WHITE)) {
            markupIgoBoard.removeStone(sgfPoint);
        }
        for (SgfPoint sgfPoint : this.inheritPointMap_.get(REMOVE_SETUP_BLACK)) {
            markupIgoBoard.setStone(new Stone(SgfColor.BLACK, sgfPoint, null));
        }
        for (SgfPoint sgfPoint : this.inheritPointMap_.get(REMOVE_SETUP_WHITE)) {
            markupIgoBoard.setStone(new Stone(SgfColor.WHITE, sgfPoint, null));
        }
        if (this.move_.isValid()) {
            markupIgoBoard.removeStone(this.move_.getPoint());
            for (Stone stone : this.capturedStones_) {
                markupIgoBoard.setStone(stone);
            }
            markupIgoBoard.removeCaptured(this.capturedStones_);
        }
    }

    public void updateVariationIndex() {
        int n = this.nodeTree_.getVariationSize();
        if (n == 0) {
            this.selectedVariationIndex_ = -1;
        } else if (n <= this.selectedVariationIndex_ || this.selectedVariationIndex_ == -1) {
            this.selectedVariationIndex_ = 0;
        }
    }

    private void setStones(SgfColor sgfColor, IgoBoard igoBoard) {
        Property property = this.node_.getProperty(sgfColor.setupType());
        if (property == null) {
            return;
        }
        HashSet<SgfPoint> hashSet = new HashSet<SgfPoint>();
        String[] stringArray = property.getStrings();
        for (SgfPoint sgfPoint : SgfPoint.parse(this.nodeList_.getSize(), stringArray)) {
            hashSet.add(sgfPoint);
            igoBoard.removeStone(sgfPoint);
            igoBoard.setStone(new Stone(sgfColor, sgfPoint, null));
        }
        if (hashSet.isEmpty()) {
            this.inheritPointMap_.put(PRE_APPENDED + sgfColor.setupType().id(), SgfPoint.EMPTY_ARRAY);
        } else {
            this.inheritPointMap_.put(PRE_APPENDED + sgfColor.setupType().id(), hashSet.toArray(new SgfPoint[hashSet.size()]));
        }
    }

    private void setEmpties(IgoBoard igoBoard) {
        Property property = this.node_.getProperty(SgfId.ADD_EMPTY);
        if (property == null) {
            return;
        }
        HashSet<SgfPoint> hashSet = new HashSet<SgfPoint>();
        HashSet<SgfPoint> hashSet2 = new HashSet<SgfPoint>();
        String[] stringArray = property.getStrings();
        for (SgfPoint sgfPoint : SgfPoint.parse(this.nodeList_.getSize(), stringArray)) {
            SgfColor sgfColor = igoBoard.removeStone(sgfPoint);
            if (SgfColor.BLACK.equals(sgfColor)) {
                hashSet.add(sgfPoint);
                continue;
            }
            if (!SgfColor.WHITE.equals(sgfColor)) continue;
            hashSet2.add(sgfPoint);
        }
        this.inheritPointMap_.put(REMOVE_SETUP_BLACK, hashSet.isEmpty() ? SgfPoint.EMPTY_ARRAY : hashSet.toArray(new SgfPoint[hashSet.size()]));
        this.inheritPointMap_.put(REMOVE_SETUP_WHITE, hashSet2.isEmpty() ? SgfPoint.EMPTY_ARRAY : hashSet2.toArray(new SgfPoint[hashSet2.size()]));
    }

    private void moveStone(MarkupIgoBoard markupIgoBoard) {
        this.composeMove();
        if (!this.move_.isValid()) {
            return;
        }
        this.capturedStones_.clear();
        this.capturedStones_.addAll(Arrays.asList(markupIgoBoard.moveStone(this.move_)));
    }

    private void composeMove() {
        this.move_ = Stone.NULL_STONE;
        for (SgfColor sgfColor : new SgfColor[]{SgfColor.BLACK, SgfColor.WHITE}) {
            SgfPoint sgfPoint;
            Property property = this.node_.getProperty(sgfColor.moveType());
            if (property == null || (sgfPoint = SgfPoint.parseMoveQuietly(this.nodeList_.getSize(), property.getString())) == null) continue;
            Integer n = this.composeMoveNumber();
            Double d = this.composeTimeLapsed(sgfColor);
            this.move_ = new Stone(sgfColor, sgfPoint, n, d);
            return;
        }
    }

    private Integer composeMoveNumber() {
        Object object;
        Integer n = 1;
        NodeEntity nodeEntity = this.previous_;
        while (nodeEntity != null) {
            if (!nodeEntity.move_.isValid()) {
                nodeEntity = nodeEntity.previous_;
                continue;
            }
            object = nodeEntity.move_.getNumber();
            if (object == null) break;
            n = (Integer)object + 1;
            break;
        }
        if ((object = this.node_.getProperty(SgfId.SET_MOVE_NUMBER)) != null) {
            try {
                n = Integer.valueOf(((Property)object).getString());
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        return n;
    }

    private Double composeTimeLapsed(SgfColor sgfColor) {
        double d;
        TypedString<TimeLapsed> typedString;
        Property property = this.node_.getProperty(SgfId.TIME_LAPSED);
        if (property != null && (typedString = TimeLapsed.parseQuietly(property.getString())) != null) {
            return new Double(((TimeLapsed)typedString).getTimeLapsed());
        }
        property = this.node_.getProperty(sgfColor.timeType());
        if (property == null) {
            return null;
        }
        typedString = SgfReal.parseQuietly(property.getString());
        if (typedString == null) {
            return null;
        }
        SgfReal sgfReal = null;
        NodeEntity nodeEntity = this.previous_;
        while (nodeEntity != null) {
            property = nodeEntity.node_.getProperty(sgfColor.timeType());
            if (property != null) {
                sgfReal = SgfReal.parseQuietly(property.getString());
                break;
            }
            nodeEntity = nodeEntity.previous_;
        }
        if (sgfReal == null) {
            NodeEntity nodeEntity2 = this.findAbove(PropertyType.GAME_INFO);
            if (nodeEntity2 == null) {
                return null;
            }
            property = nodeEntity2.node_.getProperty(SgfId.TIMELIMIT);
            if (property == null) {
                return null;
            }
            sgfReal = SgfReal.parseQuietly(property.getString());
            if (sgfReal == null) {
                return null;
            }
        }
        if ((d = sgfReal.getReal() - ((SgfReal)typedString).getReal()) < 0.0) {
            return null;
        }
        return new Double(d);
    }

    private void updateInheritedDecoration() {
        if (this.previous_ == null) {
            this.inheritableDecoration_.clear();
        } else {
            this.inheritableDecoration_.set(this.previous_.inheritableDecoration_);
        }
        for (Property property : this.node_.getProperties()) {
            this.inheritableDecoration_.set(property);
        }
    }

    public NodeEntity getPrevious() {
        return this.previous_;
    }

    public NodeEntity getNext() {
        int n = this.nodeList_.indexOf(this);
        if (n == -1) {
            log_s_.warn("NodeEntity dosen't belong to NodeListEditor (BUG).");
            return null;
        }
        if (0 <= ++n && n < this.nodeList_.size()) {
            return this.nodeList_.get(n);
        }
        return null;
    }

    public Node getNode() {
        return this.node_;
    }

    public NodeTree getNodeTree() {
        return this.nodeTree_;
    }

    public int getSelectedVariationIndex() {
        int n = this.nodeTree_.getVariationSize();
        if (n == 0 && this.selectedVariationIndex_ != -1 || n <= this.selectedVariationIndex_ || n != 0 && this.selectedVariationIndex_ == -1) {
            throw new IllegalStateException("Variation miss match. Variation size: " + n + ", index:" + this.selectedVariationIndex_);
        }
        return this.selectedVariationIndex_;
    }

    int getUnmodifiedSelectVariationIndex() {
        return this.selectedVariationIndex_;
    }

    public IgoBoard getIgoBoard() {
        if (!this.nodeList_.contains(this)) {
            if (this.nodeList_.size() == 0) {
                return null;
            }
            int n = Math.min(this.nodeList_.getPositionIndex(), this.nodeList_.size() - 1);
            return this.nodeList_.updateIgoBoard(this.nodeList_.get(n));
        }
        return this.nodeList_.updateIgoBoard(this);
    }

    public void update() {
        this.nodeList_.update(this);
    }

    public Stone getMove() {
        return this.move_;
    }

    public InheritableMarker getInheritableDecoration() {
        this.nodeList_.updateIgoBoard(this);
        return this.inheritableDecoration_;
    }

    public Stone[] getCaptured() {
        return this.capturedStones_.toArray(new Stone[this.capturedStones_.size()]);
    }

    public Stone[] getLastCaptured() {
        HashSet<Stone> hashSet = new HashSet<Stone>(this.capturedStones_);
        NodeEntity nodeEntity = this.getPrevious();
        if (nodeEntity != null) {
            hashSet.removeAll(nodeEntity.capturedStones_);
        }
        return hashSet.toArray(new Stone[hashSet.size()]);
    }

    public NodeEntity[] getVariations() {
        GameTree[] gameTreeArray = this.nodeTree_.getVariation();
        NodeEntity[] nodeEntityArray = new NodeEntity[gameTreeArray.length];
        for (int i = 0; i < nodeEntityArray.length; ++i) {
            nodeEntityArray[i] = new NodeEntity(gameTreeArray[i].getSequence().getFirst(), gameTreeArray[i], this.nodeList_, this.previous_);
            nodeEntityArray[i].composeMove();
        }
        return nodeEntityArray;
    }

    public Set<SgfPoint> getInvalid() {
        return Collections.unmodifiableSet(this.invalidPoints_);
    }

    public NodeEntity findAbove(PropertyType propertyType) {
        NodeEntity nodeEntity;
        ArgumentChecker.throwIfNull((Object)propertyType);
        for (nodeEntity = this; nodeEntity != null; nodeEntity = nodeEntity.getPrevious()) {
            if (!nodeEntity.getNode().contains(propertyType)) continue;
            return nodeEntity;
        }
        return nodeEntity;
    }

    NodeList getNodeList() {
        return this.nodeList_;
    }

    NodeView getNodeView() {
        if (this.nodeView_ == null) {
            this.nodeView_ = new NodeView(this);
        }
        return this.nodeView_;
    }

    public boolean appends(SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sgfId);
        switch (sgfId.propertyType()) {
            case MOVE: {
                if (null != this.node_.getProperty(SgfId.WHITE) || null != this.node_.getProperty(SgfId.BLACK)) break;
                return false;
            }
            case ROOT: {
                if (this.nodeTree_.getRootGameTree().getSequence().getFirst() == this.node_) break;
                return false;
            }
            case SETUP: {
                if (!this.node_.contains(PropertyType.MOVE)) break;
                return false;
            }
        }
        GameType gameType = this.nodeTree_.getRootGameTree().getGameType();
        switch (gameType) {
            case GAME: {
                return true;
            }
            case PROBLEM: {
                return idSet4Problem_s_.contains(sgfId);
            }
            case DRILL: {
                return idSet4Drill_s_.contains(sgfId);
            }
        }
        assert (false) : "Unknown GameType: " + gameType;
        log_s_.warn("Unknown GameType: " + gameType);
        return true;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        return this.node_ == ((NodeEntity)object).node_;
    }

    public int hashCode() {
        return System.identityHashCode(this.node_);
    }
}

