/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.cmd;

import java.util.EnumSet;
import java.util.LinkedList;
import org.unitarou.cmd.Command;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.ml.Message;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.cmd.CreateGameTree;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.Stone;
import org.unitarou.sgf.util.provider.crdlp.CoordinatesLabelProvider;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.model.NodeEntity;
import org.unitarou.yukinoshita.model.NodeListEditor;
import org.unitarou.yukinoshita.model.cmd.Command4NodeList;
import org.unitarou.yukinoshita.model.cmd.ModelInfluence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddVariation
extends Command4NodeList {
    private static final Message LB_NAME = new Message(AddVariation.class, "lbName");
    private static final Message LB_NO_MOVE = new Message(AddVariation.class, "lbNoMove");
    private final GameTree newTree_;
    private LinkedList<NodeEntity> lastChain_;
    private NodeEntity baseEntity_;
    private Command sgfCommand_;
    private EnumSet<ModelInfluence> influences_;

    public AddVariation(SgfColor sgfColor, SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull((Object)sgfColor, (Object)sgfPoint);
        Node node = Node.makeMoveNode(sgfColor, sgfPoint);
        GameTree gameTree = new GameTree();
        gameTree.getSequence().addFirst(node);
        this.newTree_ = gameTree;
        this.lastChain_ = null;
        this.baseEntity_ = null;
        this.sgfCommand_ = null;
        this.influences_ = null;
    }

    @Override
    protected boolean setup() {
        if (this.lastChain_ != null) {
            return true;
        }
        NodeListEditor nodeListEditor = this.getEditableNodeList();
        if (nodeListEditor == null) {
            return false;
        }
        this.baseEntity_ = nodeListEditor.getPosition();
        this.lastChain_ = new LinkedList();
        this.influences_ = this.baseEntity_.getNodeTree().isChildrenStyle() ? EnumSet.of(ModelInfluence.NODE_PEVIOUS) : EnumSet.of(ModelInfluence.NODE_CURRENT);
        this.sgfCommand_ = new CreateGameTree(this.baseEntity_.getNodeTree().getGameTree(), this.baseEntity_.getNode(), this.newTree_);
        this.setExecutedNodeIndex(nodeListEditor.getPositionIndex() + 1);
        this.setUndoneNodeIndex(nodeListEditor.getPositionIndex() + 1);
        return true;
    }

    @Override
    public String displayName() {
        this.composeDisplayName();
        return super.displayName();
    }

    private void composeDisplayName() {
        this.setDisplayName(LB_NAME.get((Object)LB_NO_MOVE.get()));
        if (this.newTree_.getSequence().size() == 0 || !this.setup()) {
            return;
        }
        Stone stone = Stone.create(this.newTree_.getSequence().getFirst(), this.getEditableNodeList().getSize());
        if (!stone.isValid()) {
            return;
        }
        CoordinatesLabelProvider coordinatesLabelProvider = Yukinoshita.context(this.baseEntity_.getNodeTree().getRootGameTree()).getProvider(CoordinatesLabelProvider.class);
        this.setDisplayName(LB_NAME.get((Object)(stone.getColor().displayName() + ':' + coordinatesLabelProvider.getMoveLabel(stone.getPoint()))));
    }

    @Override
    public void execute() {
        super.execute();
        this.sgfCommand_.execute();
        NodeListEditor nodeListEditor = this.getEditableNodeList();
        this.lastChain_.clear();
        NodeEntity nodeEntity = nodeListEditor.removeLast();
        while (!nodeEntity.equals(this.baseEntity_)) {
            this.lastChain_.addFirst(nodeEntity);
            nodeEntity = nodeListEditor.removeLast();
        }
        nodeListEditor.addLast(this.baseEntity_);
        NodeEntity nodeEntity2 = null;
        for (Node node : this.newTree_.getSequence()) {
            NodeEntity nodeEntity3 = nodeListEditor.addLast(node, this.newTree_);
            nodeEntity2 = nodeEntity2 == null ? nodeEntity3 : nodeEntity2;
        }
        int n = this.baseEntity_.getNodeTree().getGameTree().getChildrenSize() - 1;
        if (nodeEntity.getNodeTree().isChildrenStyle()) {
            nodeEntity.setSelectedVariationIndex(n);
        } else if (nodeEntity2 != null) {
            nodeEntity2.setSelectedVariationIndex(n);
        }
    }

    @Override
    public void undo() {
        super.undo();
        this.sgfCommand_.undo();
        NodeEntity nodeEntity = this.getEditableNodeList().removeLast();
        while (!nodeEntity.equals(this.baseEntity_)) {
            nodeEntity = this.getEditableNodeList().removeLast();
        }
        this.getEditableNodeList().addLast(this.baseEntity_);
        this.getEditableNodeList().addLast(this.lastChain_.toArray(new NodeEntity[this.lastChain_.size()]));
    }

    @Override
    public EnumSet<ModelInfluence> getInfluence() {
        return this.influences_;
    }
}

