/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.cmd;

import java.util.EnumSet;
import org.unitarou.cmd.Command;
import org.unitarou.ml.Message;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.cmd.RemoveNode;
import org.unitarou.yukinoshita.model.NodeEntity;
import org.unitarou.yukinoshita.model.NodeListEditor;
import org.unitarou.yukinoshita.model.cmd.Command4NodeList;
import org.unitarou.yukinoshita.model.cmd.ModelInfluence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveCurrentNode
extends Command4NodeList {
    private static final Message LB_NAME = new Message(RemoveCurrentNode.class, "lbName");
    private boolean isSetuped_ = false;
    private Command sgfCommand_ = null;

    @Override
    protected boolean setup() {
        if (this.isSetuped_) {
            return true;
        }
        NodeListEditor nodeListEditor = this.getEditableNodeList();
        if (nodeListEditor == null) {
            return false;
        }
        this.setDisplayName(LB_NAME.get());
        NodeEntity nodeEntity = nodeListEditor.getPosition();
        this.sgfCommand_ = new RemoveNode(nodeEntity.getNodeTree().getGameTree(), nodeEntity.getNode());
        int n = nodeListEditor.getPositionIndex();
        this.setExecutedNodeIndex(n - 1);
        this.setUndoneNodeIndex(n);
        this.isSetuped_ = true;
        return true;
    }

    @Override
    public void execute() {
        super.execute();
        this.sgfCommand_.execute();
        NodeListEditor nodeListEditor = this.getEditableNodeList();
        nodeListEditor.setPositionIndex(this.getExecutedNodeIndex());
        NodeEntity nodeEntity = nodeListEditor.getPosition();
        while (!nodeEntity.equals(nodeListEditor.removeLast())) {
        }
        nodeListEditor.addLast(nodeEntity);
        GameTree gameTree = nodeEntity.getNodeTree().getGameTree();
        boolean bl = false;
        for (Node node : gameTree.getSequence()) {
            if (node == nodeEntity.getNode()) {
                bl = true;
                continue;
            }
            if (!bl) continue;
            this.getEditableNodeList().addLast(node, gameTree);
        }
        if (gameTree.getChildrenSize() != 0) {
            this.getEditableNodeList().addLast(gameTree.getChild(0));
        }
    }

    @Override
    public void undo() {
        super.undo();
        this.sgfCommand_.undo();
        NodeListEditor nodeListEditor = this.getEditableNodeList();
        nodeListEditor.setPositionIndex(this.getExecutedNodeIndex());
        NodeEntity nodeEntity = nodeListEditor.getPosition();
        while (!nodeEntity.equals(nodeListEditor.removeLast())) {
        }
        GameTree gameTree = nodeEntity.getNodeTree().getGameTree();
        boolean bl = false;
        for (Node node : gameTree.getSequence()) {
            if (node == nodeEntity.getNode()) {
                bl = true;
            }
            if (!bl) continue;
            this.getEditableNodeList().addLast(node, gameTree);
        }
        if (gameTree.getChildrenSize() != 0) {
            this.getEditableNodeList().addLast(gameTree.getChild(0));
        }
        nodeListEditor.setPositionIndex(this.getUndoneNodeIndex());
    }

    @Override
    public EnumSet<ModelInfluence> getInfluence() {
        return EnumSet.of(ModelInfluence.NODE_CURRENT, ModelInfluence.NODE_DOWNWARD);
    }
}

