/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.cmd;

import java.util.EnumSet;
import org.unitarou.cmd.Command;
import org.unitarou.ml.Message;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Sequence;
import org.unitarou.yukinoshita.model.NodeEntity;
import org.unitarou.yukinoshita.model.NodeListEditor;
import org.unitarou.yukinoshita.model.NodeTree;
import org.unitarou.yukinoshita.model.cmd.Command4NodeList;
import org.unitarou.yukinoshita.model.cmd.ModelInfluence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveLastNode
extends Command4NodeList {
    private static final Message LB_NAME = new Message(RemoveLastNode.class, "lbName");
    private Command sgfCommand_;
    private NodeEntity removedEntity_;
    private NodeEntity appendPoint_;
    private int childStyleVariationIndex_ = -1;
    private boolean isChildlenMode_;
    private boolean isSetuped_ = false;
    private EnumSet<ModelInfluence> influence_ = EnumSet.noneOf(ModelInfluence.class);

    @Override
    protected boolean setup() {
        if (this.isSetuped_) {
            return true;
        }
        NodeListEditor nodeListEditor = this.getEditableNodeList();
        if (nodeListEditor == null) {
            return false;
        }
        NodeTree nodeTree = nodeListEditor.getLast().getNodeTree();
        this.removedEntity_ = null;
        this.setDisplayName(LB_NAME.get());
        this.setExecutedNodeIndex(nodeListEditor.size() - 2);
        this.setUndoneNodeIndex(nodeListEditor.size() - 1);
        this.isChildlenMode_ = nodeTree.isChildrenStyle();
        if (this.isChildlenMode_) {
            this.childStyleVariationIndex_ = this.getEditableNodeList().getLast().getPrevious().getSelectedVariationIndex();
        }
        this.isSetuped_ = true;
        this.sgfCommand_ = new org.unitarou.sgf.cmd.RemoveLastNode(nodeTree.getGameTree());
        return true;
    }

    @Override
    public void execute() {
        super.execute();
        this.influence_.clear();
        this.influence_.add(ModelInfluence.NODE_CURRENT);
        this.appendPoint_ = this.getEditableNodeList().getLast().getPrevious();
        this.removedEntity_ = this.getEditableNodeList().removeLast();
        NodeTree nodeTree = this.removedEntity_.getNodeTree();
        if (1 == nodeTree.getGameTree().getSequence().size() && nodeTree.getParentGameTree() != null && 2 == nodeTree.getParentGameTree().getChildrenSize()) {
            this.sgfCommand_.execute();
            if (this.getEditableNodeList().size() != 0) {
                NodeEntity nodeEntity = this.getEditableNodeList().getLast();
                if (this.isChildlenMode_) {
                    nodeEntity.updateVariationIndex();
                }
                GameTree gameTree = nodeEntity.getNodeTree().getGameTree();
                Node node = nodeEntity.getNode();
                Sequence.Iterator iterator = gameTree.getSequence().iterator();
                while (iterator.hasNext() && node != iterator.next()) {
                }
                while (iterator.hasNext()) {
                    this.getEditableNodeList().addLast(iterator.next(), gameTree);
                }
                if (gameTree.getChildrenSize() != 0) {
                    this.getEditableNodeList().addLast(gameTree.getChild(0));
                }
                this.influence_.add(ModelInfluence.NODE_DOWNWARD);
            }
        } else if (1 == this.removedEntity_.getNodeTree().getGameTree().getSequence().size()) {
            this.sgfCommand_.execute();
            if (this.getEditableNodeList().size() != 0) {
                NodeEntity nodeEntity = this.getEditableNodeList().getLast();
                GameTree[] gameTreeArray = nodeEntity.getNodeTree().getGameTree().getChildren();
                assert (gameTreeArray.length != 0) : "Lost child tree.";
                this.getEditableNodeList().addLast(gameTreeArray[0]);
                this.influence_.add(ModelInfluence.NODE_DOWNWARD);
            }
        } else {
            this.sgfCommand_.execute();
        }
    }

    @Override
    public void undo() {
        super.undo();
        this.sgfCommand_.undo();
        if (this.isRebuildMode()) {
            NodeEntity nodeEntity = this.getEditableNodeList().removeLast();
            while (!nodeEntity.equals(this.appendPoint_)) {
                nodeEntity = this.getEditableNodeList().removeLast();
            }
            this.getEditableNodeList().addLast(this.appendPoint_);
            this.getEditableNodeList().addLast(this.removedEntity_);
            if (this.isChildlenMode_) {
                this.removedEntity_.getPrevious().setSelectedVariationIndex(this.childStyleVariationIndex_);
            }
        } else {
            this.getEditableNodeList().addLast(this.removedEntity_);
        }
        this.influence_.clear();
        this.influence_.add(ModelInfluence.NODE_CURRENT);
        this.influence_.add(ModelInfluence.NODE_DOWNWARD);
    }

    private boolean isRebuildMode() {
        NodeTree nodeTree = this.removedEntity_.getNodeTree();
        if (!nodeTree.isLastNode()) {
            return false;
        }
        if (this.isChildlenMode_) {
            NodeTree nodeTree2 = this.appendPoint_.getNodeTree();
            return nodeTree2.getVariationSize() != 0;
        }
        return nodeTree.getVariationSize() != 0;
    }

    @Override
    public EnumSet<ModelInfluence> getInfluence() {
        return this.influence_;
    }
}

