/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.cmd;

import java.util.EnumSet;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.yukinoshita.model.cmd.Command4NodeList;
import org.unitarou.yukinoshita.model.cmd.ModelInfluence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequentialCommand
extends Command4NodeList {
    private final String displayName_;
    private final Command4NodeList[] commands_;

    public SequentialCommand(String string, Command4NodeList ... command4NodeListArray) {
        ArgumentChecker.throwIfNull((Object)string);
        ArgumentChecker.throwIfNull(command4NodeListArray);
        this.displayName_ = string;
        this.commands_ = command4NodeListArray;
    }

    @Override
    public EnumSet<ModelInfluence> getInfluence() {
        EnumSet<ModelInfluence> enumSet = EnumSet.noneOf(ModelInfluence.class);
        for (Command4NodeList command4NodeList : this.commands_) {
            enumSet.addAll(command4NodeList.getInfluence());
        }
        return enumSet;
    }

    @Override
    public String displayName() {
        return this.displayName_;
    }

    @Override
    protected boolean setup() {
        boolean bl = true;
        for (Command4NodeList command4NodeList : this.commands_) {
            command4NodeList.setEditableNodeList(this.getEditableNodeList());
            bl &= command4NodeList.setup();
            this.setExecutedNodeIndex(command4NodeList.getExecutedNodeIndex());
            this.setUndoneNodeIndex(command4NodeList.getUndoneNodeIndex());
        }
        return bl;
    }

    @Override
    public void execute() {
        super.execute();
        for (int i = 0; i < this.commands_.length; ++i) {
            this.commands_[i].execute();
        }
    }

    @Override
    public void undo() {
        super.undo();
        for (int i = this.commands_.length - 1; 0 <= i; --i) {
            this.commands_[i].undo();
        }
    }
}

