/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.db;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.yukinoshita.model.db.FileIndex;
import org.unitarou.yukinoshita.model.db.GameIndex;
import org.unitarou.yukinoshita.model.db.Master;
import org.unitarou.yukinoshita.model.db.Term;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchedFile {
    private final FileIndex fileIndex_ = new FileIndex();
    private final GameIndex gameIndex_ = new GameIndex();
    private final Master master_ = new Master();
    private List<Term> terms_ = null;
    private int similarity_ = Integer.MIN_VALUE;

    public void set(SearchedFile searchedFile) {
        ArgumentChecker.throwIfNull((Object)searchedFile);
        this.fileIndex_.setFileId(searchedFile.fileIndex_.getFileId());
        this.fileIndex_.setPath(searchedFile.fileIndex_.getPath());
        this.fileIndex_.setDigest(searchedFile.fileIndex_.getDigest());
        this.gameIndex_.setFileId(searchedFile.gameIndex_.getFileId());
        this.gameIndex_.setFileOrder(searchedFile.gameIndex_.getFileOrder());
        this.gameIndex_.setDate(searchedFile.gameIndex_.getDate());
        this.gameIndex_.setGameType(searchedFile.gameIndex_.getGameType());
        this.gameIndex_.setMasterId(searchedFile.gameIndex_.getMasterId());
        this.gameIndex_.setMove(searchedFile.gameIndex_.getMove());
        this.master_.setMasterId(searchedFile.master_.getMasterId());
        this.master_.setFingerprint(searchedFile.master_.getFingerprint());
        this.master_.setGameType(searchedFile.master_.getGameType());
        this.master_.setHeight(searchedFile.master_.getHeight());
        this.master_.setWidth(searchedFile.master_.getWidth());
        this.terms_ = searchedFile.terms_ == null ? null : new ArrayList<Term>(searchedFile.terms_);
        this.similarity_ = searchedFile.similarity_;
    }

    public int getFileId() {
        return this.fileIndex_.getFileId();
    }

    public String getPath() {
        return this.fileIndex_.getPath();
    }

    public byte[] getDigest() {
        return this.fileIndex_.getDigest();
    }

    public void setFileId(int n) {
        this.fileIndex_.setFileId(n);
    }

    public void setPath(String string) {
        this.fileIndex_.setPath(string);
    }

    public void setDigest(byte[] byArray) {
        this.fileIndex_.setDigest(byArray);
    }

    public GameIndex getGameIndex() {
        GameIndex gameIndex = new GameIndex();
        gameIndex.setFileId(this.getFileId());
        gameIndex.setFileOrder(this.getFileOrder());
        gameIndex.setGameType(this.getGameType());
        gameIndex.setMasterId(this.getMasterId());
        gameIndex.setMove(this.getMove());
        gameIndex.setDate(this.getDate());
        return gameIndex;
    }

    public int getGameType() {
        return this.gameIndex_.getGameType();
    }

    public int getFileOrder() {
        return this.gameIndex_.getFileOrder();
    }

    public String getDate() {
        return this.gameIndex_.getDate();
    }

    public int getMove() {
        return this.gameIndex_.getMove();
    }

    public void setGameType(int n) {
        this.gameIndex_.setGameType(n);
    }

    public void setFileOrder(int n) {
        this.gameIndex_.setFileOrder(n);
    }

    public void setDate(String string) {
        this.gameIndex_.setDate(string);
    }

    public void setMove(int n) {
        this.gameIndex_.setMove(n);
    }

    public int getMasterId() {
        return this.master_.getMasterId();
    }

    public int getWidth() {
        return this.master_.getWidth();
    }

    public int getHeight() {
        return this.master_.getHeight();
    }

    public byte[] getFingerprint() {
        return this.master_.getFingerprint();
    }

    public void setMasterId(int n) {
        this.master_.setMasterId(n);
    }

    public void setWidth(int n) {
        this.master_.setWidth(n);
    }

    public void setHeight(int n) {
        this.master_.setHeight(n);
    }

    public void setFingerprint(byte[] byArray) {
        this.master_.setFingerprint(byArray);
    }

    public List<Term> getTerm() {
        if (this.terms_ == null) {
            return null;
        }
        return Collections.unmodifiableList(this.terms_);
    }

    public void setTerm(List<Term> list) {
        ArgumentChecker.throwIfNull(list);
        if (this.terms_ == null) {
            this.terms_ = new ArrayList<Term>();
        }
        this.terms_.clear();
        this.terms_.addAll(list);
    }

    public int getSimilarity() {
        return this.similarity_;
    }

    public void setSimilarity(int n) {
        this.similarity_ = n;
    }
}

