/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.io.CollectionRepository;
import org.unitarou.sgf.type.GameType;
import org.unitarou.util.Adaptable;
import org.unitarou.util.Provider;
import org.unitarou.util.StopWatch;
import org.unitarou.yukinoshita.Application;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.ContextListener;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.events.ActionListener;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.EventBrokerImpl;
import org.unitarou.yukinoshita.model.CollectionEditor;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.Command4NodeList;
import org.unitarou.yukinoshita.model.cmd.ModelInfluence;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.ModelFrame;
import org.unitarou.yukinoshita.view.ViewerUtils;
import org.unitarou.yukinoshita.view.cmd.Command4View;
import org.unitarou.yukinoshita.view.cmd.WrapperCommand;
import org.unitarou.yukinoshita.view.monitor.CollectionMonitor;
import org.unitarou.yukinoshita.view.monitor.ContextMonitor;
import org.unitarou.yukinoshita.view.monitor.GameInfoNodeMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameFrameController
implements Adaptable {
    private static final Log log_s_ = LogFactory.getLog(GameFrameController.class);
    private final CollectionEditor collectionEditor_;
    private final ListenerAdapter listenerAdapter_;
    private final ModelFrame modelFrame_;
    private final EventBrokerImpl eventBrokerImpl_;
    private boolean isEditMode_;
    private final List<Integer> indexFilter_;

    public GameFrameController(Collection collection, ModelFrame modelFrame, boolean bl, int n) {
        this(collection, modelFrame, bl, n, false);
    }

    public GameFrameController(Collection collection, ModelFrame modelFrame, boolean bl, int n, boolean bl2) {
        ArgumentChecker.throwIfNull((Object)collection, (Object)modelFrame);
        if (collection.size() == 0) {
            throw new IllegalArgumentException("collection must have one or more games.");
        }
        this.collectionEditor_ = new CollectionEditor(collection, bl);
        this.collectionEditor_.setActiveGame(n);
        this.eventBrokerImpl_ = new EventBrokerImpl();
        this.isEditMode_ = bl2;
        this.modelFrame_ = modelFrame;
        this.modelFrame_.setEventBroker(this.eventBrokerImpl_);
        if (this.collectionEditor_.isDrill()) {
            ViewerUtils.setupDriiRootDirectory(collection);
            CollectionRepository.instance().loadProblem(collection);
            if (1 < collection.size()) {
                this.collectionEditor_.setActiveGame(1);
            }
            this.indexFilter_ = new ArrayList<Integer>(this.collectionEditor_.size());
            for (int i = 1; i < this.collectionEditor_.size(); ++i) {
                this.indexFilter_.add(i);
            }
        } else {
            this.indexFilter_ = new ArrayList<Integer>(this.collectionEditor_.size());
            for (int i = 0; i < this.collectionEditor_.size(); ++i) {
                this.indexFilter_.add(i);
            }
        }
        this.listenerAdapter_ = new ListenerAdapter();
        this.eventBrokerImpl_.addController(this);
        this.eventBrokerImpl_.addView(this);
        this.fireCollectionMonitorUpdate();
        this.fireGameMonitorUpdate();
        this.fireNodeMonitorUpdate();
        Yukinoshita.context().addListener(this.listenerAdapter_);
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.listenerAdapter_.getClass())) {
            return this.listenerAdapter_;
        }
        return null;
    }

    public void dispose() {
        this.collectionEditor_.dispose();
        this.modelFrame_.close();
        this.eventBrokerImpl_.removeController(this);
        this.eventBrokerImpl_.dispose();
    }

    public CollectionEditor getCollectionEditor() {
        return this.collectionEditor_;
    }

    public Collection getCollection() {
        return this.collectionEditor_.getCollection();
    }

    public boolean isChanged() {
        if (this.collectionEditor_.isRgtEdited()) {
            return true;
        }
        boolean[] blArray = this.collectionEditor_.getChangedFlags();
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            return true;
        }
        return false;
    }

    public void clearChangedFlag() {
        this.collectionEditor_.clearChangedFlags();
        this.fireNodeMonitorUpdate();
    }

    public boolean isEditMode() {
        return this.isEditMode_;
    }

    public void updateByRedoUndo(EnumSet<ModelInfluence> enumSet) {
        block8: for (ModelInfluence modelInfluence : enumSet) {
            switch (modelInfluence) {
                case COLLECTION: {
                    this.fireCollectionMonitorUpdate();
                    continue block8;
                }
                case ROOT_GAME_TREE: {
                    this.fireGameMonitorUpdate();
                    continue block8;
                }
                case NODE_PEVIOUS: {
                    this.fireGameMonitorUpdate();
                    continue block8;
                }
                case NODE_DOWNWARD: {
                    this.fireGameMonitorUpdate();
                    continue block8;
                }
                case NODE_CURRENT: {
                    continue block8;
                }
                case NODE_GAMEINFO: {
                    this.fireGameInfoNodeUpdate();
                    continue block8;
                }
            }
            assert (false) : "Unknown type:" + (Object)((Object)modelInfluence);
        }
        this.fireNodeMonitorUpdate();
    }

    public EventBroker getEventBroker() {
        return this.eventBrokerImpl_;
    }

    private void fireCollectionMonitorUpdate() {
        GameType gameType = this.collectionEditor_.getActiveGame().getGameType();
        this.eventBrokerImpl_.connect(gameType, this.isEditMode_);
        for (CollectionMonitor collectionMonitor : this.eventBrokerImpl_.getListeners(CollectionMonitor.class)) {
            collectionMonitor.update(this.collectionEditor_);
        }
    }

    private void fireGameMonitorUpdate() {
        StopWatch stopWatch = new StopWatch();
        ViewerUtils.setupDriiRootDirectory(this.collectionEditor_.getCollection());
        GameMediator gameMediator = this.collectionEditor_.getActiveGame();
        for (GameMonitor gameMonitor : this.eventBrokerImpl_.getListeners(GameMonitor.class)) {
            gameMonitor.update(gameMediator);
            if (!log_s_.isTraceEnabled()) continue;
            log_s_.trace(stopWatch.lapSecond() + " secs for " + gameMonitor);
        }
        if (log_s_.isTraceEnabled()) {
            log_s_.trace(stopWatch.stopSecond() + " secs for fireGameViewerUpdate");
        }
    }

    private void fireNodeMonitorUpdate() {
        StopWatch stopWatch = new StopWatch();
        NodeView nodeView = this.collectionEditor_.getActiveGame().getCurrentNodeView();
        for (NodeMonitor nodeMonitor : this.eventBrokerImpl_.getListeners(NodeMonitor.class)) {
            nodeMonitor.currentChanged(nodeView);
            if (!log_s_.isTraceEnabled()) continue;
            log_s_.trace(stopWatch.lapSecond() + " secs for " + nodeMonitor);
        }
        if (log_s_.isTraceEnabled()) {
            log_s_.trace(stopWatch.stopSecond() + " secs for fireNodeViewerUpdate");
        }
    }

    private void fireGameInfoNodeUpdate() {
        GameMediator gameMediator = this.collectionEditor_.getActiveGame();
        int n = gameMediator.findNodeView(PropertyType.GAME_INFO);
        if (n < 0) {
            n = 0;
        }
        NodeView nodeView = gameMediator.getNodeList().getNodeView(n);
        for (GameInfoNodeMonitor gameInfoNodeMonitor : this.eventBrokerImpl_.getListeners(GameInfoNodeMonitor.class)) {
            gameInfoNodeMonitor.gameInfoChanged(nodeView);
        }
    }

    private void fireContextAttributeChanged(Set<String> set) {
        for (ContextMonitor contextMonitor : this.eventBrokerImpl_.getListeners(ContextMonitor.class)) {
            contextMonitor.attributeChanged(set);
        }
    }

    public <T extends Provider> void changeProvider(Class<T> clazz, Provider provider) {
        ArgumentChecker.throwIfNull(clazz, (Object)provider);
        GameMediator gameMediator = this.collectionEditor_.getActiveGame();
        CurrentContext currentContext = gameMediator.getContext();
        currentContext.setProvider(clazz, provider);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(clazz.getName());
        Set<String> set = Collections.unmodifiableSet(hashSet);
        this.fireContextAttributeChanged(set);
    }

    public <T extends Provider> T getProvider(Class<T> clazz) {
        ArgumentChecker.throwIfNull(clazz);
        GameMediator gameMediator = this.collectionEditor_.getActiveGame();
        CurrentContext currentContext = gameMediator.getContext();
        return currentContext.getProvider(clazz);
    }

    public List<Integer> getIndexFilter() {
        return Collections.unmodifiableList(this.indexFilter_);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListenerAdapter
    implements ActionListener,
    ContextListener,
    CollectionMonitor {
        private HandlerPhase currentStatus_ = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void executeCommand(Command4NodeList command4NodeList) {
            ArgumentChecker.throwIfNull((Object)command4NodeList);
            WrapperCommand wrapperCommand = new WrapperCommand(command4NodeList);
            wrapperCommand.getParameter().set(GameFrameController.this.collectionEditor_, GameFrameController.this.eventBrokerImpl_, GameFrameController.this.isEditMode_);
            Application application = Yukinoshita.application();
            try {
                application.setCursorType(Application.CursorType.WAIT);
                wrapperCommand.execute();
            }
            finally {
                application.setCursorType(Application.CursorType.NONE);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void executeCommand(Command4View command4View) {
            ArgumentChecker.throwIfNull((Object)command4View);
            Command4View.Parameter parameter = command4View.getParameter();
            parameter.setCollectionEditor(GameFrameController.this.collectionEditor_);
            parameter.setEventBroker(GameFrameController.this.eventBrokerImpl_);
            if (parameter.isEditMode() == null) {
                parameter.setEditMode(GameFrameController.this.isEditMode_);
            } else {
                GameFrameController.this.isEditMode_ = parameter.isEditMode();
            }
            if (parameter.getCurrentStatus() == null && this.currentStatus_ != null) {
                parameter.setCurrentStatus(this.currentStatus_);
            }
            parameter.setIndexFilter(GameFrameController.this.indexFilter_);
            Application application = Yukinoshita.application();
            try {
                application.setCursorType(Application.CursorType.WAIT);
                command4View.execute();
            }
            finally {
                application.setCursorType(Application.CursorType.NONE);
            }
            this.currentStatus_ = parameter.getCurrentStatus();
        }

        @Override
        public void attributeChanged(Set<String> set) {
            ArgumentChecker.throwIfNull(set);
            GameFrameController.this.fireContextAttributeChanged(set);
        }

        @Override
        public void update(CollectionEditor collectionEditor) {
            ArgumentChecker.throwIfNull((Object)collectionEditor);
            GameFrameController.this.indexFilter_.clear();
            for (int i = 0; i < collectionEditor.size(); ++i) {
                GameFrameController.this.indexFilter_.add(i);
            }
        }

        @Override
        public void changeIndexFilter(List<Integer> list) {
            ArgumentChecker.throwIfNull(list);
            GameFrameController.this.indexFilter_.clear();
            GameFrameController.this.indexFilter_.addAll(list);
        }
    }
}

