/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.ISafeRunnableRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.window.WindowManager;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.ml.BasicMessages;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Collection;
import org.unitarou.util.TaskMonitor;
import org.unitarou.util.TaskRunnable;
import org.unitarou.yukinoshita.Application;
import org.unitarou.yukinoshita.FileManager;
import org.unitarou.yukinoshita.context.Context;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.jface.JFaceContext;
import org.unitarou.yukinoshita.view.jface.JFaceWindow;
import org.unitarou.yukinoshita.view.jface.board.bp.BoardPainter;
import org.unitarou.yukinoshita.view.jface.board.sp.StonePainter;
import org.unitarou.yukinoshita.view.jface.provider.abp.EnglishAsciiBoradProvider;
import org.unitarou.yukinoshita.view.monitor.MouseWheelMonitor;

public class JFaceApplication
implements Application {
    private static final Log log_s_ = LogFactory.getLog(JFaceApplication.class);
    private static final Message MSG_SYSTEM_ERROR = new Message(JFaceApplication.class, "msgSystemError");
    private static final Message MSG_FATAL_SYSTEM_ERROR = new Message(JFaceApplication.class, "msgFatalSystemError");
    private Application.Status status_ = Application.Status.INITIALIZING;
    private final WindowManager windowManager_;
    private final JFaceContext context_;
    private final Display display_ = new Display();
    private final Shell shell_;
    private int windowCount_;

    public JFaceApplication() {
        this.windowManager_ = new WindowManager();
        this.context_ = new JFaceContext();
        this.context_.registerInterface(BoardPainter.class);
        this.context_.registerInterface(StonePainter.class);
        ExceptionHandler exceptionHandler = new ExceptionHandler();
        Window.setExceptionHandler(exceptionHandler);
        SafeRunnable.setRunner(exceptionHandler);
        this.shell_ = new Shell(this.display_);
        this.windowCount_ = 0;
    }

    public Application.Status status() {
        return this.status_;
    }

    public void close() {
        this.context_.save();
        this.display_.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(File[] fileArray) {
        try {
            this.context_.registerProvider(BoardPainter.CONTEXT.defaultValue().getClass());
            this.context_.registerProvider(StonePainter.CONTEXT.defaultValue().getClass());
            this.context_.registerProvider(EnglishAsciiBoradProvider.class);
            this.display_.addFilter(37, new MouseWheelListener());
            this.createWindow();
            JFaceWindow jFaceWindow = (JFaceWindow)this.windowManager_.getWindows()[0];
            this.registerFilesToWindow(fileArray, jFaceWindow);
            this.startMainRoop();
        }
        catch (Throwable throwable) {
            log_s_.error("Fatal internal error occurred.", throwable);
            MessageDialog messageDialog = new MessageDialog(Display.getCurrent().getActiveShell(), BasicMessages.NT_ERROR.get(), null, MSG_FATAL_SYSTEM_ERROR.get(), 1, new String[]{BasicMessages.CLB_CLOSE.get()}, 0);
            messageDialog.open();
            this.windowManager_.close();
        }
        finally {
            this.status_ = Application.Status.TERMINATED;
        }
    }

    private void registerFilesToWindow(File[] fileArray, JFaceWindow jFaceWindow) {
        for (File file : fileArray) {
            Collection collection = FileManager.instance().open(file);
            if (collection == null) continue;
            FileManager.instance().insertFileHistory(file);
            jFaceWindow.register(collection, "", false, 0);
        }
    }

    private void startMainRoop() {
        this.status_ = Application.Status.RUNNING;
        while (!this.shell_.isDisposed()) {
            if (!this.display_.readAndDispatch()) {
                this.display_.sleep();
            }
            if (this.windowManager_.getWindowCount() != 0) continue;
            this.shell_.dispose();
        }
    }

    public void createWindow() {
        ++this.windowCount_;
        JFaceWindow jFaceWindow = new JFaceWindow(null, this.windowCount_);
        this.windowManager_.add(jFaceWindow);
        jFaceWindow.setBlockOnOpen(false);
        jFaceWindow.open();
    }

    public void closeAllWindows() {
        this.display_.syncExec(new Runnable(){

            public void run() {
                JFaceApplication.this.windowManager_.close();
            }
        });
    }

    public Context getContext() {
        return this.context_;
    }

    public boolean openMessageDialog(Application.MessageLevel messageLevel, String string, String string2) {
        ArgumentChecker.throwIfNull((Object)messageLevel, (Object)string, (Object)string2);
        Display display = Display.getCurrent();
        Shell shell = display != null ? display.getActiveShell() : new Shell();
        switch (messageLevel) {
            case ERROR: {
                MessageDialog.openError(shell, string, string2);
                break;
            }
            case WARNING: {
                MessageDialog.openWarning(shell, string, string2);
                break;
            }
            case INFORMATION: {
                MessageDialog.openInformation(shell, string, string2);
                break;
            }
            case QUESTION: {
                return MessageDialog.openQuestion(shell, string, string2);
            }
            case CONFIRM: {
                return MessageDialog.openConfirm(shell, string, string2);
            }
            default: {
                assert (false) : "Unknown type:" + (Object)((Object)messageLevel);
                break;
            }
        }
        return true;
    }

    public File openDirectoryDialog(String string, String string2, File file) {
        ArgumentChecker.throwIfNull((Object)string, (Object)string2, (Object)file);
        DirectoryDialog directoryDialog = new DirectoryDialog(Display.getCurrent().getActiveShell());
        directoryDialog.setText(string);
        directoryDialog.setMessage(string2);
        String string3 = file.isDirectory() ? file.getAbsolutePath() : file.getParentFile().getAbsolutePath();
        directoryDialog.setFilterPath(string3);
        string3 = directoryDialog.open();
        return string3 == null ? null : new File(string3);
    }

    public WindowController[] getAllController() {
        Window[] windowArray = this.windowManager_.getWindows();
        ArrayList<WindowController> arrayList = new ArrayList<WindowController>(windowArray.length - 1);
        for (Window window : windowArray) {
            if (!(window instanceof WindowController)) continue;
            arrayList.add((WindowController)((Object)window));
        }
        return arrayList.toArray(new WindowController[arrayList.size()]);
    }

    public void setCursorType(Application.CursorType cursorType) {
        Shell shell = this.display_.getActiveShell();
        if (shell == null) {
            return;
        }
        Cursor cursor = null;
        switch (cursorType) {
            case NONE: {
                break;
            }
            case WAIT: {
                cursor = this.display_.getSystemCursor(1);
            }
        }
        shell.setCursor(cursor);
    }

    public boolean exec(String string, final TaskRunnable taskRunnable, boolean bl, boolean bl2) {
        ArgumentChecker.throwIfNull((Object)string, (Object)taskRunnable);
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                taskRunnable.setTaskMonitor(new TaskMonitorImpl(iProgressMonitor));
                taskRunnable.run();
            }
        };
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(null);
        progressMonitorDialog.create();
        progressMonitorDialog.getShell().setText(string);
        try {
            progressMonitorDialog.run(bl, bl2, iRunnableWithProgress);
            progressMonitorDialog.close();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return false;
    }

    private static class TaskMonitorImpl
    implements TaskMonitor {
        private final IProgressMonitor monitor_;
        private String taskName_;

        private TaskMonitorImpl(IProgressMonitor iProgressMonitor) {
            this.monitor_ = iProgressMonitor;
            this.taskName_ = "";
        }

        public void start(int n, String string) {
            this.taskName_ = string;
            this.monitor_.setTaskName(this.taskName_);
        }

        public void subTaskStated(int n, String string, int n2) {
            ArgumentChecker.throwIfNull((Object)string);
            this.monitor_.beginTask(this.taskName_, n2);
            this.monitor_.subTask(string);
        }

        public void subTaskWorked(int n, int n2, String string) {
            this.monitor_.worked(n2);
            if (string != null) {
                this.monitor_.subTask(string);
            }
        }

        public void subTaskFinished(int n) {
            this.monitor_.subTask("");
        }

        public void finished() {
            this.monitor_.done();
        }

        public void abort(int n, Exception exception) {
            log_s_.error("Failure in subtask " + n, exception);
        }

        public boolean isCanceled() {
            return this.monitor_.isCanceled();
        }
    }

    private static class ExceptionHandler
    implements Window.IExceptionHandler,
    ISafeRunnableRunner {
        private ExceptionHandler() {
        }

        public void handleException(Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            log_s_.error("SWT internal error occurred.", throwable);
            MessageDialog messageDialog = new MessageDialog(Display.getCurrent().getActiveShell(), BasicMessages.NT_ERROR.get(), null, MSG_SYSTEM_ERROR.get(), 1, new String[]{BasicMessages.CLB_CLOSE.get()}, 0);
            messageDialog.open();
        }

        public void run(ISafeRunnable iSafeRunnable) {
            try {
                iSafeRunnable.run();
            }
            catch (Exception exception) {
                this.handleException(iSafeRunnable, exception);
            }
            catch (LinkageError linkageError) {
                this.handleException(iSafeRunnable, linkageError);
            }
        }

        private void handleException(ISafeRunnable iSafeRunnable, Throwable throwable) {
            log_s_.warn(iSafeRunnable);
            this.handleException(throwable);
        }
    }

    private class MouseWheelListener
    implements Listener {
        private int lastTime = 0;

        private MouseWheelListener() {
        }

        public void handleEvent(Event event) {
            if (this.lastTime == event.time || !(event.widget instanceof Control)) {
                return;
            }
            JFaceWindow jFaceWindow = this.findFocusWindow();
            if (jFaceWindow == null) {
                return;
            }
            this.lastTime = event.time;
            GameFrameController gameFrameController = jFaceWindow.getActive();
            int n = -event.count / 3;
            if (gameFrameController == null || n == 0) {
                return;
            }
            Control control = (Control)event.widget;
            Point point = control.toDisplay(event.x, event.y);
            EventBroker eventBroker = gameFrameController.getEventBroker();
            for (MouseWheelMonitor mouseWheelMonitor : eventBroker.getListeners(MouseWheelMonitor.class)) {
                if (mouseWheelMonitor.mouseWheelRolled(point, n)) break;
            }
        }

        private JFaceWindow findFocusWindow() {
            Shell shell = JFaceApplication.this.display_.getActiveShell();
            for (Window window : JFaceApplication.this.windowManager_.getWindows()) {
                if (window.getShell() != shell) continue;
                return (JFaceWindow)window;
            }
            return null;
        }
    }
}

