/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.sgf.type.GameType;
import org.unitarou.yukinoshita.model.CollectionEditor;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.jface.act.AbstractRootGameTreeAction;

public class UpRootGameTreeAction
extends AbstractRootGameTreeAction {
    private static final Log log_s_ = LogFactory.getLog(UpRootGameTreeAction.class);

    public UpRootGameTreeAction(WindowController windowController) {
        super(windowController);
    }

    public void run() {
        GameFrameController gameFrameController = this.controller_.getActive();
        CollectionEditor collectionEditor = gameFrameController.getCollectionEditor();
        int n = collectionEditor.getActiveGameIndex();
        if (n == 0) {
            log_s_.warn("Can't swap because of zero index, ignore this action.");
            return;
        }
        collectionEditor.swap(n, n - 1);
        collectionEditor.setActiveGame(n - 1);
        this.notifyCollectionViewer(gameFrameController);
    }

    protected boolean isRunnable(GameFrameController gameFrameController) {
        if (gameFrameController == null || !gameFrameController.isEditMode()) {
            return false;
        }
        CollectionEditor collectionEditor = gameFrameController.getCollectionEditor();
        if (collectionEditor.size() == 1 || collectionEditor.getActiveGameIndex() == 0) {
            return false;
        }
        return !GameType.DRILL.equals(collectionEditor.getCollection().get(0).getGameType());
    }
}

