/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.ann;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Strings;
import org.unitarou.lang.UEnum;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.FileFormat;
import org.unitarou.sgf.type.GameMode;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.type.Style;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.swt.ComboStyle;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.Context;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.EventBrokerMonitor;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.jface.ann.AnnotationPanel;
import org.unitarou.yukinoshita.view.jface.ann.CharsetEditor;
import org.unitarou.yukinoshita.view.jface.ann.EnumEditor;
import org.unitarou.yukinoshita.view.jface.ann.SizeEditor;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootAnnotationPanel
extends AnnotationPanel {
    private static final Message CLB_EDIT_ADVANCED_TYPE = new Message(RootAnnotationPanel.class, "clbEditAdvancedType");
    private Composite frame_ = null;
    private Button chAdvancedEditMode_ = null;
    private Text txApplication_ = null;
    private final CharsetEditor charsetEditor_;
    private final Map<SgfId, EnumEditor<?>> enumEditorMap_;
    private final SizeEditor sizeEditor_;
    private GameMediator gameMediator_ = null;
    private final Adapter adapter_;
    private boolean isEditMode_ = false;
    private final ComboFocusLost comboFocusLost_;
    private final TextListener textListener_;
    private final ModifyListened modifyListened_;
    private EventBroker eventBroker_ = EventBroker.NULL_BROKER;

    public RootAnnotationPanel() {
        this.charsetEditor_ = new CharsetEditor();
        this.enumEditorMap_ = new HashMap();
        this.sizeEditor_ = new SizeEditor();
        this.adapter_ = new Adapter();
        this.comboFocusLost_ = new ComboFocusLost();
        this.textListener_ = new TextListener();
        this.modifyListened_ = new ModifyListened();
    }

    @Override
    protected EventBroker getEventBroker() {
        return this.eventBroker_;
    }

    @Override
    public void close() {
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public Control createContents(Composite composite) {
        this.frame_ = new Composite(composite, 0);
        this.frame_.setLayout(new GridLayout(2, false));
        this.createCbEditAdvancedType(this.frame_);
        this.createApplicationEdit(this.frame_);
        this.createCharset(this.frame_);
        this.createEnumCombo(this.frame_, SgfId.FILE_FORMAT, EnumSet.allOf(FileFormat.class));
        this.createUEnumCombo(this.frame_, SgfId.GAME_MODE, GameMode.class);
        this.createEnumCombo(this.frame_, SgfId.GAME_TYPE, EnumSet.allOf(GameType.class));
        this.createUEnumCombo(this.frame_, SgfId.STYLE, Style.class);
        this.createSizeEditor(this.frame_);
        this.adapter_.setEditMode(this.isEditMode_);
        this.frame_.pack();
        this.updateImpl();
        return this.frame_;
    }

    private void createCbEditAdvancedType(Composite composite) {
        this.chAdvancedEditMode_ = new Button(composite, 0x800020);
        this.chAdvancedEditMode_.setSelection(false);
        this.chAdvancedEditMode_.setText(CLB_EDIT_ADVANCED_TYPE.get());
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.chAdvancedEditMode_.setLayoutData(gridData);
        this.chAdvancedEditMode_.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RootAnnotationPanel.this.setEnableAdvanced(((Button)selectionEvent.widget).getSelection());
            }
        });
    }

    private void setEnableAdvanced(boolean bl) {
        this.txApplication_.setEditable(bl && this.isEditMode_);
        this.enumEditorMap_.get(SgfId.FILE_FORMAT).getControl().setEnabled(bl && this.isEditMode_);
        this.enumEditorMap_.get(SgfId.GAME_MODE).getControl().setEnabled(bl && this.isEditMode_);
        this.sizeEditor_.setAdvanced(bl);
    }

    private void createApplicationEdit(Composite composite) {
        this.createLabel(composite, SgfId.APPLICATION);
        this.txApplication_ = new Text(composite, 2052);
        this.txApplication_.setLayoutData(new GridData(768));
        this.txApplication_.addFocusListener(this.textListener_);
        this.txApplication_.addModifyListener(this.textListener_);
        this.txApplication_.setData(SgfId.APPLICATION);
    }

    private void createCharset(Composite composite) {
        this.createLabel(composite, SgfId.CHARSET);
        this.charsetEditor_.createContents(composite);
        this.charsetEditor_.addModifyListener(this.modifyListened_);
    }

    private <T extends UEnum> Combo createUEnumCombo(Composite composite, SgfId sgfId, Class<T> clazz) {
        this.createLabel(composite, sgfId);
        EnumEditor<T> enumEditor = EnumEditor.createUEnum(clazz, EnumSet.of(ComboStyle.PERMIT_NO_CHOICE));
        Combo combo = enumEditor.createContents(composite);
        combo.setLayoutData(new GridData(768));
        combo.addFocusListener(this.comboFocusLost_);
        combo.setData(sgfId);
        this.enumEditorMap_.put(sgfId, enumEditor);
        return combo;
    }

    private <T extends Enum<T>> Combo createEnumCombo(Composite composite, SgfId sgfId, EnumSet<T> enumSet) {
        this.createLabel(composite, sgfId);
        EnumEditor<T> enumEditor = EnumEditor.createSgfEnum(EnumSet.of(ComboStyle.PERMIT_NO_CHOICE), enumSet);
        Combo combo = enumEditor.createContents(composite);
        combo.setLayoutData(new GridData(768));
        combo.addFocusListener(this.comboFocusLost_);
        combo.setData(sgfId);
        this.enumEditorMap_.put(sgfId, enumEditor);
        return combo;
    }

    private void createSizeEditor(Composite composite) {
        this.createLabel(composite, SgfId.SIZE);
        GridData gridData = new GridData(768);
        Control control = this.sizeEditor_.createContents(composite);
        this.sizeEditor_.addModifyListener(this.modifyListened_);
        control.setLayoutData(gridData);
    }

    private Label createLabel(Composite composite, SgfId sgfId) {
        Label label = new Label(composite, 131072);
        label.setText(sgfId.displayName());
        label.setLayoutData(new GridData(3, 2, false, false));
        return label;
    }

    @Override
    public Control getControl() {
        return this.frame_;
    }

    private NodeView getRootNodeView() {
        if (this.gameMediator_ == null) {
            throw new IllegalStateException();
        }
        return this.gameMediator_.getNodeList().getNodeView(0);
    }

    private void updateImpl() {
        if (this.frame_ == null) {
            return;
        }
        this.setModelUpdateMode(true);
        NodeView nodeView = this.getRootNodeView();
        Property property = nodeView.getProperty(SgfId.APPLICATION);
        this.txApplication_.setText(property != null ? property.getString() : "");
        property = nodeView.getProperty(SgfId.CHARSET);
        this.charsetEditor_.setDatum(property != null ? property.getString() : "");
        for (Map.Entry<SgfId, EnumEditor<?>> entry : this.enumEditorMap_.entrySet()) {
            Property property2 = nodeView.getProperty(entry.getKey());
            if (property2 == null) {
                entry.getValue().select(null);
                continue;
            }
            entry.getValue().setText(property2.getString());
        }
        property = nodeView.getProperty(SgfId.SIZE);
        Object object = SgfSize.DEFAULT;
        if (property != null) {
            try {
                object = SgfSize.parse(property.getString());
            }
            catch (TypeParseException typeParseException) {
                typeParseException.printStackTrace();
            }
        }
        this.sizeEditor_.select((SgfSize)object);
        this.setModelUpdateMode(false);
    }

    private class ModifyListened
    implements ModifyListener {
        private ModifyListened() {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            SgfId sgfId = (SgfId)modifyEvent.widget.getData();
            String string = null;
            if (SgfId.CHARSET.equals(sgfId)) {
                string = RootAnnotationPanel.this.charsetEditor_.getString();
            } else if (SgfId.SIZE.equals(sgfId)) {
                string = RootAnnotationPanel.this.sizeEditor_.getString();
            } else {
                return;
            }
            RootAnnotationPanel.this.updateProperty(string, sgfId, RootAnnotationPanel.this.getRootNodeView());
        }
    }

    private class TextListener
    extends FocusAdapter
    implements ModifyListener {
        private final Map<Text, String> lastStringMap_ = new HashMap<Text, String>();

        private TextListener() {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            String string;
            int n;
            Text text = (Text)modifyEvent.widget;
            String string2 = this.lastStringMap_.get(text);
            if (string2 == null) {
                string2 = "";
            }
            if ((n = Yukinoshita.context(null).getInteger(Context.CHAR_LENGTH_PER_UPDATE)) <= Strings.calcDiffSize(string2, string = text.getText())) {
                this.update(text);
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            this.update((Text)focusEvent.widget);
        }

        private void update(Text text) {
            if (!RootAnnotationPanel.this.isEditMode_) {
                return;
            }
            String string = text.getText();
            SgfId sgfId = (SgfId)text.getData();
            RootAnnotationPanel.this.updateProperty(string, sgfId, RootAnnotationPanel.this.getRootNodeView());
            this.lastStringMap_.put(text, string);
        }
    }

    private class ComboFocusLost
    extends FocusAdapter {
        private ComboFocusLost() {
        }

        public void focusLost(FocusEvent focusEvent) {
            if (!RootAnnotationPanel.this.isEditMode_) {
                return;
            }
            SgfId sgfId = (SgfId)focusEvent.widget.getData();
            EnumEditor enumEditor = (EnumEditor)RootAnnotationPanel.this.enumEditorMap_.get(sgfId);
            String string = enumEditor.getString();
            RootAnnotationPanel.this.updateProperty(string, sgfId, RootAnnotationPanel.this.getRootNodeView());
        }
    }

    private class Adapter
    implements GameMonitor,
    NodeMonitor,
    ControllerStatusMonitor,
    EventBrokerMonitor {
        private Adapter() {
        }

        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull((Object)eventBroker);
            RootAnnotationPanel.this.eventBroker_.removeView(RootAnnotationPanel.this);
            RootAnnotationPanel.this.eventBroker_.removeView(RootAnnotationPanel.this.charsetEditor_);
            RootAnnotationPanel.this.eventBroker_ = eventBroker;
            RootAnnotationPanel.this.eventBroker_.addView(RootAnnotationPanel.this);
            RootAnnotationPanel.this.eventBroker_.addView(RootAnnotationPanel.this.charsetEditor_);
        }

        public void update(GameMediator gameMediator) {
            ArgumentChecker.throwIfNull((Object)gameMediator);
            RootAnnotationPanel.this.gameMediator_ = gameMediator;
            RootAnnotationPanel.this.updateImpl();
        }

        public void currentChanged(NodeView nodeView) {
            ArgumentChecker.throwIfNull((Object)nodeView);
            RootAnnotationPanel.this.updateImpl();
        }

        public void setEditMode(boolean bl) {
            RootAnnotationPanel.this.isEditMode_ = bl;
            if (RootAnnotationPanel.this.frame_ == null) {
                return;
            }
            RootAnnotationPanel.this.txApplication_.setEditable(bl);
            RootAnnotationPanel.this.charsetEditor_.setEditable(bl);
            for (EnumEditor enumEditor : RootAnnotationPanel.this.enumEditorMap_.values()) {
                enumEditor.getControl().setEnabled(bl);
            }
            RootAnnotationPanel.this.sizeEditor_.setEditable(bl);
            RootAnnotationPanel.this.setEnableAdvanced(RootAnnotationPanel.this.chAdvancedEditMode_.getSelection());
        }

        public void changeHandlerPhase(HandlerPhase handlerPhase) {
        }
    }
}

