/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.db;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.unitarou.ml.Message;
import org.unitarou.sgf.type.GameType;
import org.unitarou.swt.USashForm;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.yukinoshita.model.db.SearchedFile;
import org.unitarou.yukinoshita.view.jface.db.DatabaseStatusPanel;
import org.unitarou.yukinoshita.view.jface.db.Dataset;
import org.unitarou.yukinoshita.view.jface.db.FilterPanel;
import org.unitarou.yukinoshita.view.jface.db.GameTypeDataset;
import org.unitarou.yukinoshita.view.jface.util.SwtFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordFinderPanel
implements WidgetContainer {
    private static final Message CLB_TABLE = new Message(RecordFinderPanel.class, "clbTable");
    private static final Message CLB_THUMBNAIL = new Message(RecordFinderPanel.class, "clbThumbnail");
    private final List<Dataset> datasets_ = new ArrayList<Dataset>();
    private int idxDatasetSelected_;
    private Composite frame_;
    private USashForm resultForm_;
    private final DatabaseStatusPanel databaseStatusPanel_;
    private Button btTable_;
    private Button btThumbnail_;
    private final StackLayout filterStackLayout_;
    private final StackLayout searchedFileStackLayout_;
    private final List<WidgetContainer> searchResultPanels_;

    public RecordFinderPanel() {
        this.datasets_.add(new GameTypeDataset(GameType.GAME));
        this.datasets_.add(new GameTypeDataset(GameType.PROBLEM));
        this.idxDatasetSelected_ = 0;
        this.databaseStatusPanel_ = new DatabaseStatusPanel();
        this.filterStackLayout_ = new StackLayout();
        this.searchedFileStackLayout_ = new StackLayout();
        this.searchResultPanels_ = new ArrayList<WidgetContainer>();
        for (Dataset dataset : this.datasets_) {
            this.searchResultPanels_.add(dataset.getSearchResultPanel());
        }
    }

    @Override
    public void close() {
    }

    @Override
    public Control getControl() {
        return this.frame_;
    }

    @Override
    public Control createContents(Composite composite) {
        USashForm uSashForm = SwtFactory.createUSashForm(composite, 256);
        uSashForm.setLayoutData(new GridData(4, 4, true, true));
        this.createDatasetPanel(uSashForm);
        this.resultForm_ = SwtFactory.createUSashForm(uSashForm, 512);
        this.createFilterPanel(this.resultForm_);
        this.createResultPanel(this.resultForm_);
        this.resultForm_.setWeights(new int[]{-200, 1});
        uSashForm.setWeights(new int[]{-150, 1});
        this.frame_ = uSashForm;
        return this.frame_;
    }

    private Control createDatasetPanel(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout(new GridLayout(1, true));
        Control control = this.databaseStatusPanel_.createContents(composite2);
        control.setLayoutData(new GridData(4, 128, true, false));
        final Table table = new Table(composite2, 2560);
        table.setLayoutData(new GridData(4, 4, true, false));
        for (Dataset dataset : this.datasets_) {
            TableItem tableItem = new TableItem(table, 0);
            tableItem.setText(dataset.displayName());
            tableItem.setData(dataset);
        }
        table.select(this.idxDatasetSelected_);
        table.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableItem[] tableItemArray = table.getSelection();
                if (1 != tableItemArray.length) {
                    return;
                }
                RecordFinderPanel.this.idxDatasetSelected_ = table.getSelectionIndex();
                RecordFinderPanel.this.changeDataset();
            }
        });
        this.createViewStylePanel(composite2);
        return composite2;
    }

    private void changeDataset() {
        Control control;
        this.filterStackLayout_.topControl = control = this.datasets_.get(this.idxDatasetSelected_).getFilterPanel().getControl();
        this.changeLayoutStyle();
        control.getParent().layout();
        WidgetContainer widgetContainer = this.searchResultPanels_.get(this.idxDatasetSelected_);
        this.searchedFileStackLayout_.topControl = control = widgetContainer.getControl();
        control.getParent().layout();
    }

    private void createViewStylePanel(Composite composite) {
        this.btTable_ = new Button(composite, 2);
        this.btThumbnail_ = new Button(composite, 2);
        this.btTable_.setText(CLB_TABLE.get());
        this.btTable_.setSelection(true);
        this.btThumbnail_.setText(CLB_THUMBNAIL.get());
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!((Button)selectionEvent.widget).getSelection()) {
                    return;
                }
                if (selectionEvent.widget == RecordFinderPanel.this.btTable_) {
                    RecordFinderPanel.this.btThumbnail_.setSelection(!RecordFinderPanel.this.btTable_.getSelection());
                } else {
                    RecordFinderPanel.this.btTable_.setSelection(!RecordFinderPanel.this.btThumbnail_.getSelection());
                }
                RecordFinderPanel.this.changeLayoutStyle();
            }
        };
        this.btTable_.addSelectionListener(selectionAdapter);
        this.btThumbnail_.addSelectionListener(selectionAdapter);
    }

    private void changeLayoutStyle() {
        Dataset.ViewStyle viewStyle;
        if (this.btTable_.getSelection()) {
            this.resultForm_.setOrientation(512);
            viewStyle = Dataset.ViewStyle.TABLE;
        } else {
            this.resultForm_.setOrientation(256);
            viewStyle = Dataset.ViewStyle.THUMBNAIL;
        }
        this.datasets_.get(this.idxDatasetSelected_).setViewStyle(viewStyle);
    }

    private Control createFilterPanel(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout(this.filterStackLayout_);
        for (Dataset dataset : this.datasets_) {
            FilterPanel filterPanel = dataset.getFilterPanel();
            filterPanel.createContents(composite2);
        }
        this.filterStackLayout_.topControl = this.datasets_.get(0).getFilterPanel().getControl();
        return composite2;
    }

    private Control createResultPanel(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout(this.searchedFileStackLayout_);
        for (WidgetContainer widgetContainer : this.searchResultPanels_) {
            widgetContainer.createContents(composite2);
        }
        this.searchedFileStackLayout_.topControl = this.searchResultPanels_.get(0).getControl();
        return composite2;
    }

    public List<? extends SearchedFile> getSelected() {
        return this.datasets_.get(this.idxDatasetSelected_).getSelected();
    }
}

