/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.dlg;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.unitarou.lang.Exceptions;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.io.dl.HttpDownloadEvent;
import org.unitarou.sgf.io.dl.HttpDownloader;
import org.unitarou.sgf.io.dl.HttpDownloaderException;
import org.unitarou.sgf.io.dl.HttpDownloaderListener;
import org.unitarou.yukinoshita.Application;
import org.unitarou.yukinoshita.Yukinoshita;

public class DownloadDialog
extends TitleAreaDialog {
    private static final Log log_s_ = LogFactory.getLog(DownloadDialog.class);
    private static final Message LB_LOAD_FROM_WEB_SITE = new Message(DownloadDialog.class, "lbLoadFromWebSite");
    private static final Message MSG_SPECIFY_URL_FOR_DOWNLOAD = new Message(DownloadDialog.class, "msgSpecifyUrlForDownload");
    private static final Message NT_TOOL_TIP_SPECIFY_URL = new Message(DownloadDialog.class, "ntToolTipSpecifyUrl");
    private static final Message LB_URL = new Message(DownloadDialog.class, "lbUrl");
    private static final Message LB_FILTER = new Message(DownloadDialog.class, "lbFilter");
    private static final Message LB_AUTO_DETECT = new Message(DownloadDialog.class, "lbAutoDetect");
    private static final Message LB_STATUS = new Message(DownloadDialog.class, "lbStatus");
    private static final Message NT_DOWNLOAD_ERROR = new Message(DownloadDialog.class, "ntDownloadError");
    private static final Message MSG_NO_CONTENTS = new Message(DownloadDialog.class, "msgNoContents");
    private static final Message MSG_NETWORK_ERROR = new Message(DownloadDialog.class, "msgNetworkError");
    private Combo urlCombo_;
    private Button autoDetectButton_;
    private Combo filterCombo_;
    private Label statusLabel_;
    private ProgressBar progressBar_;
    private HttpDownloader[] downloaders_ = new HttpDownloader[0];
    private String url_ = "";
    private Collection collection_ = null;
    private DownloadThread downloadThread_ = null;

    public DownloadDialog(Shell shell) {
        super(shell);
        this.setShellStyle(65584);
    }

    protected void createButtonsForButtonBar(Composite composite) {
        super.createButtonsForButtonBar(composite);
        this.getButton(0).setEnabled(false);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData(new GridData(4, 128, true, false));
        this.createUrlArea(composite3);
        this.createFilterArea(composite3);
        this.createStatusArea(composite3);
        this.setTitle(LB_LOAD_FROM_WEB_SITE.get());
        this.setMessage(MSG_SPECIFY_URL_FOR_DOWNLOAD.get());
        return composite2;
    }

    private void createUrlArea(Composite composite) {
        composite.setLayout(new GridLayout(2, false));
        Label label = new Label(composite, 0);
        label.setText(LB_URL.get());
        label.setLayoutData(new GridData(131072, 1024, false, false));
        this.urlCombo_ = new Combo(composite, 4);
        this.urlCombo_.setLayoutData(new GridData(4, 1024, true, false));
        this.urlCombo_.setToolTipText(NT_TOOL_TIP_SPECIFY_URL.get());
        this.urlCombo_.add("http://");
        this.urlCombo_.select(0);
        this.urlCombo_.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                DownloadDialog.this.updateFilterSelection();
                DownloadDialog.this.checkValidUrl();
            }
        });
    }

    private void updateFilterSelection() {
        if (!this.autoDetectButton_.getSelection()) {
            return;
        }
        this.url_ = this.urlCombo_.getText();
        int n = 0;
        int n2 = this.downloaders_[n].matches(this.url_);
        for (int i = 1; i < this.downloaders_.length; ++i) {
            int n3 = this.downloaders_[i].matches(this.url_);
            if (n2 >= n3) continue;
            n = i;
            n2 = n3;
        }
        this.filterCombo_.select(n);
    }

    private void checkValidUrl() {
        try {
            new URL(this.urlCombo_.getText());
            new URI(this.urlCombo_.getText());
            this.getButton(0).setEnabled(true);
        }
        catch (MalformedURLException malformedURLException) {
            this.getButton(0).setEnabled(false);
        }
        catch (URISyntaxException uRISyntaxException) {
            this.getButton(0).setEnabled(false);
        }
    }

    private void createFilterArea(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(LB_FILTER.get());
        GridData gridData = new GridData(131072, 128, false, false);
        gridData.verticalIndent = 8;
        label.setLayoutData(gridData);
        Group group = new Group(composite, 4);
        group.setLayoutData(new GridData(16384, 128, false, true));
        group.setLayout(new RowLayout(512));
        this.autoDetectButton_ = new Button(group, 32);
        this.autoDetectButton_.setText(LB_AUTO_DETECT.get());
        this.autoDetectButton_.setSelection(true);
        this.autoDetectButton_.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DownloadDialog.this.filterCombo_.setEnabled(!DownloadDialog.this.autoDetectButton_.getSelection());
                DownloadDialog.this.updateFilterSelection();
            }
        });
        this.filterCombo_ = new Combo(group, 12);
        this.filterCombo_.setEnabled(false);
        for (HttpDownloader httpDownloader : this.downloaders_ = (HttpDownloader[])Yukinoshita.context().getProviders(HttpDownloader.class)) {
            this.filterCombo_.add(httpDownloader.displayName());
        }
        this.filterCombo_.select(0);
    }

    private void createStatusArea(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(LB_STATUS.get());
        GridData gridData = new GridData(131072, 128, false, false);
        gridData.verticalIndent = 8;
        label.setLayoutData(gridData);
        Group group = new Group(composite, 4);
        group.setLayoutData(new GridData(4, 128, true, true));
        group.setLayout(new FillLayout(512));
        this.statusLabel_ = new Label(group, 0);
        this.progressBar_ = new ProgressBar(group, 256);
        this.progressBar_.setMinimum(0);
        this.progressBar_.setMaximum(100);
        this.progressBar_.setSelection(0);
    }

    protected void buttonPressed(int n) {
        if (n == 1) {
            this.downloadThread_ = null;
            super.buttonPressed(n);
            return;
        }
        this.url_ = this.urlCombo_.getText();
        this.getButton(0).setEnabled(false);
        this.downloadThread_ = new DownloadThread(this.downloaders_[this.filterCombo_.getSelectionIndex()]);
        this.downloadThread_.start();
    }

    public Collection getCollection() {
        return this.collection_;
    }

    private void syncShowMessageDialog(final Application.MessageLevel messageLevel, final String string, final String string2) {
        if (this.downloadThread_ == null) {
            return;
        }
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                Yukinoshita.application().openMessageDialog(messageLevel, string, string2);
            }
        });
    }

    private void syncStatusLabelUpdate(final String string) {
        if (this.downloadThread_ == null) {
            return;
        }
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                DownloadDialog.this.statusLabel_.setText(string);
            }
        });
    }

    private void syncIncrementProgressBar(final int n) {
        if (this.downloadThread_ == null) {
            return;
        }
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                int n2 = DownloadDialog.this.progressBar_.getSelection();
                n2 = (n2 + n) % DownloadDialog.this.progressBar_.getMaximum();
                DownloadDialog.this.progressBar_.setSelection(n2);
            }
        });
    }

    private void syncButtonPressed(final int n) {
        if (this.downloadThread_ == null) {
            return;
        }
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                DownloadDialog.super.buttonPressed(n);
            }
        });
    }

    private class DownloadThread
    extends Thread {
        private HttpDownloader downloader_;

        private DownloadThread(HttpDownloader httpDownloader) {
            assert (httpDownloader != null);
            this.downloader_ = httpDownloader;
        }

        public void run() {
            this.downloader_.addListener(new HttpDownloaderListener(){

                public void changeStatus(HttpDownloadEvent httpDownloadEvent) {
                    DownloadDialog.this.syncStatusLabelUpdate(httpDownloadEvent.getStatus());
                    DownloadDialog.this.syncIncrementProgressBar(httpDownloadEvent.getDelta());
                }
            });
            try {
                DownloadDialog.this.collection_ = this.downloader_.download(DownloadDialog.this.url_);
                if (DownloadDialog.this.collection_ != null && DownloadDialog.this.collection_.size() != 0) {
                    DownloadDialog.this.syncButtonPressed(0);
                    return;
                }
                DownloadDialog.this.syncShowMessageDialog(Application.MessageLevel.INFORMATION, NT_DOWNLOAD_ERROR.get(), MSG_NO_CONTENTS.get());
            }
            catch (HttpDownloaderException httpDownloaderException) {
                log_s_.info(Exceptions.getRootMessage(httpDownloaderException));
                DownloadDialog.this.syncShowMessageDialog(Application.MessageLevel.WARNING, NT_DOWNLOAD_ERROR.get(), MSG_NETWORK_ERROR.get((Object)Exceptions.getRootMessage(httpDownloaderException)));
            }
        }
    }
}

