/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.gm;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.unitarou.io.Ios;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.type.GameType;
import org.unitarou.util.Adaptable;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.TieredModelEventNotifier;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.jface.YukinoshitaPanel;
import org.unitarou.yukinoshita.view.jface.dr.DrillEditorPanel;
import org.unitarou.yukinoshita.view.jface.ns.NodeSelectorPanel;
import org.unitarou.yukinoshita.view.jface.pa.ProblemActionPanel;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeListControllerPanel
implements YukinoshitaPanel {
    private final Map<String, YukinoshitaPanel> panelMap_;
    private Composite frame_;
    private StackLayout stackLayout4Node_;
    private final NodeSelectorPanel nodeSelectorPanel_ = new NodeSelectorPanel();
    private final ProblemActionPanel problemActionPanel_ = new ProblemActionPanel();
    private final DrillEditorPanel drillEditorPanel_ = new DrillEditorPanel();
    private GameType gameType_;
    private boolean isEditing_;
    private final Adapter adapter_;

    public NodeListControllerPanel() {
        this.panelMap_ = new HashMap<String, YukinoshitaPanel>();
        this.panelMap_.put(this.makeKey(GameType.GAME, false), this.nodeSelectorPanel_);
        this.panelMap_.put(this.makeKey(GameType.GAME, true), this.nodeSelectorPanel_);
        this.panelMap_.put(this.makeKey(GameType.PROBLEM, false), this.problemActionPanel_);
        this.panelMap_.put(this.makeKey(GameType.PROBLEM, true), this.nodeSelectorPanel_);
        this.panelMap_.put(this.makeKey(GameType.DRILL, true), this.drillEditorPanel_);
        this.stackLayout4Node_ = null;
        this.gameType_ = GameType.GAME;
        this.isEditing_ = false;
        this.adapter_ = new Adapter();
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public Control createContents(Composite composite) {
        this.frame_ = new Composite(composite, 0);
        this.stackLayout4Node_ = new StackLayout();
        this.frame_.setLayout(this.stackLayout4Node_);
        this.updateNodePanel();
        return this.frame_;
    }

    @Override
    public Control getControl() {
        return this.frame_;
    }

    @Override
    public void close() {
        Ios.closeQuietly(this.problemActionPanel_);
    }

    private void updateNodePanel() {
        if (this.frame_ == null) {
            return;
        }
        YukinoshitaPanel yukinoshitaPanel = this.panelMap_.get(this.makeKey());
        if (yukinoshitaPanel != null) {
            Control control = yukinoshitaPanel.getControl();
            if (control == null) {
                control = yukinoshitaPanel.createContents(this.frame_);
            }
            this.stackLayout4Node_.topControl = control;
            yukinoshitaPanel.getControl().getParent().layout();
        } else {
            this.stackLayout4Node_.topControl = null;
        }
    }

    private String makeKey(GameType gameType, boolean bl) {
        return gameType + String.valueOf(bl);
    }

    private String makeKey() {
        return this.makeKey(this.gameType_, this.isEditing_);
    }

    private class Adapter
    extends TieredModelEventNotifier
    implements GameMonitor,
    ControllerStatusMonitor {
        private EventBroker eventBroker_ = EventBroker.NULL_BROKER;

        private Adapter() {
        }

        public void update(GameMediator gameMediator) {
            ArgumentChecker.throwIfNull((Object)gameMediator);
            NodeListControllerPanel.this.gameType_ = gameMediator.getGameType();
            NodeListControllerPanel.this.updateNodePanel();
        }

        protected Adaptable[] getAdaptables() {
            return NodeListControllerPanel.this.panelMap_.values().toArray(new Adaptable[NodeListControllerPanel.this.panelMap_.size()]);
        }

        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull((Object)eventBroker);
            this.eventBroker_.removeView(NodeListControllerPanel.this);
            this.eventBroker_ = eventBroker;
            this.eventBroker_.addView(NodeListControllerPanel.this);
            super.setEventBroker(eventBroker);
        }

        public void setEditMode(boolean bl) {
            NodeListControllerPanel.this.isEditing_ = bl;
            NodeListControllerPanel.this.updateNodePanel();
        }

        public void changeHandlerPhase(HandlerPhase handlerPhase) {
        }
    }
}

