/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.ns;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.ForStackTraceException;
import org.unitarou.lang.Objects;
import org.unitarou.sgf.util.provider.crdlp.CoordinatesLabelProvider;
import org.unitarou.swt.Swts;
import org.unitarou.swt.UTable;
import org.unitarou.swt.UTableProvider;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.EventBrokerMonitor;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.NodeList;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.ViewerUtils;
import org.unitarou.yukinoshita.view.cmd.NodeSelectionCommand;
import org.unitarou.yukinoshita.view.jface.YukinoshitaPanel;
import org.unitarou.yukinoshita.view.jface.ns.NodeListLabelProvider;
import org.unitarou.yukinoshita.view.monitor.ContextMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;
import org.unitarou.yukinoshita.view.monitor.MouseWheelMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeListMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeListPanel
implements YukinoshitaPanel {
    private static final Log log_s_ = LogFactory.getLog(NodeListPanel.class);
    private EventBroker eventBroker_ = EventBroker.NULL_BROKER;
    private NodeList nodeList_ = null;
    private UTable<NodeView> tbNodeView_ = new UTable<NodeView>(new TableProvider(), 66308);
    private final NodeListLabelProvider provider_ = new NodeListLabelProvider();
    private final Adapter adapter_ = new Adapter();

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public Table createContents(Composite composite) {
        Table table = this.tbNodeView_.createContents(composite);
        table.setHeaderVisible(false);
        Swts.defeatMouseWheel(table);
        table.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NodeListPanel.this.fireNodeSelected();
            }
        });
        table.addKeyListener(new MouseListener());
        return table;
    }

    @Override
    public void close() {
    }

    @Override
    public Table getControl() {
        return this.tbNodeView_.getControl();
    }

    private void fireNodeSelected() {
        int n = this.tbNodeView_.getControl().getSelectionIndex();
        if (n == -1) {
            return;
        }
        NodeSelectionCommand nodeSelectionCommand = new NodeSelectionCommand(n);
        this.eventBroker_.executeCommand(nodeSelectionCommand);
    }

    private void updateTable() {
        ArrayList<NodeView> arrayList = new ArrayList<NodeView>(this.nodeList_.size());
        for (int i = 0; i < this.nodeList_.size(); ++i) {
            arrayList.add(this.nodeList_.getNodeView(i));
        }
        this.tbNodeView_.clear();
        this.tbNodeView_.addAll(arrayList);
        this.tbNodeView_.packColumns();
    }

    private boolean isUninitializedStatus() {
        if (this.tbNodeView_.getControl() == null) {
            log_s_.warn("Widgets have not been initialized.", new ForStackTraceException());
            return true;
        }
        if (this.nodeList_ == null) {
            log_s_.warn("Model has not been initialized.", new ForStackTraceException());
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Adapter
    implements MouseWheelMonitor,
    GameMonitor,
    NodeListMonitor,
    NodeMonitor,
    EventBrokerMonitor,
    ContextMonitor {
        private CurrentContext context_ = CurrentContext.nullContext;

        private Adapter() {
        }

        @Override
        public boolean mouseWheelRolled(Point point, int n) {
            Table table = NodeListPanel.this.tbNodeView_.getControl();
            if (!Swts.isMouseOn(table)) {
                return false;
            }
            table.getVerticalBar().setThumb(1);
            int n2 = table.getSelectionIndex();
            if (n2 < 0) {
                return true;
            }
            n2 = Objects.preventOberRange(n2 + n, 0, table.getItemCount() - 1);
            if (table.getSelectionIndex() != n2) {
                table.setSelection(n2);
                NodeListPanel.this.fireNodeSelected();
            }
            return true;
        }

        @Override
        public void update(GameMediator gameMediator) {
            ArgumentChecker.throwIfNull((Object)gameMediator);
            this.context_ = gameMediator.getContext();
            NodeList nodeList = gameMediator.getNodeList();
            if (nodeList == NodeListPanel.this.nodeList_ && NodeListPanel.this.tbNodeView_.size() == NodeListPanel.this.nodeList_.size()) {
                ArrayList<NodeView> arrayList = new ArrayList<NodeView>(NodeListPanel.this.nodeList_.size());
                for (int i = 0; i < NodeListPanel.this.nodeList_.size(); ++i) {
                    arrayList.add(NodeListPanel.this.nodeList_.getNodeView(i));
                }
                NodeListPanel.this.tbNodeView_.replace(0, arrayList);
            } else {
                NodeListPanel.this.nodeList_ = nodeList;
                NodeListPanel.this.updateTable();
            }
        }

        @Override
        public void update(NodeView[] nodeViewArray) {
            int n;
            ArgumentChecker.throwIfNull((Object)nodeViewArray);
            if (NodeListPanel.this.isUninitializedStatus()) {
                return;
            }
            int[] nArray = this.findIndices(nodeViewArray);
            if (nArray.length == 0) {
                return;
            }
            int n2 = nArray[0];
            int n3 = nArray[nArray.length - 1];
            while (n3 + 1 < NodeListPanel.this.tbNodeView_.size()) {
                NodeListPanel.this.tbNodeView_.removeLast();
            }
            ArrayList<NodeView> arrayList = new ArrayList<NodeView>();
            for (n = n2; n < NodeListPanel.this.tbNodeView_.size(); ++n) {
                arrayList.add(NodeListPanel.this.nodeList_.getNodeView(n));
            }
            NodeListPanel.this.tbNodeView_.replace(n2, arrayList);
            arrayList.clear();
            for (n = NodeListPanel.this.tbNodeView_.size(); n <= n3; ++n) {
                arrayList.add(NodeListPanel.this.nodeList_.getNodeView(n));
            }
            NodeListPanel.this.tbNodeView_.addAll(arrayList);
            NodeListPanel.this.tbNodeView_.extendColumns();
        }

        private int[] findIndices(NodeView[] nodeViewArray) {
            int n = 0;
            int[] nArray = new int[nodeViewArray.length];
            block0: for (int i = 0; i < NodeListPanel.this.nodeList_.size(); ++i) {
                for (int j = n; j < nodeViewArray.length; ++j) {
                    if (NodeListPanel.this.nodeList_.getNodeView(i) != nodeViewArray[j]) continue;
                    nArray[n] = i;
                    ++n;
                    continue block0;
                }
            }
            Arrays.sort(nArray);
            return nArray;
        }

        @Override
        public void currentChanged(NodeView nodeView) {
            int n;
            ArgumentChecker.throwIfNull((Object)nodeView);
            if (NodeListPanel.this.isUninitializedStatus()) {
                return;
            }
            while (NodeListPanel.this.nodeList_.size() < NodeListPanel.this.tbNodeView_.size()) {
                NodeListPanel.this.tbNodeView_.removeLast();
            }
            if (NodeListPanel.this.tbNodeView_.size() < NodeListPanel.this.nodeList_.size()) {
                n = NodeListPanel.this.tbNodeView_.size();
                int n2 = NodeListPanel.this.nodeList_.size();
                ArrayList<NodeView> arrayList = new ArrayList<NodeView>(n2 - n);
                for (int i = n; i < n2; ++i) {
                    arrayList.add(NodeListPanel.this.nodeList_.getNodeView(i));
                }
                NodeListPanel.this.tbNodeView_.addAll(arrayList);
            }
            for (n = 0; n < NodeListPanel.this.nodeList_.size(); ++n) {
                if (NodeListPanel.this.nodeList_.getNodeView(n) != nodeView) continue;
                NodeListPanel.this.tbNodeView_.replace(n, nodeView);
                break;
            }
            Table table = NodeListPanel.this.tbNodeView_.getControl();
            table.setSelection(NodeListPanel.this.nodeList_.getPositionIndex());
            table.showSelection();
            NodeListPanel.this.tbNodeView_.extendColumns();
        }

        @Override
        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull((Object)eventBroker);
            NodeListPanel.this.eventBroker_.removeView(NodeListPanel.this);
            NodeListPanel.this.eventBroker_ = eventBroker;
            NodeListPanel.this.eventBroker_.addView(NodeListPanel.this);
        }

        @Override
        public void attributeChanged(Set<String> set) {
            ArgumentChecker.throwIfNull(set);
            if (NodeListPanel.this.tbNodeView_.getControl() == null) {
                return;
            }
            boolean bl = false;
            if (set.contains(CoordinatesLabelProvider.class.getName())) {
                CoordinatesLabelProvider coordinatesLabelProvider = this.context_.getProvider(CoordinatesLabelProvider.class);
                CoordinatesLabelProvider coordinatesLabelProvider2 = NodeListPanel.this.provider_.getProvider();
                if (!coordinatesLabelProvider2.equals(coordinatesLabelProvider)) {
                    NodeListPanel.this.provider_.setProvider(coordinatesLabelProvider);
                    bl = true;
                }
            }
            if (bl) {
                NodeListPanel.this.tbNodeView_.update();
                NodeListPanel.this.tbNodeView_.packColumns();
            }
        }
    }

    private class MouseListener
    extends KeyAdapter {
        private MouseListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.keyCode | keyEvent.stateMask;
            if (ViewerUtils.toVariationIndex(n, NodeListPanel.this.nodeList_.getCurrentNodeView(), NodeListPanel.this.eventBroker_)) {
                return;
            }
            ViewerUtils.handleSelectNode(n, NodeListPanel.this.nodeList_, NodeListPanel.this.eventBroker_);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TableProvider
    implements UTableProvider<NodeView> {
        private TableProvider() {
        }

        @Override
        public int getColumnSize() {
            return 4;
        }

        @Override
        public boolean[] getSotableColums() {
            return new boolean[4];
        }

        @Override
        public int compareTo(NodeView nodeView, NodeView nodeView2, int n) {
            return 0;
        }

        @Override
        public void setup(TableColumn[] tableColumnArray) {
            tableColumnArray[0].setAlignment(0x1000000);
            tableColumnArray[1].setAlignment(131072);
            tableColumnArray[2].setAlignment(16384);
            tableColumnArray[3].setAlignment(16384);
        }

        @Override
        public void set(TableItem tableItem, NodeView nodeView) {
            for (int i = 0; i < 4; ++i) {
                tableItem.setImage(i, NodeListPanel.this.provider_.getColumnImage(nodeView, i));
                tableItem.setText(i, NodeListPanel.this.provider_.getColumnText(nodeView, i));
                tableItem.setForeground(i, NodeListPanel.this.provider_.getForeground(nodeView, i));
                tableItem.setBackground(i, NodeListPanel.this.provider_.getBackground(nodeView, i));
            }
        }
    }
}

