/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.provider.abp;

import java.util.EnumSet;
import java.util.Set;
import org.eclipse.swt.graphics.FontData;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Strings;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.sgf.util.SgfRectangle;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.ContextValue;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.board.IgoBoardView;
import org.unitarou.yukinoshita.model.board.InheritableMarker;
import org.unitarou.yukinoshita.view.jface.provider.abp.AsciiBoardOption;
import org.unitarou.yukinoshita.view.jface.provider.abp.AsciiBoardProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractAsciiBoardProvider
implements AsciiBoardProvider {
    private final ContextValue<FontData> ctxFontData_;
    private final ContextValue<EnumSet<AsciiBoardOption>> ctxOptions_;
    private FontData fontData_;
    private EnumSet<AsciiBoardOption> asciiBoardOptions_;

    protected AbstractAsciiBoardProvider(ContextValue<FontData> contextValue, ContextValue<EnumSet<AsciiBoardOption>> contextValue2) {
        ArgumentChecker.throwIfNull(contextValue, contextValue2);
        this.ctxFontData_ = contextValue;
        this.ctxOptions_ = contextValue2;
        CurrentContext currentContext = Yukinoshita.context(null);
        this.fontData_ = new FontData(currentContext.getAttribute(this.ctxFontData_).toString());
        this.asciiBoardOptions_ = currentContext.getAttribute(this.ctxOptions_);
    }

    @Override
    public final CharSequence getAsciiBoard(NodeView nodeView) {
        IgoBoardView igoBoardView = nodeView.getIgoBoard();
        SgfSize sgfSize = igoBoardView.size();
        Set<SgfPoint> set = igoBoardView.position(SgfColor.BLACK);
        Set<SgfPoint> set2 = igoBoardView.position(SgfColor.WHITE);
        SgfRectangle sgfRectangle = this.getViewArea(nodeView, sgfSize);
        CharSequence charSequence = this.get(PointType.BLACK);
        CharSequence charSequence2 = this.get(PointType.WHITE);
        StringBuilder stringBuilder = new StringBuilder(sgfRectangle.width() * (sgfRectangle.height() + 1));
        if (sgfRectangle.getStart().y() == 1 && this.asciiBoardOptions_.contains((Object)AsciiBoardOption.SHOW_COORDINATE)) {
            this.appendStartCoordinalte(stringBuilder, sgfRectangle.getStart().x(), sgfRectangle.getEnd().x());
        }
        for (int i = sgfRectangle.getStart().y(); i <= sgfRectangle.getEnd().y(); ++i) {
            if (sgfRectangle.getStart().x() == 1 && this.asciiBoardOptions_.contains((Object)AsciiBoardOption.SHOW_COORDINATE)) {
                this.appendLeftCoordinalte(stringBuilder, sgfSize.height() - i + 1);
            }
            for (int j = sgfRectangle.getStart().x(); j <= sgfRectangle.getEnd().x(); ++j) {
                SgfPoint sgfPoint = SgfPoint.create(sgfSize, j, i);
                if (set.contains(sgfPoint)) {
                    stringBuilder.append(charSequence);
                    continue;
                }
                if (set2.contains(sgfPoint)) {
                    stringBuilder.append(charSequence2);
                    continue;
                }
                stringBuilder.append(this.get(sgfPoint));
            }
            if (sgfRectangle.getEnd().x() == sgfSize.width() && this.asciiBoardOptions_.contains((Object)AsciiBoardOption.SHOW_COORDINATE)) {
                this.appendRightCoordinalte(stringBuilder, sgfSize.height() - i + 1);
            }
            stringBuilder.append(Strings.LINE_SEPARATOR);
        }
        if (sgfRectangle.getEnd().y() == sgfSize.height() && this.asciiBoardOptions_.contains((Object)AsciiBoardOption.SHOW_COORDINATE)) {
            this.appendEndCoordinalte(stringBuilder, sgfRectangle.getStart().x(), sgfRectangle.getEnd().x());
        }
        return stringBuilder;
    }

    private SgfRectangle getViewArea(NodeView nodeView, SgfSize sgfSize) {
        InheritableMarker inheritableMarker = nodeView.getInheritableMarker();
        String[] stringArray = inheritableMarker.get(SgfId.VIEW);
        SgfRectangle sgfRectangle = stringArray == null ? new SgfRectangle(sgfSize) : SgfRectangle.create(SgfPoint.parseAsSet(sgfSize, stringArray));
        return sgfRectangle;
    }

    protected abstract void appendStartCoordinalte(StringBuilder var1, int var2, int var3);

    protected abstract void appendEndCoordinalte(StringBuilder var1, int var2, int var3);

    protected abstract void appendLeftCoordinalte(StringBuilder var1, int var2);

    protected abstract void appendRightCoordinalte(StringBuilder var1, int var2);

    protected abstract CharSequence get(PointType var1);

    private CharSequence get(SgfPoint sgfPoint) {
        if (this.asciiBoardOptions_.contains((Object)AsciiBoardOption.DECOLATE_STARS) && sgfPoint.size().isStarPoint(sgfPoint)) {
            return this.get(PointType.STAR);
        }
        SgfPointType sgfPointType = SgfPointType.classify(sgfPoint);
        if (this.asciiBoardOptions_.contains((Object)AsciiBoardOption.DECOLATE_EDGE)) {
            switch (sgfPointType) {
                case TOP_LEFT: {
                    return this.get(PointType.E_TOP_LEFT);
                }
                case TOP: {
                    return this.get(PointType.E_TOP);
                }
                case TOP_RIGHT: {
                    return this.get(PointType.E_TOP_RIGHT);
                }
                case LEFT: {
                    return this.get(PointType.E_LEFT);
                }
                case EMPTY: {
                    return this.get(PointType.CENTER);
                }
                case RIGHT: {
                    return this.get(PointType.E_RIGHT);
                }
                case BOTTOM_LEFT: {
                    return this.get(PointType.E_BOTTOM_LEFT);
                }
                case BOTTOM: {
                    return this.get(PointType.E_BOTTOM);
                }
                case BOTTOM_RIGHT: {
                    return this.get(PointType.E_BOTTOM_RIGHT);
                }
            }
            return "";
        }
        switch (sgfPointType) {
            case TOP_LEFT: {
                return this.get(PointType.TOP_LEFT);
            }
            case TOP: {
                return this.get(PointType.TOP);
            }
            case TOP_RIGHT: {
                return this.get(PointType.TOP_RIGHT);
            }
            case LEFT: {
                return this.get(PointType.LEFT);
            }
            case EMPTY: {
                return this.get(PointType.CENTER);
            }
            case RIGHT: {
                return this.get(PointType.RIGHT);
            }
            case BOTTOM_LEFT: {
                return this.get(PointType.BOTTOM_LEFT);
            }
            case BOTTOM: {
                return this.get(PointType.BOTTOM);
            }
            case BOTTOM_RIGHT: {
                return this.get(PointType.BOTTOM_RIGHT);
            }
        }
        return "";
    }

    @Override
    public FontData getFontData() {
        return new FontData(this.fontData_.toString());
    }

    @Override
    public FontData setFontData(FontData fontData) {
        FontData fontData2 = this.fontData_;
        this.fontData_ = new FontData(fontData.toString());
        Yukinoshita.context(null).setAttribute(this.ctxFontData_, this.fontData_);
        return fontData2;
    }

    @Override
    public EnumSet<AsciiBoardOption> getOptions() {
        return EnumSet.copyOf(this.asciiBoardOptions_);
    }

    @Override
    public EnumSet<AsciiBoardOption> setOptions(EnumSet<AsciiBoardOption> enumSet) {
        ArgumentChecker.throwIfNull(enumSet);
        EnumSet<AsciiBoardOption> enumSet2 = this.asciiBoardOptions_;
        this.asciiBoardOptions_ = EnumSet.copyOf(enumSet);
        Yukinoshita.context(null).setAttribute(this.ctxOptions_, this.asciiBoardOptions_);
        return enumSet2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PointType {
        BLACK,
        L_BLACK,
        WHITE,
        L_WHITE,
        TOP_LEFT,
        E_TOP_LEFT,
        TOP,
        E_TOP,
        TOP_RIGHT,
        E_TOP_RIGHT,
        LEFT,
        E_LEFT,
        CENTER,
        STAR,
        RIGHT,
        E_RIGHT,
        BOTTOM_LEFT,
        E_BOTTOM_LEFT,
        BOTTOM,
        E_BOTTOM,
        BOTTOM_RIGHT,
        E_BOTTOM_RIGHT;

    }
}

