/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.dialogs;

import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ProgressBar;

public class ProgressIndicator
extends Composite {
    private static final int PROGRESS_MAX = 1000;
    private boolean animated = true;
    private StackLayout layout;
    private ProgressBar determinateProgressBar = new ProgressBar(this, 256);
    private ProgressBar indeterminateProgressBar = new ProgressBar(this, 258);
    private double totalWork;
    private double sumWorked;

    public ProgressIndicator(Composite parent) {
        super(parent, 0);
        this.layout = new StackLayout();
        this.setLayout(this.layout);
    }

    public void beginAnimatedTask() {
        this.done();
        this.layout.topControl = this.indeterminateProgressBar;
        this.layout();
        this.animated = true;
    }

    public void beginTask(int max) {
        this.done();
        this.totalWork = max;
        this.sumWorked = 0.0;
        this.determinateProgressBar.setMinimum(0);
        this.determinateProgressBar.setMaximum(1000);
        this.determinateProgressBar.setSelection(0);
        this.layout.topControl = this.determinateProgressBar;
        this.layout();
        this.animated = false;
    }

    public void done() {
        if (!this.animated) {
            this.determinateProgressBar.setMinimum(0);
            this.determinateProgressBar.setMaximum(0);
            this.determinateProgressBar.setSelection(0);
        }
        this.layout.topControl = null;
        this.layout();
    }

    public void sendRemainingWork() {
        this.worked(this.totalWork - this.sumWorked);
    }

    public void worked(double work) {
        if (work == 0.0 || this.animated) {
            return;
        }
        this.sumWorked += work;
        if (this.sumWorked > this.totalWork) {
            this.sumWorked = this.totalWork;
        }
        if (this.sumWorked < 0.0) {
            this.sumWorked = 0.0;
        }
        int value = (int)(this.sumWorked / this.totalWork * 1000.0);
        if (this.determinateProgressBar.getSelection() < value) {
            this.determinateProgressBar.setSelection(value);
        }
    }
}

