/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.jface.pref;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.jface.pref.PreferenceCodec;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.util.Provider;

public final class ProviderCodec
implements PreferenceCodec {
    private static final Log log_s_ = LogFactory.getLog(ProviderCodec.class);

    public boolean isEncodable(Object object) {
        return object instanceof Provider;
    }

    public String encode(Object object) {
        ArgumentChecker.throwIfNull(object);
        if (!this.isEncodable(object)) {
            throw new IllegalArgumentException();
        }
        return this.encode((Provider)object);
    }

    public String encode(Provider provider) {
        ArgumentChecker.throwIfNull((Object)provider);
        return provider.getClass().getName();
    }

    public Object decode(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        try {
            Class<?> clazz = Class.forName(string);
            if (Provider.class.isAssignableFrom(clazz)) {
                return clazz.newInstance();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            log_s_.warn("[IGNORE] ClassNotFoundException for '" + string + "'.");
        }
        catch (InstantiationException instantiationException) {
            log_s_.warn("[IGNORE] InstantiationException for '" + string + "'.");
        }
        catch (IllegalAccessException illegalAccessException) {
            log_s_.warn("[IGNORE] IllegalAccessException for '" + string + "'.");
        }
        return null;
    }
}

