/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.lang;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Classes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UEnum
implements Comparable<UEnum> {
    private static final Log log_s_ = LogFactory.getLog(UEnum.class);
    private static final Map<Class<? extends UEnum>, Map<String, UEnum>> enumMap_s_ = new HashMap<Class<? extends UEnum>, Map<String, UEnum>>();
    private static final char SEPARATOR = ':';
    private final String typeName_;

    public static <T extends UEnum> T find(Class<T> clazz, String string) {
        ArgumentChecker.throwIfNull(clazz, (Object)string);
        Map<String, UEnum> map = UEnum.getMapWithLoad(clazz, "UEnum#find");
        if (map != null) {
            return (T)map.get(string);
        }
        return null;
    }

    public static <T extends UEnum> List<T> getAll(Class<T> clazz) {
        ArgumentChecker.throwIfNull(clazz);
        Map<String, UEnum> map = UEnum.getMapWithLoad(clazz, "UEnum#getAll");
        if (map == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<UEnum> arrayList = new ArrayList<UEnum>(map.size());
        for (UEnum uEnum : map.values()) {
            arrayList.add(uEnum);
        }
        return arrayList;
    }

    private static Map<String, UEnum> getMapWithLoad(Class<? extends UEnum> clazz, String string) {
        Map<String, UEnum> map = enumMap_s_.get(clazz);
        if (map == null) {
            try {
                Class.forName(clazz.getName());
                log_s_.debug("Load " + clazz.getName() + " by " + string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                log_s_.error("Class load failure: " + clazz.getName(), classNotFoundException);
            }
            map = enumMap_s_.get(clazz);
        }
        return map;
    }

    protected UEnum(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        this.typeName_ = string;
        Map<String, UEnum> map = enumMap_s_.get(this.getClass());
        if (map == null) {
            map = new TreeMap<String, UEnum>();
            enumMap_s_.put(this.getClass(), map);
        } else if (map.containsKey(this.typeName_)) {
            throw new IllegalArgumentException(string + "[" + this.getClass().getName() + "] has already registered.");
        }
        map.put(this.typeName_, this);
    }

    public String typeName() {
        return this.typeName_;
    }

    public final boolean equals(Object object) {
        return super.equals(object);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return Classes.simpleName(this.getClass()) + ':' + this.typeName_;
    }

    @Override
    public final int compareTo(UEnum uEnum) {
        return this.typeName_.compareTo(uEnum.typeName_);
    }
}

