/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.ml;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Classes;
import org.unitarou.lang.ReferenceList;
import org.unitarou.ml.MessagesEvent;
import org.unitarou.ml.MessagesListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Messages {
    private static final Log logger_s_ = LogFactory.getLog(Messages.class);
    private static final String MESSAGES_NAME = "messages";
    private static final String BAD_PATTERN = "<<BAD PATTERN>>";
    private static final Map<String, Messages> messageMap_s_ = new TreeMap<String, Messages>();
    private static Locale currentLocale_s_ = Locale.getDefault();
    private static final ReferenceList<MessagesListener> listeners_s_ = new ReferenceList();
    private ResourceBundle resourceBundle_ = null;
    private final String bundleName_;
    private final ClassLoader classLoader_;
    private final Set<String> usedKeySet_;

    public static Messages create() {
        Messages messages = messageMap_s_.get(MESSAGES_NAME);
        if (messages == null) {
            messages = new Messages(MESSAGES_NAME, Messages.class.getClassLoader());
        }
        return messages;
    }

    public static Messages createByPackage(Class<?> clazz) {
        ArgumentChecker.throwIfNull(clazz);
        return Messages.createByPackage(clazz, MESSAGES_NAME, clazz.getClassLoader());
    }

    public static Messages createByPackage(Class<?> clazz, ClassLoader classLoader) {
        ArgumentChecker.throwIfNull(clazz, (Object)classLoader);
        return Messages.createByPackage(clazz, MESSAGES_NAME, classLoader);
    }

    public static Messages createByPackage(Class<?> clazz, String string) {
        ArgumentChecker.throwIfNull(clazz, (Object)string);
        return Messages.createByPackage(clazz, string, clazz.getClassLoader());
    }

    public static Messages createByPackage(Class<?> clazz, String string, ClassLoader classLoader) {
        ArgumentChecker.throwIfNull(clazz, (Object)string, (Object)classLoader);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Classes.packageName(clazz)).append('.').append(string);
        String string2 = stringBuilder.toString();
        Messages messages = messageMap_s_.get(string2);
        if (messages == null) {
            messages = new Messages(string2, classLoader);
        }
        return messages;
    }

    public static String createKey(Class<?> clazz, String string) {
        ArgumentChecker.throwIfNull(clazz, (Object)string);
        String string2 = Classes.simpleName(clazz);
        StringBuilder stringBuilder = new StringBuilder(string2.length() + string.length() + 1);
        stringBuilder.append(string2);
        if (string.length() != 0) {
            stringBuilder.append('.').append(string);
        }
        return stringBuilder.toString();
    }

    public static String createLongKey(Class<?> clazz, String string) {
        ArgumentChecker.throwIfNull(clazz, (Object)string);
        if (string.length() == 0) {
            return clazz.getName();
        }
        return clazz.getName() + '.' + string;
    }

    public static void addMessagesListener(MessagesListener messagesListener) {
        if (messagesListener == null) {
            return;
        }
        listeners_s_.add(messagesListener);
    }

    public static void removeMessagesListener(MessagesListener messagesListener) {
        listeners_s_.remove(messagesListener);
    }

    public static void changeLocale(Locale locale) {
        ArgumentChecker.throwIfNull((Object)locale);
        if (locale.equals(currentLocale_s_)) {
            return;
        }
        currentLocale_s_ = locale;
        Object object = messageMap_s_.values().iterator();
        while (object.hasNext()) {
            object.next().getResoureBundle();
        }
        object = new MessagesEvent(Messages.class, currentLocale_s_);
        for (MessagesListener messagesListener : listeners_s_) {
            messagesListener.changeLocale((MessagesEvent)object);
        }
    }

    public static void inspectUnusedMessages() {
        if (!logger_s_.isDebugEnabled()) {
            return;
        }
        for (Messages messages : messageMap_s_.values()) {
            Enumeration<String> enumeration = messages.resourceBundle_.getKeys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                if (messages.usedKeySet_.contains(string)) continue;
                logger_s_.debug(string + " (bundleName: " + messages.bundleName_ + ")is not used.");
            }
        }
    }

    private Messages(String string, ClassLoader classLoader) {
        this.bundleName_ = string;
        this.classLoader_ = classLoader;
        this.usedKeySet_ = Collections.synchronizedSet(new HashSet());
        messageMap_s_.put(string, this);
    }

    private synchronized ResourceBundle getResoureBundle() {
        if (this.resourceBundle_ == null) {
            try {
                this.resourceBundle_ = ResourceBundle.getBundle(this.bundleName_, currentLocale_s_, this.classLoader_);
            }
            catch (MissingResourceException missingResourceException) {
                logger_s_.warn("Can not find resource bundle. Use pseudo object. Bundle name=" + this.bundleName_ + ", Class loader=" + this.classLoader_ + ", Current locale=" + currentLocale_s_);
                this.resourceBundle_ = new PseudoResourceBundle();
            }
        }
        return this.resourceBundle_;
    }

    public boolean contains(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        try {
            this.getResoureBundle().getString(string);
            return true;
        }
        catch (MissingResourceException missingResourceException) {
            return false;
        }
    }

    public String get(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        return this.getString(string);
    }

    public String get(String string, Object object) {
        return this.get(string, new Object[]{object});
    }

    public String get(String string, Object[] objectArray) {
        ArgumentChecker.throwIfNull((Object)string, (Object)objectArray);
        String string2 = this.getString(string);
        try {
            return MessageFormat.format(string2, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger_s_.warn("Bad pattern. key:" + string + ", pattern:" + string2 + ", reason:" + illegalArgumentException.getLocalizedMessage());
            return BAD_PATTERN;
        }
    }

    private String getString(String string) {
        String string2;
        try {
            string2 = this.getResoureBundle().getString(string);
            if (logger_s_.isDebugEnabled()) {
                this.usedKeySet_.add(string);
            }
        }
        catch (MissingResourceException missingResourceException) {
            logger_s_.warn("Cannot find the key='" + string + "' in " + this.bundleName_);
            logger_s_.debug("Plz find a lost key from:", missingResourceException);
            string2 = "!" + string + "!";
        }
        return string2.trim();
    }

    public Properties getAll() {
        Properties properties = new Properties();
        Enumeration<String> enumeration = this.getResoureBundle().getKeys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            properties.setProperty(string, this.getString(string));
        }
        return properties;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PseudoResourceBundle
    extends ResourceBundle {
        private PseudoResourceBundle() {
        }

        @Override
        protected Object handleGetObject(String string) {
            return null;
        }

        @Override
        public Enumeration<String> getKeys() {
            return new Vector().elements();
        }
    }
}

