/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.type;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Sgfs;
import org.unitarou.sgf.ValueType;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.sgf.type.TypedString;
import org.unitarou.sgf.util.SgfPointType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SgfPoint
implements TypedString<SgfPoint> {
    private static final Log log_s_ = LogFactory.getLog(SgfPoint.class);
    public static final SgfPoint[] EMPTY_ARRAY = new SgfPoint[0];
    public static final int MAX_NEIGHBORS = 4;
    private static final Pattern condition_s_ = Pattern.compile("|(([a-zA-Z])([a-zA-Z]))");
    private static final int ALL_POS = 0;
    private static final int X_POS = 2;
    private static final int Y_POS = 3;
    private static final Pattern compressedCondition_s_ = Pattern.compile("\\s*([a-zA-Z])([a-zA-Z])\\s*:\\s*([a-zA-Z])([a-zA-Z])\\s*");
    private static final int COMP_X1_POS = 1;
    private static final int COMP_Y1_POS = 2;
    private static final int COMP_X2_POS = 3;
    private static final int COMP_Y2_POS = 4;
    private final SgfSize size_;
    private final int x_;
    private final int y_;
    private final int order_;
    private final int index_;
    private final SgfPointType condition_;
    private Set<SgfPoint> neighbors_;
    private String toString_;
    private String string_;

    public static boolean isValid(SgfSize sgfSize, String string) {
        int n;
        ArgumentChecker.throwIfNull((Object)sgfSize, (Object)string);
        Matcher matcher = condition_s_.matcher(string);
        if (!matcher.matches()) {
            return false;
        }
        if (matcher.group(0).length() == 0) {
            return true;
        }
        int n2 = Sgfs.fromSgf(matcher.group(2).charAt(0));
        SgfPointType sgfPointType = sgfSize.check(n2, n = Sgfs.fromSgf(matcher.group(3).charAt(0)));
        return sgfPointType.equals((Object)SgfPointType.IN) || sgfPointType.equals((Object)SgfPointType.PASS);
    }

    public static SgfPoint parseMove(SgfSize sgfSize, String string) throws TypeParseException {
        ArgumentChecker.throwIfNull((Object)sgfSize, (Object)string);
        try {
            Matcher matcher = condition_s_.matcher(string);
            if (!matcher.matches()) {
                throw new TypeParseException("Bad argument value = " + string);
            }
            if (matcher.group(0).length() == 0) {
                return sgfSize.getPass();
            }
            int n = Sgfs.fromSgf(matcher.group(2).charAt(0));
            int n2 = Sgfs.fromSgf(matcher.group(3).charAt(0));
            return sgfSize.get(n, n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new TypeParseException(illegalArgumentException);
        }
    }

    public static SgfPoint parseMoveQuietly(SgfSize sgfSize, String string) {
        try {
            return SgfPoint.parseMove(sgfSize, string);
        }
        catch (TypeParseException typeParseException) {
            log_s_.debug("Can't parse value: " + string, typeParseException);
            return null;
        }
    }

    public static Set<SgfPoint> parseAsSet(SgfSize sgfSize, String[] stringArray) {
        ArgumentChecker.throwIfNull((Object)sgfSize, (Object)stringArray);
        HashSet<SgfPoint> hashSet = new HashSet<SgfPoint>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                int n;
                Matcher matcher = compressedCondition_s_.matcher(stringArray[i]);
                if (!matcher.matches()) {
                    hashSet.add(SgfPoint.parseMove(sgfSize, stringArray[i]));
                    continue;
                }
                int n2 = Sgfs.fromSgf(matcher.group(1).charAt(0));
                int n3 = Sgfs.fromSgf(matcher.group(2).charAt(0));
                int n4 = Sgfs.fromSgf(matcher.group(3).charAt(0));
                int n5 = Sgfs.fromSgf(matcher.group(4).charAt(0));
                if (n4 < n2) {
                    n = n2;
                    n2 = n4;
                    n4 = n;
                }
                if (n5 < n3) {
                    n = n3;
                    n3 = n5;
                    n5 = n;
                }
                for (n = n2; n <= n4; ++n) {
                    for (int j = n3; j <= n5; ++j) {
                        hashSet.add(sgfSize.get(n, j));
                    }
                }
                continue;
            }
            catch (TypeParseException typeParseException) {
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return hashSet;
    }

    public static SgfPoint[] parse(SgfSize sgfSize, String[] stringArray) {
        Set<SgfPoint> set = SgfPoint.parseAsSet(sgfSize, stringArray);
        return set.toArray(new SgfPoint[set.size()]);
    }

    public static SgfPoint create(SgfSize sgfSize, int n, int n2) {
        ArgumentChecker.throwIfNull((Object)sgfSize);
        return sgfSize.get(n, n2);
    }

    public static SgfPoint createPass(SgfSize sgfSize) {
        ArgumentChecker.throwIfNull((Object)sgfSize);
        return sgfSize.getPass();
    }

    SgfPoint(SgfSize sgfSize, int n, int n2) {
        assert (sgfSize != null);
        this.condition_ = sgfSize.check(n, n2);
        this.size_ = sgfSize;
        if (this.condition_.equals((Object)SgfPointType.IN)) {
            this.x_ = n;
            this.y_ = n2;
            this.index_ = this.size_.width() * (n2 - 1) + n - 1;
        } else {
            this.x_ = 0;
            this.y_ = 0;
            this.index_ = -1;
        }
        this.order_ = this.x_ + this.y_ * 52;
        this.neighbors_ = null;
        this.toString_ = null;
        this.string_ = null;
    }

    public SgfSize size() {
        return this.size_;
    }

    public int x() {
        return this.x_;
    }

    public int y() {
        return this.y_;
    }

    public SgfPointType condition() {
        return this.condition_;
    }

    public Set<SgfPoint> neighbors() {
        if (this.neighbors_ != null) {
            return this.neighbors_;
        }
        HashSet<SgfPoint> hashSet = new HashSet<SgfPoint>();
        if (1 < this.x_) {
            hashSet.add(this.size_.get(this.x_ - 1, this.y_));
        }
        if (this.x_ < this.size_.width()) {
            hashSet.add(this.size_.get(this.x_ + 1, this.y_));
        }
        if (1 < this.y_) {
            hashSet.add(this.size_.get(this.x_, this.y_ - 1));
        }
        if (this.y_ < this.size_.height()) {
            hashSet.add(this.size_.get(this.x_, this.y_ + 1));
        }
        this.neighbors_ = Collections.unmodifiableSet(hashSet);
        return this.neighbors_;
    }

    public int index() {
        return this.index_;
    }

    @Override
    public boolean acceptable(SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sgfId);
        return ValueType.POINT.equals((Object)sgfId.valueType()) || ValueType.MOVE.equals((Object)sgfId.valueType());
    }

    @Override
    public String getString() {
        if (this.string_ != null) {
            return this.string_;
        }
        this.string_ = this.x_ == 0 ? "" : new String(new char[]{Sgfs.toSgf(this.x_), Sgfs.toSgf(this.y_)});
        return this.string_;
    }

    @Override
    public int compareTo(SgfPoint sgfPoint) {
        int n = this.order_ - sgfPoint.order_;
        return n == 0 ? this.size_.compareTo(sgfPoint.size_) : n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        SgfPoint sgfPoint = (SgfPoint)object;
        return this.x_ == sgfPoint.x_ && this.y_ == sgfPoint.y_ && this.size_.equals(sgfPoint.size_);
    }

    public int hashCode() {
        return this.order_;
    }

    public String toString() {
        if (this.toString_ == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('[');
            stringBuilder.append(this.x_);
            stringBuilder.append(',');
            stringBuilder.append(this.y_);
            stringBuilder.append(']');
            stringBuilder.append(this.size_);
            this.toString_ = stringBuilder.toString();
        }
        return this.toString_;
    }
}

