/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.io.FileSnapshot;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.LogLevel;
import org.unitarou.lang.Objects;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.io.CollectionRepository;
import org.unitarou.sgf.parser.CollectionEncodingException;
import org.unitarou.sgf.parser.SgfFormatter;
import org.unitarou.sgf.parser.SgfLog;
import org.unitarou.sgf.parser.SgfParserOption;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.ProblemProperties;
import org.unitarou.sgf.type.SgfApplication;
import org.unitarou.sgf.type.SgfCharset;
import org.unitarou.sgf.util.BasicFinder;
import org.unitarou.yukinoshita.Application;
import org.unitarou.yukinoshita.DatabaseManager;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.YukinoshitaException;
import org.unitarou.yukinoshita.context.Context;
import org.unitarou.yukinoshita.context.ContextValue;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.context.IntContextValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileManager {
    public static final ContextValue<EnumSet<SgfParserOption>> PARSER_OPTIONS = new ContextValue<EnumSet<SgfParserOption>>(FileManager.class, "parserOptions", EnumSet.allOf(SgfParserOption.class));
    public static final ContextValue<EnumSet<SgfFormatter.Option>> FORMATTER_OPTIONS = new ContextValue<EnumSet<SgfFormatter.Option>>(FileManager.class, "formatterOptions", EnumSet.of(SgfFormatter.Option.ADD_NEW_LINE_BEFORE_RGT, SgfFormatter.Option.ADD_NEW_LINE_BEFORE_NODE, SgfFormatter.Option.USE_TT_PASS));
    public static final ContextValue<SgfFormatter.ComposeOption> COMPOSE_OPTION = new ContextValue<SgfFormatter.ComposeOption>(FileManager.class, "composeOption", SgfFormatter.ComposeOption.AS_IT_IS);
    public static final ContextValue<Boolean> UPDATE_AP = new ContextValue<Boolean>(FileManager.class, "updateAp", Boolean.TRUE);
    public static final ContextValue<File[]> FILE_HISTORY = new ContextValue<File[]>(FileManager.class, "fileHistory", new File[0]);
    public static final IntContextValue FILE_HISTORY_SIZE = new IntContextValue(FileManager.class, "fileHistorySize", 0, 5, 20);
    public static final File FILE_TEMPLATE = new File("template.sgf");
    private static final Log log_s_ = LogFactory.getLog(FileManager.class);
    private static final Message MSG_FILE_IO_ERROR = new Message(FileManager.class, "msgFileIoError");
    private static final Message MSG_ERROR_ON_WRITE = new Message(FileManager.class, "msgErrorOnWrite");
    private static final Message NT_FILE_READ_FAILURE = new Message(FileManager.class, "ntFileReadFailure");
    private static final Message MSG_GAME_NOT_FOUND = new Message(FileManager.class, "msgGameNotFound");
    private static final Message NT_CANT_OVERWRITE = new Message(FileManager.class, "ntCantOverwrite");
    private static final Message MSG_READ_ONLY_FILE = new Message(FileManager.class, "msgReadOnlyFile");
    private static final Message MSG_ALREADY_UPDATED = new Message(FileManager.class, "msgAlreadyUpdated");
    private static final Message NT_ENCODE_FAILURE = new Message(FileManager.class, "ntEncodeFailure");
    private static final Message MSG_CONFIRM_CHANGE_CHARSET = new Message(FileManager.class, "msgConfirmChangeCharset");
    private static final Message NT_MEMORY_IS_EXHAUSTED = new Message(FileManager.class, "ntMemoryIsExhausted");
    private static final Message MSG_MEMORY_IS_EXHAUSTED = new Message(FileManager.class, "msgMemoryIsExhausted");
    private static final File trashCan_s_ = new File("./trushCan.sgf");
    private static final FileManager instance_s_ = new FileManager();

    public static FileManager instance() {
        return instance_s_;
    }

    private FileManager() {
    }

    public Collection open(File file) {
        ArgumentChecker.throwIfNull((Object)file);
        Application application = Yukinoshita.application();
        try {
            Collection collection = this.openNoDialog(file, true);
            if (collection.size() == 0) {
                String string = MSG_GAME_NOT_FOUND.get((Object)file);
                log_s_.info(string);
                application.openMessageDialog(Application.MessageLevel.INFORMATION, NT_FILE_READ_FAILURE.get(), string);
                return null;
            }
            DatabaseManager.instance().refreshFileIndex(Objects.asList(collection));
            return collection;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.gc();
            application.openMessageDialog(Application.MessageLevel.WARNING, NT_MEMORY_IS_EXHAUSTED.get(), MSG_MEMORY_IS_EXHAUSTED.get());
            return null;
        }
    }

    public Collection openNoDialog(File file, boolean bl) {
        String string;
        ProblemProperties problemProperties;
        CurrentContext currentContext = Yukinoshita.context(null);
        EnumSet<SgfParserOption> enumSet = currentContext.getAttribute(PARSER_OPTIONS);
        Collection collection = CollectionRepository.instance().load(file, enumSet, bl);
        if (collection.size() == 0) {
            return collection;
        }
        RootGameTree rootGameTree = collection.get(0);
        if (GameType.DRILL.equals(rootGameTree.getGameType()) && (problemProperties = ProblemProperties.parsePpQuietly(string = BasicFinder.findDatum(rootGameTree.getSequence(), SgfId.PROBLEM_PROPERTIES))) != null) {
            Yukinoshita.context(collection).setInteger(Context.PROBLEM_PROPERTIES.id(), problemProperties.getIntValue());
        }
        return collection;
    }

    public void insertFileHistory(File file) {
        CurrentContext currentContext = Yukinoshita.context(null);
        File[] fileArray = currentContext.getAttribute(FILE_HISTORY);
        LinkedList<File> linkedList = new LinkedList<File>(Arrays.asList(fileArray));
        linkedList.remove(file);
        linkedList.addFirst(file);
        int n = currentContext.getAttribute(FILE_HISTORY_SIZE);
        while (n < linkedList.size()) {
            linkedList.removeLast();
        }
        currentContext.setAttribute(FILE_HISTORY, linkedList.toArray(new File[linkedList.size()]));
    }

    public void close(Collection collection) {
        ArgumentChecker.throwIfNull((Object)collection);
    }

    public EnumSet<SaveResult> save(Collection collection) throws YukinoshitaException {
        return this.saveAs(collection, collection.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnumSet<SaveResult> saveAs(Collection collection, File file) throws YukinoshitaException {
        ArgumentChecker.throwIfNull((Object)collection, (Object)file);
        try {
            Object object;
            CurrentContext currentContext = Yukinoshita.context(null);
            if (currentContext.getAttribute(UPDATE_AP).booleanValue()) {
                object = SgfApplication.create("Yukinoshita", "2.2.3");
                for (RootGameTree rootGameTree : collection) {
                    rootGameTree.setApplication((SgfApplication)object);
                }
            }
            if (!GameType.DRILL.equals(collection.get(0).getGameType())) {
                object = this.saveImpl(collection, file);
                return object;
            }
            object = new Collection(collection);
            while (1 < ((Collection)object).size()) {
                ((Collection)object).remove(1);
            }
            EnumSet<SaveResult> enumSet = this.saveImpl((Collection)object, file);
            return enumSet;
        }
        finally {
            collection.setFile(file);
            DatabaseManager.instance().refreshFileIndex(Objects.asList(collection));
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private EnumSet<SaveResult> saveImpl(Collection collection, File file) throws YukinoshitaException {
        EnumSet<SaveResult> enumSet;
        EnumSet<SaveResult> enumSet2 = EnumSet.noneOf(SaveResult.class);
        SgfFormatter sgfFormatter = this.getFormatter();
        FileOutputStream fileOutputStream = null;
        ByteBuffer byteBuffer = null;
        try {
            byteBuffer = sgfFormatter.format(collection);
        }
        catch (CollectionEncodingException collectionEncodingException) {
            boolean bl = Yukinoshita.application().openMessageDialog(Application.MessageLevel.CONFIRM, NT_ENCODE_FAILURE.get(), MSG_CONFIRM_CHANGE_CHARSET.get(collectionEncodingException.getRgtIndex() + 1, collectionEncodingException.getNewCharset().displayName()));
            if (!bl) {
                return enumSet2;
            }
            try {
                collection.get(collectionEncodingException.getRgtIndex()).setCharset(new SgfCharset(collectionEncodingException.getNewCharset()));
                byteBuffer = sgfFormatter.format(collection);
                enumSet2.add(SaveResult.CHANGE_CHARSET);
            }
            catch (CollectionEncodingException collectionEncodingException2) {
                throw new YukinoshitaException(MSG_ERROR_ON_WRITE.get((Object)collectionEncodingException2.getLocalizedMessage()), collectionEncodingException2);
            }
        }
        try {
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.getChannel().write(byteBuffer);
            fileOutputStream.flush();
            enumSet2.add(SaveResult.SAVE_OK);
            enumSet = enumSet2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                throw new YukinoshitaException(MSG_ERROR_ON_WRITE.get((Object)fileNotFoundException.getLocalizedMessage()), fileNotFoundException);
                catch (IOException iOException) {
                    throw new YukinoshitaException(MSG_FILE_IO_ERROR.get((Object)iOException.getLocalizedMessage()), iOException);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileOutputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(fileOutputStream);
        return enumSet;
    }

    public SgfFormatter getFormatter() {
        SgfFormatter sgfFormatter = new SgfFormatter();
        CurrentContext currentContext = Yukinoshita.context(null);
        EnumSet<SgfFormatter.Option> enumSet = currentContext.getAttribute(FORMATTER_OPTIONS);
        sgfFormatter.setOptions(enumSet);
        sgfFormatter.setComposeOption(currentContext.getAttribute(COMPOSE_OPTION));
        return sgfFormatter;
    }

    public Map<File, List<SgfLog.SgfMessage>> refreshIndex(List<File> list) {
        ArgumentChecker.throwIfNull(list);
        HashMap<File, List<SgfLog.SgfMessage>> hashMap = new HashMap<File, List<SgfLog.SgfMessage>>();
        ArrayList<Collection> arrayList = new ArrayList<Collection>(list.size());
        for (File object : list) {
            Collection collection = this.openNoDialog(object, false);
            List<SgfLog.SgfMessage> list2 = collection.getParserLog().getMessages(LogLevel.WARN);
            if (!list2.isEmpty()) {
                hashMap.put(object, list2);
            }
            if (collection.size() != 0) {
                arrayList.add(collection);
                continue;
            }
            this.close(collection);
        }
        DatabaseManager.instance().refreshFileIndex(arrayList);
        for (Collection collection : arrayList) {
            this.close(collection);
        }
        return hashMap;
    }

    public boolean checkOverwritable(Collection collection) {
        ArgumentChecker.throwIfNull((Object)collection);
        File file = collection.getFile();
        if (file == null) {
            return false;
        }
        FileSnapshot fileSnapshot = new FileSnapshot(file);
        FileSnapshot fileSnapshot2 = collection.getFileSnapshot();
        if (fileSnapshot.equals(fileSnapshot2) && file.canWrite()) {
            return true;
        }
        String string = !file.canWrite() ? MSG_READ_ONLY_FILE.get((Object)file.getAbsolutePath()) : MSG_ALREADY_UPDATED.get(file.getAbsolutePath(), new Date(fileSnapshot2.lastModified()), fileSnapshot2.length(), new Date(fileSnapshot.lastModified()), fileSnapshot.length());
        Yukinoshita.application().openMessageDialog(Application.MessageLevel.INFORMATION, NT_CANT_OVERWRITE.get(), string);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop(RootGameTree rootGameTree) {
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        Collection collection = null;
        try {
            collection = this.openTrashCan();
            collection.addLast(rootGameTree);
            this.save(collection);
        }
        catch (YukinoshitaException yukinoshitaException) {
            yukinoshitaException.printStackTrace();
        }
        finally {
            if (collection != null) {
                this.close(collection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop(Collection collection) {
        ArgumentChecker.throwIfNull((Object)collection);
        Collection collection2 = null;
        try {
            collection2 = this.openTrashCan();
            for (RootGameTree rootGameTree : collection) {
                collection2.addLast(rootGameTree);
            }
            this.save(collection2);
        }
        catch (YukinoshitaException yukinoshitaException) {
            yukinoshitaException.printStackTrace();
        }
        finally {
            if (collection2 != null) {
                this.close(collection2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RootGameTree pickUp(int n) {
        RootGameTree rootGameTree = null;
        Collection collection = null;
        try {
            collection = this.openTrashCan();
            if (n < 0 || collection.size() <= n) {
                throw new IllegalArgumentException("Bad index (out of range):" + n);
            }
            rootGameTree = collection.remove(n);
            this.save(collection);
            RootGameTree rootGameTree2 = rootGameTree;
            return rootGameTree2;
        }
        catch (YukinoshitaException yukinoshitaException) {
            yukinoshitaException.printStackTrace();
            RootGameTree rootGameTree3 = rootGameTree;
            return rootGameTree3;
        }
        finally {
            if (collection != null) {
                this.close(collection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getTrashCan() {
        Collection collection = null;
        try {
            collection = this.openTrashCan();
            Collection collection2 = new Collection(collection);
            return collection2;
        }
        finally {
            if (collection != null) {
                this.close(collection);
            }
        }
    }

    public void clearTrashCan() {
        trashCan_s_.delete();
    }

    private Collection openTrashCan() {
        if (!trashCan_s_.exists()) {
            Collection collection = new Collection();
            collection.setFile(trashCan_s_);
            return collection;
        }
        return this.openNoDialog(trashCan_s_, true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SaveResult {
        SAVE_OK,
        CHANGE_CHARSET;

    }
}

