/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.events;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Classes;
import org.unitarou.lang.Runtimes;
import org.unitarou.sgf.type.GameType;
import org.unitarou.util.Adaptable;
import org.unitarou.yukinoshita.events.ActionListener;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.HandlerSelector;
import org.unitarou.yukinoshita.events.StateHandler;
import org.unitarou.yukinoshita.model.cmd.NodeListCommand;
import org.unitarou.yukinoshita.view.cmd.ViewCommand;
import org.unitarou.yukinoshita.view.monitor.CollectionMonitor;
import org.unitarou.yukinoshita.view.monitor.CommandDriverMonitor;
import org.unitarou.yukinoshita.view.monitor.ContextMonitor;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.GameInfoNodeMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;
import org.unitarou.yukinoshita.view.monitor.LayoutMonitor;
import org.unitarou.yukinoshita.view.monitor.MouseWheelMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeListMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;
import org.unitarou.yukinoshita.view.monitor.OutlineMonitor;
import org.unitarou.yukinoshita.view.monitor.ProblemStatusMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventBrokerImpl
implements EventBroker {
    private static final Log log_s_ = LogFactory.getLog(EventBrokerImpl.class);
    private static final Class<?>[] viewAdapters_s_ = new Class[]{CollectionMonitor.class, GameMonitor.class, NodeListMonitor.class, NodeMonitor.class, GameInfoNodeMonitor.class, ContextMonitor.class, ControllerStatusMonitor.class, ProblemStatusMonitor.class, OutlineMonitor.class, LayoutMonitor.class, CommandDriverMonitor.class, MouseWheelMonitor.class};
    private static final Class[] ctrlAdapters_s_ = new Class[]{ActionListener.class};
    private final Map<Class<?>, Set<Object>> adapterMap_ = new HashMap();
    private final HandlerSelector handlerSelector_ = new HandlerSelector();

    public EventBrokerImpl() {
        this.handlerSelector_.setEventBroker(this);
    }

    public void dispose() {
        for (Set<Object> set : this.adapterMap_.values()) {
            set.clear();
        }
        this.adapterMap_.clear();
        this.handlerSelector_.clear();
    }

    @Override
    public void addView(Adaptable adaptable) {
        ArgumentChecker.throwIfNull((Object)adaptable);
        for (Class<?> clazz : viewAdapters_s_) {
            this.addAdapter(adaptable, clazz);
        }
    }

    @Override
    public void removeView(Adaptable adaptable) {
        ArgumentChecker.throwIfNull((Object)adaptable);
        for (Class<?> clazz : viewAdapters_s_) {
            this.removeAdapter(adaptable, clazz);
        }
    }

    public void addController(Adaptable adaptable) {
        ArgumentChecker.throwIfNull((Object)adaptable);
        for (Class clazz : ctrlAdapters_s_) {
            this.addAdapter(adaptable, clazz);
        }
    }

    public void removeController(Adaptable adaptable) {
        ArgumentChecker.throwIfNull((Object)adaptable);
        for (Class clazz : ctrlAdapters_s_) {
            this.removeAdapter(adaptable, clazz);
        }
    }

    private void addAdapter(Adaptable adaptable, Class<?> clazz) {
        Object object;
        Set<Object> set = this.adapterMap_.get(clazz);
        if (set == null) {
            set = new LinkedHashSet<Object>();
            this.adapterMap_.put(clazz, set);
        }
        if ((object = adaptable.getAdapter(clazz)) == null) {
            return;
        }
        if (!clazz.isInstance(object)) {
            throw new IllegalArgumentException("Bad adapter: adaptable:" + adaptable + " class:" + clazz + ", but obj:" + object);
        }
        set.add(object);
        if (log_s_.isTraceEnabled()) {
            log_s_.trace("[ADD ADAPTER] " + Classes.simpleName(adaptable.getClass()) + " has " + Classes.simpleName(clazz) + "'s adapter: " + object);
        }
    }

    private void removeAdapter(Adaptable adaptable, Class<?> clazz) {
        Object object = adaptable.getAdapter(clazz);
        if (object == null) {
            return;
        }
        if (!clazz.isInstance(object)) {
            throw new IllegalArgumentException("Bad adapter: adaptable:" + adaptable + " class:" + clazz + ", but obj:" + object);
        }
        Set<Object> set = this.adapterMap_.get(clazz);
        if (set != null) {
            set.remove(object);
        }
        if (log_s_.isTraceEnabled()) {
            log_s_.trace("[DEL ADAPTER] " + Classes.simpleName(adaptable.getClass()) + " has " + Classes.simpleName(clazz) + "'s adapter: " + object);
        }
    }

    @Override
    public <T> List<T> getListeners(Class<T> clazz) {
        ArgumentChecker.throwIfNull(clazz);
        Set<Object> set = this.adapterMap_.get(clazz);
        if (set == null) {
            set = new LinkedHashSet<Object>();
            log_s_.warn("Unused or unregistered listener (May be BUG):" + clazz);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(set.size());
        for (Object object : set) {
            arrayList.add(object);
        }
        if (log_s_.isTraceEnabled()) {
            log_s_.trace("[CALL LISTENER] " + clazz.getName() + " is called. " + "Listener size is " + arrayList.size());
        }
        return arrayList;
    }

    @Override
    public void register(GameType gameType, boolean bl, StateHandler stateHandler) {
        this.handlerSelector_.put(gameType, bl, stateHandler);
        stateHandler.setEventBroker(this);
        if (log_s_.isTraceEnabled()) {
            log_s_.trace("[REGISTER] " + gameType + "(Edit mode:" + bl + "), state handler: " + stateHandler);
        }
    }

    @Override
    public void connect(GameType gameType, boolean bl) {
        this.handlerSelector_.connect(gameType, bl);
        if (log_s_.isTraceEnabled()) {
            log_s_.trace("[CONNECT] " + gameType + "/Edit mode:" + bl);
        }
    }

    @Override
    public void disconnect() {
        this.handlerSelector_.disconnect();
        if (log_s_.isTraceEnabled()) {
            log_s_.trace("[DISCONNECT] ");
        }
    }

    @Override
    public StateHandler getCurrentStateHander() {
        return this.handlerSelector_.getCurrent();
    }

    @Override
    public void executeCommand(NodeListCommand nodeListCommand) {
        ArgumentChecker.throwIfNull((Object)nodeListCommand);
        if (log_s_.isTraceEnabled()) {
            log_s_.trace("[START COMMAND] " + nodeListCommand + " " + Runtimes.formatStackTrace(4));
        }
        for (ActionListener actionListener : this.getListeners(ActionListener.class)) {
            actionListener.executeCommand(nodeListCommand);
        }
        if (log_s_.isTraceEnabled()) {
            log_s_.trace("[END COMMAND] " + nodeListCommand);
        }
    }

    @Override
    public void executeCommand(ViewCommand viewCommand) {
        ArgumentChecker.throwIfNull((Object)viewCommand);
        if (log_s_.isTraceEnabled()) {
            log_s_.trace("[START COMMAND] " + viewCommand + " " + Runtimes.formatStackTrace(4));
        }
        for (ActionListener actionListener : this.getListeners(ActionListener.class)) {
            actionListener.executeCommand(viewCommand);
        }
        if (log_s_.isTraceEnabled()) {
            log_s_.trace("[END COMMAND] " + viewCommand);
        }
    }
}

