/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.cmd;

import java.util.EnumSet;
import org.unitarou.cmd.Command;
import org.unitarou.ml.Message;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Sequence;
import org.unitarou.sgf.cmd.RemoveGameTree;
import org.unitarou.yukinoshita.model.NodeEntity;
import org.unitarou.yukinoshita.model.NodeListEditor;
import org.unitarou.yukinoshita.model.NodeTree;
import org.unitarou.yukinoshita.model.cmd.ModelInfluence;
import org.unitarou.yukinoshita.model.cmd.NodeListCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveVariation
extends NodeListCommand {
    private static final Message LB_NAME = new Message(RemoveVariation.class, "lbName");
    private final int targetIndex_;
    private boolean isSetuped_;
    private Command sgfCommand_;
    private GameTree target_;
    private NodeEntity undoStart_;

    public RemoveVariation(int n) {
        this.targetIndex_ = n;
        this.isSetuped_ = false;
        this.sgfCommand_ = null;
        this.target_ = null;
        this.undoStart_ = null;
        this.setDisplayName(LB_NAME.get());
    }

    @Override
    protected boolean setup() {
        if (this.isSetuped_) {
            return true;
        }
        NodeListEditor nodeListEditor = this.getNodeListEditor();
        if (nodeListEditor == null) {
            return false;
        }
        if (this.targetIndex_ < 0 || nodeListEditor.size() <= this.targetIndex_) {
            throw new IndexOutOfBoundsException("index = " + this.targetIndex_);
        }
        this.undoStart_ = null;
        this.setExecutedNodeIndex(nodeListEditor.getPositionIndex());
        this.setUndoneNodeIndex(nodeListEditor.getPositionIndex());
        this.isSetuped_ = true;
        NodeEntity nodeEntity = this.getNodeListEditor().get(this.targetIndex_);
        NodeTree nodeTree = nodeEntity.getNodeTree();
        this.sgfCommand_ = new RemoveGameTree(nodeTree.getParentGameTree(), nodeTree.getGameTree());
        this.target_ = nodeTree.getGameTree();
        return true;
    }

    @Override
    public void execute() {
        NodeEntity nodeEntity;
        super.execute();
        this.sgfCommand_.execute();
        NodeEntity nodeEntity2 = this.getNodeListEditor().removeLast();
        while (nodeEntity2.getNodeTree().getGameTree().equals(this.target_)) {
            nodeEntity2 = this.getNodeListEditor().removeLast();
        }
        this.undoStart_ = nodeEntity = this.getNodeListEditor().removeLast();
        this.getNodeListEditor().addLast(nodeEntity);
        this.updateMoveList(nodeEntity);
    }

    @Override
    public void undo() {
        super.undo();
        this.sgfCommand_.undo();
        NodeEntity nodeEntity = this.getNodeListEditor().removeLast();
        while (nodeEntity.equals(this.undoStart_)) {
            nodeEntity = this.getNodeListEditor().removeLast();
        }
        this.updateMoveList(this.undoStart_);
    }

    private void updateMoveList(NodeEntity nodeEntity) {
        GameTree gameTree = nodeEntity.getNodeTree().getGameTree();
        Sequence.Iterator iterator = gameTree.getSequence().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(nodeEntity.getNode())) continue;
            while (iterator.hasNext()) {
                this.getNodeListEditor().addLast(iterator.next(), gameTree);
            }
        }
        GameTree[] gameTreeArray = gameTree.getChildren();
        if (gameTreeArray.length != 0) {
            this.getNodeListEditor().addLast(gameTreeArray[0]);
        }
    }

    @Override
    public EnumSet<ModelInfluence> getInfluence() {
        return EnumSet.of(ModelInfluence.NODE_DOWNWARD, ModelInfluence.NODE_CURRENT);
    }
}

