/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.db;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.SetOperator;
import org.unitarou.yukinoshita.model.db.Term;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TermOperatorTree {
    private Term term_;
    private final List<TermOperatorTree> children_;
    private SetOperator setOperator_;

    public TermOperatorTree() {
        this.term_ = null;
        this.children_ = new ArrayList<TermOperatorTree>();
        this.setOperator_ = SetOperator.INTERSECT;
    }

    public TermOperatorTree(Term term) {
        ArgumentChecker.throwIfNull((Object)term);
        this.term_ = term;
        this.children_ = new ArrayList<TermOperatorTree>();
        this.setOperator_ = SetOperator.INTERSECT;
    }

    public boolean isValid() {
        if (this.children_.isEmpty() && this.term_ == null) {
            return false;
        }
        for (TermOperatorTree termOperatorTree : this.children_) {
            if (termOperatorTree.isValid()) continue;
            return false;
        }
        return true;
    }

    public void setTerm(Term term) {
        this.term_ = term;
    }

    public Term getTerm() {
        return this.term_;
    }

    public void addChild(TermOperatorTree termOperatorTree) {
        ArgumentChecker.throwIfNull((Object)termOperatorTree);
        if (this.hasChild(termOperatorTree)) {
            throw new IllegalArgumentException();
        }
        this.children_.add(termOperatorTree);
    }

    private boolean hasChild(TermOperatorTree termOperatorTree) {
        if (termOperatorTree == this) {
            return true;
        }
        for (TermOperatorTree termOperatorTree2 : this.children_) {
            if (!termOperatorTree2.hasChild(termOperatorTree)) continue;
            return true;
        }
        return false;
    }

    public List<TermOperatorTree> getChildren() {
        return Collections.unmodifiableList(this.children_);
    }

    public void setOperator(SetOperator setOperator) {
        ArgumentChecker.throwIfNull((Object)setOperator);
        this.setOperator_ = setOperator;
    }

    public SetOperator getOperator() {
        return this.setOperator_;
    }
}

