/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.util.Adaptable;
import org.unitarou.yukinoshita.events.WindowControllerListener;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.UpdateProperty;
import org.unitarou.yukinoshita.view.CollectionController;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClearPlPropertyAction
extends Action
implements Adaptable {
    private static final Log log_s_ = LogFactory.getLog(ClearPlPropertyAction.class);
    private static final Message CLB_NAME = new Message(ClearPlPropertyAction.class, "clbName");
    private final Adapter adapter_ = new Adapter();
    private WindowController controller_ = null;
    private Property target_ = null;

    public ClearPlPropertyAction() {
        this.setText(CLB_NAME.get());
        this.setEnabled(false);
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    public ClearPlPropertyAction setController(WindowController windowController) {
        ArgumentChecker.throwIfNull((Object)windowController);
        if (this.controller_ != null) {
            this.controller_.removListener(this.adapter_);
        }
        this.controller_ = windowController;
        this.controller_.addListener(this.adapter_);
        return this;
    }

    @Override
    public void run() {
        this.controller_.getActive().getEventBroker().executeCommand(new UpdateProperty(new Property[]{this.target_}, null, null));
    }

    private class Adapter
    implements ControllerStatusMonitor,
    NodeMonitor,
    WindowControllerListener {
        private Reference<CollectionController> refGfc_ = new WeakReference<Object>(null);

        private Adapter() {
        }

        public void currentChanged(NodeView nodeView) {
            CollectionController collectionController = this.refGfc_.get();
            if (collectionController == null) {
                log_s_.warn("Lost CollectionController (BUG)");
                return;
            }
            ArgumentChecker.throwIfNull((Object)nodeView);
            ClearPlPropertyAction.this.target_ = nodeView.getProperty(SgfId.PLAYER_TO_PLAY);
            ClearPlPropertyAction.this.setEnabled(collectionController.isEditMode() && null != ClearPlPropertyAction.this.target_);
        }

        public void changeActive(CollectionController collectionController) {
            CollectionController collectionController2 = this.refGfc_.get();
            if (collectionController2 != null) {
                collectionController2.getEventBroker().removeView(ClearPlPropertyAction.this);
            }
            this.refGfc_ = new WeakReference<CollectionController>(collectionController);
            ClearPlPropertyAction.this.setEnabled(false);
            if (collectionController != null) {
                collectionController.getEventBroker().addView(ClearPlPropertyAction.this);
                this.currentChanged(collectionController.getCollectionProxy().getActive().getNodeList().getCurrentNodeView());
            }
        }

        public void changeHandlerPhase(HandlerPhase handlerPhase) {
        }

        public void setEditMode(boolean bl) {
            ClearPlPropertyAction.this.setEnabled(bl);
        }
    }
}

