/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.io.File;
import java.util.EnumSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.unitarou.cmd.CommandDriver;
import org.unitarou.io.Ios;
import org.unitarou.ml.BasicMessages;
import org.unitarou.util.Adaptable;
import org.unitarou.yukinoshita.FileManager;
import org.unitarou.yukinoshita.YukinoshitaException;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.WindowControllerListener;
import org.unitarou.yukinoshita.model.cmd.ModelInfluence;
import org.unitarou.yukinoshita.view.CollectionController;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.cmd.FireMonitorCommand;
import org.unitarou.yukinoshita.view.jface.act.AbstractAction;
import org.unitarou.yukinoshita.view.jface.dlg.IgoFileDialog;
import org.unitarou.yukinoshita.view.monitor.CommandDriverMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaveAction
extends AbstractAction
implements Adaptable {
    private static final Log log_s_ = LogFactory.getLog(SaveAction.class);
    private final Adapter adapter_ = new Adapter();

    public SaveAction(WindowController windowController) {
        super(windowController);
        this.controller_.addListener(this.adapter_);
        this.setEnabled(false);
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public void run() {
        if (this.controller_ == null) {
            log_s_.warn("#setController(...) hasn't call yet. #run() call is ignored.");
            return;
        }
        Control control = Display.getCurrent().getFocusControl();
        control.getParent().forceFocus();
        control.forceFocus();
        CollectionController collectionController = this.controller_.getActive();
        boolean bl = FileManager.instance().checkOverwritable(collectionController.getCollection());
        File file = collectionController.getCollection().getFile();
        if ((!bl || Ios.isTemporaryFile(file)) && (file = IgoFileDialog.askSaveFile(collectionController.getCollection())) == null) {
            return;
        }
        try {
            EnumSet<FileManager.SaveResult> enumSet = FileManager.instance().saveAs(collectionController.getCollection(), file);
            FileManager.instance().insertFileHistory(file);
            if (enumSet.contains((Object)FileManager.SaveResult.CHANGE_CHARSET)) {
                FireMonitorCommand fireMonitorCommand = new FireMonitorCommand(ModelInfluence.ROOT_GAME_TREE);
                collectionController.getEventBroker().executeCommand(fireMonitorCommand);
            }
            if (enumSet.contains((Object)FileManager.SaveResult.SAVE_OK)) {
                collectionController.clearChangedFlag();
            }
        }
        catch (YukinoshitaException yukinoshitaException) {
            collectionController.getCollection().setFile(null);
            log_s_.error(BasicMessages.NT_FILE_SAVE_FAILURE.get(), yukinoshitaException);
            MessageDialog.openError(Display.getCurrent().getActiveShell(), BasicMessages.NT_FILE_SAVE_FAILURE.get(), yukinoshitaException.getLocalizedMessage());
        }
    }

    private class Adapter
    implements WindowControllerListener,
    CommandDriverMonitor {
        private EventBroker eventBroker_ = EventBroker.NULL_BROKER;
        private CollectionController gfc_ = null;

        private Adapter() {
        }

        public void changeActive(CollectionController collectionController) {
            this.eventBroker_.removeView(SaveAction.this);
            if (collectionController != null) {
                collectionController.getEventBroker().addView(SaveAction.this);
                SaveAction.this.setEnabled(collectionController.isChanged());
            } else {
                this.eventBroker_ = EventBroker.NULL_BROKER;
                SaveAction.this.setEnabled(false);
            }
            this.gfc_ = collectionController;
        }

        public void commandExecuted(CommandDriver.Status status) {
            SaveAction.this.setEnabled(this.gfc_.isChanged());
        }
    }
}

