/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.unitarou.cmd.CommandDriver;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.ml.Message;
import org.unitarou.sgf.util.provider.crdlp.CoordinatesLabelProvider;
import org.unitarou.util.Adaptable;
import org.unitarou.yukinoshita.events.WindowControllerListener;
import org.unitarou.yukinoshita.model.RgtProxy;
import org.unitarou.yukinoshita.model.cmd.NodeListCommand;
import org.unitarou.yukinoshita.view.CollectionController;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.cmd.UndoComamnd;
import org.unitarou.yukinoshita.view.monitor.CommandDriverMonitor;
import org.unitarou.yukinoshita.view.monitor.ContextMonitor;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UndoAction
extends Action
implements Adaptable {
    private static final Log log_s_ = LogFactory.getLog(UndoAction.class);
    private static final Message CLB_NAME = new Message(UndoAction.class, "clbName");
    private final Adapter adapter_ = new Adapter();
    private WindowController controller_ = null;

    public UndoAction() {
        this.setCommandName("");
        this.setEnabled(false);
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    private void setCommandName(String string) {
        this.setText(CLB_NAME.get((Object)string));
    }

    public UndoAction setController(WindowController windowController) {
        ArgumentChecker.throwIfNull((Object)windowController);
        if (this.controller_ != null) {
            this.controller_.removListener(this.adapter_);
        }
        this.controller_ = windowController;
        this.controller_.addListener(this.adapter_);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.controller_ == null) {
            log_s_.warn("#setController(...) hasn't call yet. #run() call is ignored.");
            return;
        }
        Shell shell = Display.getCurrent().getActiveShell();
        try {
            shell.setEnabled(false);
            CollectionController collectionController = this.controller_.getActive();
            UndoComamnd undoComamnd = new UndoComamnd();
            collectionController.getEventBroker().executeCommand(undoComamnd);
            CommandDriver.Status status = collectionController.getCollectionProxy().getActive().getCommandDriverStatus();
            if (status.getExecutedCommand() instanceof NodeListCommand) {
                collectionController.updateByRedoUndo(((NodeListCommand)status.getExecutedCommand()).getInfluence());
            }
        }
        finally {
            shell.setEnabled(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Adapter
    implements CommandDriverMonitor,
    ControllerStatusMonitor,
    WindowControllerListener,
    GameMonitor,
    ContextMonitor {
        private Reference<CollectionController> refGfc_ = new WeakReference<Object>(null);

        private Adapter() {
        }

        @Override
        public void commandExecuted(CommandDriver.Status status) {
            ArgumentChecker.throwIfNull((Object)status);
            CollectionController collectionController = this.refGfc_.get();
            if (collectionController != null) {
                UndoAction.this.setEnabled(collectionController.isEditMode() && status.isUndoable());
                UndoAction.this.setCommandName(status.getUndoName());
            }
        }

        @Override
        public void changeActive(CollectionController collectionController) {
            CollectionController collectionController2 = this.refGfc_.get();
            if (collectionController2 != null) {
                collectionController2.getEventBroker().removeView(UndoAction.this);
            }
            this.refGfc_ = new WeakReference<CollectionController>(collectionController);
            if (collectionController == null) {
                UndoAction.this.setEnabled(false);
                UndoAction.this.setCommandName("");
                return;
            }
            collectionController.getEventBroker().addView(UndoAction.this);
            CommandDriver.Status status = collectionController.getCollectionProxy().getActive().getCommandDriverStatus();
            UndoAction.this.setEnabled(collectionController.isEditMode() && status.isUndoable());
            UndoAction.this.setCommandName(status.getUndoName());
        }

        @Override
        public void setEditMode(boolean bl) {
            CollectionController collectionController = this.refGfc_.get();
            if (collectionController == null) {
                log_s_.warn("Lost GameFraemController (BUG)");
                return;
            }
            if (bl) {
                CommandDriver.Status status = collectionController.getCollectionProxy().getActive().getCommandDriverStatus();
                UndoAction.this.setEnabled(status.isUndoable());
                UndoAction.this.setCommandName(status.getRedoName());
            } else {
                UndoAction.this.setEnabled(false);
                UndoAction.this.setCommandName("");
            }
        }

        @Override
        public void changeHandlerPhase(HandlerPhase handlerPhase) {
        }

        @Override
        public void update(RgtProxy rgtProxy) {
            this.updateImpl();
        }

        @Override
        public void attributeChanged(Set<String> set) {
            if (set.contains(CoordinatesLabelProvider.CONTEXT.id())) {
                this.updateImpl();
            }
        }

        private void updateImpl() {
            CollectionController collectionController = this.refGfc_.get();
            if (collectionController != null) {
                CommandDriver.Status status = collectionController.getCollectionProxy().getActive().getCommandDriverStatus();
                UndoAction.this.setEnabled(collectionController.isEditMode() && status.isUndoable());
                UndoAction.this.setCommandName(status.getUndoName());
            } else {
                UndoAction.this.setEnabled(false);
                UndoAction.this.setCommandName("");
            }
        }
    }
}

